% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functions.R
\name{inflate}
\alias{inflate}
\title{Inflate Values Based on Percentage Rate, Year, and Baseline Year}
\usage{
inflate(x, percentage_rate, year, baseline_year)
}
\arguments{
\item{x}{A numeric vector or matrix containing the values to be inflated.}

\item{percentage_rate}{A numeric value indicating the percentage rate for inflation.}

\item{year}{The target year for inflation.}

\item{baseline_year}{The baseline year to calculate the inflation from.}
}
\value{
A numeric vector or matrix containing the inflated values.
}
\description{
This function inflates values based on a given percentage rate, year, and baseline year. It calculates the inflated value using the formula: \code{x * (1 + percentage_rate / 100) ^ (year - baseline_year)}.
}
