% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functions.R
\name{get_ons_mrtl}
\alias{get_ons_mrtl}
\title{Get ONS (Office for National Statistics) Mortality Data}
\usage{
get_ons_mrtl(disease, type = c("rate", "absolute"), agegrp_width = c(5L, 20L))
}
\arguments{
\item{disease}{A character string specifying the disease for which mortality data is requested.}

\item{type}{A character vector specifying the type of mortality data to retrieve. Options are "rate" for mortality rates and "absolute" for absolute mortality counts. Default is "rate".}

\item{agegrp_width}{An integer vector specifying the width of age groups in years. Options are 5 or 20. Default is 5.}
}
\value{
A data table containing mortality data for the specified disease, type, and age group width.
}
\description{
This function retrieves mortality data from the Office for National Statistics (ONS) for a specified disease, type, and age group width.
}
