% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functions.R
\name{get_ons_incd}
\alias{get_ons_incd}
\title{Get ONS (Office for National Statistics) Cancer Incidence Data}
\usage{
get_ons_incd(disease, type = c("rate", "absolute"), agegrp_width = 20L)
}
\arguments{
\item{disease}{A character string specifying the cancer type for which incidence data is requested.}

\item{type}{A character vector specifying the type of incidence data to retrieve. Options are "rate" for incidence rates and "absolute" for absolute incidence counts.}

\item{agegrp_width}{An integer specifying the width of age groups in years. Options are 5 or 20. Default is 20.}
}
\value{
A data table containing cancer incidence data for the specified disease, type, and age group width.
}
\description{
This function retrieves cancer incidence data from the Office for National Statistics (ONS) for a specified disease, type, and age group width.
}
