% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functions.R
\name{deflate}
\alias{deflate}
\title{Deflate Values Based on Percentage Rate, Year, and Baseline Year}
\usage{
deflate(x, percentage_rate, year, baseline_year)
}
\arguments{
\item{x}{A numeric vector or matrix containing the values to be deflated.}

\item{percentage_rate}{A numeric value indicating the percentage rate for deflation.}

\item{year}{The target year for deflation.}

\item{baseline_year}{The baseline year to calculate the deflation from.}
}
\value{
A numeric vector or matrix containing the deflated values.
}
\description{
This function deflates values based on a given percentage rate, year, and baseline year. It calculates the deflated value using the formula: \code{x * (1 - percentage_rate / 100) ^ (year - baseline_year)}.
}
