% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functions.R
\name{centile_predictAll}
\alias{centile_predictAll}
\title{Predict Centiles from a GAMLSS Model for Multiple Observations}
\usage{
centile_predictAll(gamlss_model, orig_data, newdata, cent = 0.5)
}
\arguments{
\item{gamlss_model}{A GAMLSS model object created using the \code{gamlss} package.}

\item{orig_data}{The original data used to fit the GAMLSS model.}

\item{newdata}{The new data for which centiles are to be predicted.}

\item{cent}{A numeric value specifying the centile to predict. Default is \code{0.5} (median).}
}
\value{
A numeric vector containing the predicted centiles for each observation in \code{newdata}.
}
\description{
This function predicts centiles from a Generalized Additive Model for Location, Scale, and Shape (GAMLSS) model for multiple observations.
}
