% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SynthPop_class.R
\name{SynthPop}
\alias{SynthPop}
\title{R6 Class representing a synthetic population}
\description{
A synthpop has a \code{pop} field that contains the life course of simulants in a
\code{data.table}.
}
\details{
To be completed...
}
\examples{

## ------------------------------------------------
## Method `SynthPop$new`
## ------------------------------------------------

design <- Design$new("./validation/design_for_trends_validation.yaml")
POP$write_synthpop(1:6, design)
POP <- SynthPop$new(4L, design)
POP$print()
POP$count_synthpop()

POP$delete_synthpop(1L)
POP$delete_synthpop(5:6)
POP$get_filename()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{mc}}{The Monte Carlo iteration of the synthetic population. Every
integer generates a unique synthetic population.}

\item{\code{mc_aggr}}{The Monte Carlo iteration of the synthetic population to
be used when multiple synthetic populations getting aggregated.It
ensures correct seeds for the RNGs during the simulation for the RRs
and the lags.}

\item{\code{metadata}}{Metadata of the synthpop.}

\item{\code{pop}}{The data.table that contains the life-course of simulants.
If the file exists, it is loaded from disk. If it doesn't, it is
first generated, then saved to disk, and then loaded from disk.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SynthPop-new}{\code{SynthPop$new()}}
\item \href{#method-SynthPop-update_design}{\code{SynthPop$update_design()}}
\item \href{#method-SynthPop-update_pop_weights}{\code{SynthPop$update_pop_weights()}}
\item \href{#method-SynthPop-delete_synthpop}{\code{SynthPop$delete_synthpop()}}
\item \href{#method-SynthPop-delete_incomplete_synthpop}{\code{SynthPop$delete_incomplete_synthpop()}}
\item \href{#method-SynthPop-check_integridy}{\code{SynthPop$check_integridy()}}
\item \href{#method-SynthPop-count_synthpop}{\code{SynthPop$count_synthpop()}}
\item \href{#method-SynthPop-get_checksum}{\code{SynthPop$get_checksum()}}
\item \href{#method-SynthPop-get_filename}{\code{SynthPop$get_filename()}}
\item \href{#method-SynthPop-get_design}{\code{SynthPop$get_design()}}
\item \href{#method-SynthPop-get_dir}{\code{SynthPop$get_dir()}}
\item \href{#method-SynthPop-gen_synthpop_demog}{\code{SynthPop$gen_synthpop_demog()}}
\item \href{#method-SynthPop-write_synthpop}{\code{SynthPop$write_synthpop()}}
\item \href{#method-SynthPop-get_risks}{\code{SynthPop$get_risks()}}
\item \href{#method-SynthPop-store_risks}{\code{SynthPop$store_risks()}}
\item \href{#method-SynthPop-print}{\code{SynthPop$print()}}
\item \href{#method-SynthPop-clone}{\code{SynthPop$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-new"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-new}{}}}
\subsection{Method \code{new()}}{
Create a new SynthPop object.
If a synthpop file in \code{\link[fst]{fst-package}} format already
exists, then the synthpop is loaded from there. Otherwise it is
generated from scratch and then saved as \code{filename} in
\code{\link[fst]{fst-package}} format. Two additional files are saved
for each 'synthpop'. A metadata file, and an index file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$new(mc_, design_)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mc_}}{The Monte Carlo iteration of the synthetic population. Each
integer generates a unique synthetic population. If \code{mc = 0} an
object with an empty synthpop is initiated.}

\item{\code{design_}}{A \code{\link[IMPACTncdEngl]{Design}} object.}

\item{\code{synthpop_dir_}}{The directory where 'SynthPop' objects are stored.
The synthpop file in \code{\link[fst]{fst-package}} format. If
\code{filename} already exists, then the synthpop is loaded from there.
Otherwise it is generated from scratch and then saved as \code{filename}
in \code{\link[fst]{fst-package}} format. Two additional files are
saved for each 'synthpop'. A metadata file, and an index file.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{SynthPop} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{design <- Design$new("./validation/design_for_trends_validation.yaml")
POP$write_synthpop(1:6, design)
POP <- SynthPop$new(4L, design)
POP$print()
POP$count_synthpop()

POP$delete_synthpop(1L)
POP$delete_synthpop(5:6)
POP$get_filename()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-update_design"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-update_design}{}}}
\subsection{Method \code{update_design()}}{
Updates the Design object that is stored in the SynthPop object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$update_design(design_)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{design_}}{A design object with the simulation parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-update_pop_weights"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-update_pop_weights}{}}}
\subsection{Method \code{update_pop_weights()}}{
Updates the wt to reflect population change.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$update_pop_weights(scenario_nam = "sc0")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scenario_nam}}{If "sc0" (the baseline scenario) update weights to
scale to ONS projections. Else copy weights from the baseline
scenario to the current scenario for the common person-years.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-delete_synthpop"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-delete_synthpop}{}}}
\subsection{Method \code{delete_synthpop()}}{
Delete (all) synthpop files in the synthpop directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$delete_synthpop(mc_, check_checksum = TRUE, invert = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mc_}}{If \code{mc_ = NULL}, delete all files in the synthpop directory.
If \code{mc_} is an integer vector delete the specific synthpop files
including the metadata and index files.}

\item{\code{check_checksum}}{If  \code{TRUE} only delete files with the same
checksum as the synthpop. Only relevant when \code{mc_ = NULL}.}

\item{\code{invert}}{If \code{TRUE} (default is \code{FALSE}) keeps files with the same
checksum as the synthpop and deletes all other synthpops. Only
relevant when \code{mc_ = NULL} and \code{check_checksum = TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible \code{SynthPop} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-delete_incomplete_synthpop"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-delete_incomplete_synthpop}{}}}
\subsection{Method \code{delete_incomplete_synthpop()}}{
Check that every synthpop file has a metafile and an index file. Delete
any orphan files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$delete_incomplete_synthpop(check_checksum = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{check_checksum}}{If  \code{TRUE} only delete incomplete group files
with the same checksum as the synthpop.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible \code{SynthPop} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-check_integridy"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-check_integridy}{}}}
\subsection{Method \code{check_integridy()}}{
Check the integrity of (and optionally delete) .fst files by checking
their metadata are readable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$check_integridy(remove_malformed = FALSE, check_checksum = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{remove_malformed}}{If \code{TRUE}, delete all malformed .fst files and
their associated files.}

\item{\code{check_checksum}}{If  \code{TRUE} only check files with the same
checksum as the synthpop.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible \code{SynthPop} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-count_synthpop"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-count_synthpop}{}}}
\subsection{Method \code{count_synthpop()}}{
Count the synthpop files in a directory. It includes files without
metafiles and index files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$count_synthpop()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The invisible \code{SynthPop} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-get_checksum"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-get_checksum}{}}}
\subsection{Method \code{get_checksum()}}{
Get the synthpop file paths.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$get_checksum()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{One of "all", "synthpop" or "metafile". Can be abbreviated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible \code{SynthPop} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-get_filename"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-get_filename}{}}}
\subsection{Method \code{get_filename()}}{
Get the synthpop file paths.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$get_filename(x = c("all", "synthpop", "metafile"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{One of "all", "synthpop" or "metafile". Can be abbreviated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible \code{SynthPop} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-get_design"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-get_design}{}}}
\subsection{Method \code{get_design()}}{
Get the synthpop design.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$get_design()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The invisible \code{SynthPop} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-get_dir"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-get_dir}{}}}
\subsection{Method \code{get_dir()}}{
Get the synthpop dir.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$get_dir()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The invisible \code{SynthPop} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-gen_synthpop_demog"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-gen_synthpop_demog}{}}}
\subsection{Method \code{gen_synthpop_demog()}}{
Generate synthpop sociodemographics for a random sample of the population in the initial year.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$gen_synthpop_demog(design_, month = "July")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{design_}}{A Design object,}

\item{\code{month}}{April or July are accepted. Use July for mid-year
population estimates.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An invisible \code{data.table} with sociodemographic information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-write_synthpop"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-write_synthpop}{}}}
\subsection{Method \code{write_synthpop()}}{
Generate synthpop files in parallel, using foreach, and writes them to
disk. It skips files that are already on disk.
Note: the backend for foreach needs to be initialised before calling
the function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$write_synthpop(mc_)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mc_}}{An integer vector for the Monte Carlo iteration of the
synthetic population. Each integer generates a unique synthetic
population.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible \code{SynthPop} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-get_risks"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-get_risks}{}}}
\subsection{Method \code{get_risks()}}{
Get the risks for all individuals in a synthetic
population for a disease.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$get_risks(disease_nam)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{disease_nam}}{The disease that the risks will be returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data.table with columns for pid, year, and all associated
risks if disease_nam is specified. Else a list of data.tables for all
diseases.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-store_risks"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-store_risks}{}}}
\subsection{Method \code{store_risks()}}{
Stores the disease risks for all individuals in a synthetic
population in a private list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$store_risks(disease_nam)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{disease_nam}}{The disease that the risks will be stored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-print"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-print}{}}}
\subsection{Method \code{print()}}{
Prints the synthpop object metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The invisible \code{SynthPop} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SynthPop-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SynthPop-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SynthPop$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
