% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_class.R
\name{Simulation}
\alias{Simulation}
\title{R6 Class representing a simulation environment}
\description{
A simulation environment.
}
\details{
To be completed...
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{design}}{A Design object.}

\item{\code{diseases}}{A list of Disease objects.}

\item{\code{RR}}{A list of RR for the simulated exposures.}

\item{\code{scenarios}}{A list of scenario objects.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Simulation-new}{\code{Simulation$new()}}
\item \href{#method-Simulation-DeployGitHubAssets}{\code{Simulation$DeployGitHubAssets()}}
\item \href{#method-Simulation-update_primary_prevention_scn}{\code{Simulation$update_primary_prevention_scn()}}
\item \href{#method-Simulation-get_primary_prevention_scn}{\code{Simulation$get_primary_prevention_scn()}}
\item \href{#method-Simulation-update_secondary_prevention_scn}{\code{Simulation$update_secondary_prevention_scn()}}
\item \href{#method-Simulation-get_secondary_prevention_scn}{\code{Simulation$get_secondary_prevention_scn()}}
\item \href{#method-Simulation-run}{\code{Simulation$run()}}
\item \href{#method-Simulation-export_summaries}{\code{Simulation$export_summaries()}}
\item \href{#method-Simulation-get_causal_structure}{\code{Simulation$get_causal_structure()}}
\item \href{#method-Simulation-get_node_names}{\code{Simulation$get_node_names()}}
\item \href{#method-Simulation-get_causal_path}{\code{Simulation$get_causal_path()}}
\item \href{#method-Simulation-update_design}{\code{Simulation$update_design()}}
\item \href{#method-Simulation-del_outputs}{\code{Simulation$del_outputs()}}
\item \href{#method-Simulation-del_logs}{\code{Simulation$del_logs()}}
\item \href{#method-Simulation-del_parfs}{\code{Simulation$del_parfs()}}
\item \href{#method-Simulation-del_synthpops}{\code{Simulation$del_synthpops()}}
\item \href{#method-Simulation-get_esp}{\code{Simulation$get_esp()}}
\item \href{#method-Simulation-get_mm_weights}{\code{Simulation$get_mm_weights()}}
\item \href{#method-Simulation-allow_universal_output_folder_access}{\code{Simulation$allow_universal_output_folder_access()}}
\item \href{#method-Simulation-allow_universal_synthpop_folder_access}{\code{Simulation$allow_universal_synthpop_folder_access()}}
\item \href{#method-Simulation-update_output_path}{\code{Simulation$update_output_path()}}
\item \href{#method-Simulation-update_synthpop_path}{\code{Simulation$update_synthpop_path()}}
\item \href{#method-Simulation-print}{\code{Simulation$print()}}
\item \href{#method-Simulation-clone}{\code{Simulation$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-new"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-new}{}}}
\subsection{Method \code{new()}}{
Create a new simulation object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$new(sim_prm)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sim_prm}}{Either a path to a yaml file or a Design object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Simulation} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-DeployGitHubAssets"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-DeployGitHubAssets}{}}}
\subsection{Method \code{DeployGitHubAssets()}}{
This function downloads assets from a GitHub repository and organizes them
in a specified directory structure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$DeployGitHubAssets(args = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{args}}{a list of the above specified parameters}

\item{\code{sToken}}{GitHub personal access token (default: NULL).}

\item{\code{sRepo}}{GitHub repository (default: NULL).}

\item{\code{sTag}}{GitHub tag or release (default: NULL).}

\item{\code{bOverwriteFilesOnDeploy}}{Logical indicating whether to overwrite existing files on deployment (default: no).}

\item{\code{RootDirPath}}{Path to the source directory for upload or deploy (default: NULL).}

\item{\code{simulation_files_overwrite}}{Logical indication whether to overwrite simulation folder files (default: no).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-update_primary_prevention_scn"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-update_primary_prevention_scn}{}}}
\subsection{Method \code{update_primary_prevention_scn()}}{
Updates the primary prevention policy scenario
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$update_primary_prevention_scn(method)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{a function with synthpop as an argument that models the primary prevention policy.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-get_primary_prevention_scn"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-get_primary_prevention_scn}{}}}
\subsection{Method \code{get_primary_prevention_scn()}}{
Get the primary prevention policy scenario
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$get_primary_prevention_scn()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The primary prevention policy scenario.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-update_secondary_prevention_scn"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-update_secondary_prevention_scn}{}}}
\subsection{Method \code{update_secondary_prevention_scn()}}{
Updates the secondary prevention policy scenario
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$update_secondary_prevention_scn(method)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{a function with synthpop as an argument that models the secondary prevention policy.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-get_secondary_prevention_scn"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-get_secondary_prevention_scn}{}}}
\subsection{Method \code{get_secondary_prevention_scn()}}{
Get the secondary prevention policy scenario
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$get_secondary_prevention_scn()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The secondary prevention policy scenario.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-run"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-run}{}}}
\subsection{Method \code{run()}}{
Runs a simulation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$run(mc, multicore = TRUE, scenario_nam)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mc}}{A positive sequential integer vector with the Monte Carlo
iterations of synthetic population to simulate, or a scalar.}

\item{\code{multicore}}{If TRUE run the simulation in parallel.}

\item{\code{scenario_nam}}{A string for the scenario name (i.e. sc1)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-export_summaries"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-export_summaries}{}}}
\subsection{Method \code{export_summaries()}}{
Process the lifecourse files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$export_summaries(
  multicore = TRUE,
  type = c("le", "hle", "dis_char", "prvl", "incd", "dis_mrtl", "mrtl",
    "allcause_mrtl_by_dis", "cms"),
  single_year_of_age = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{multicore}}{If TRUE run the simulation in parallel.}

\item{\code{type}}{The type of summary to extract.}

\item{\code{single_year_of_age}}{Export summaries by single year of age. Useful for the calibration proccess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-get_causal_structure"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-get_causal_structure}{}}}
\subsection{Method \code{get_causal_structure()}}{
Returns the causality matrix and optionally plots the
causality structure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$get_causal_structure(
  processed = TRUE,
  print_plot = FALSE,
  focus = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{processed}}{If \code{TRUE} generates the causality matrix from the
graph.}

\item{\code{print_plot}}{If \code{TRUE} prints the causal structure graph.}

\item{\code{focus}}{If missing the whole causal structure is returned.
Otherwise, if a named node only the subgraph of the 1st order
neighbours that point to the given vertrice is returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The processed causality matrix if \code{processed = TRUE} or the
graph otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-get_node_names"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-get_node_names}{}}}
\subsection{Method \code{get_node_names()}}{
Returns the names of all exposures and diseases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$get_node_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-get_causal_path"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-get_causal_path}{}}}
\subsection{Method \code{get_causal_path()}}{
Returns the causal paths between an exposure and an outcome (disease).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$get_causal_path(from, to, shortest_paths = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{the beginning of the path (an exposure) as a string. Use \code{get_node_names} for available nodes.}

\item{\code{to}}{the end of the path (a disease) as a string. Use \code{get_node_names} for available nodes.}

\item{\code{shortest_paths}}{Boolean. If true, only returns the paths with the smallest number of nodes. Else, all possible paths (excluding multiple and loop edges) are returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with all the possible paths between exposure and disease.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-update_design"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-update_design}{}}}
\subsection{Method \code{update_design()}}{
Updates the Design object that is stored in the Simulation
object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$update_design(new_design)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_design}}{A design object with the simulation parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-del_outputs"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-del_outputs}{}}}
\subsection{Method \code{del_outputs()}}{
Delete all output files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$del_outputs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-del_logs"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-del_logs}{}}}
\subsection{Method \code{del_logs()}}{
Delete log files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$del_logs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-del_parfs"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-del_parfs}{}}}
\subsection{Method \code{del_parfs()}}{
Delete all files in the ./simulation/parf folder.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$del_parfs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-del_synthpops"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-del_synthpops}{}}}
\subsection{Method \code{del_synthpops()}}{
Delete all files in the synthpop folder.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$del_synthpops()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-get_esp"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-get_esp}{}}}
\subsection{Method \code{get_esp()}}{
Get the European Standardised Population 2013 by sex and
dimd.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$get_esp()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data.table with the European Standardised Population 2013.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-get_mm_weights"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-get_mm_weights}{}}}
\subsection{Method \code{get_mm_weights()}}{
Get the disease multimorbidity weights (i.e. Cambridge
Morbidity Score weights).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$get_mm_weights()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named vector with disease weights.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-allow_universal_output_folder_access"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-allow_universal_output_folder_access}{}}}
\subsection{Method \code{allow_universal_output_folder_access()}}{
Make output folder available to all users (Linux specific).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$allow_universal_output_folder_access()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-allow_universal_synthpop_folder_access"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-allow_universal_synthpop_folder_access}{}}}
\subsection{Method \code{allow_universal_synthpop_folder_access()}}{
Make synthpop folder available to all users (Linux specific).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$allow_universal_synthpop_folder_access()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-update_output_path"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-update_output_path}{}}}
\subsection{Method \code{update_output_path()}}{
Updates the output path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$update_output_path(new_path, carry_over_lifecourse_files_from)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_path}}{A string with the new output path (absolute).}

\item{\code{carry_over_lifecourse_files_from}}{A string with a previous output
path (absolute) from which the lifecourse files will be copied to the
new output folder defined in new_path argument. Overwritting is not
allowed. If missing, no copy occurs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-update_synthpop_path"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-update_synthpop_path}{}}}
\subsection{Method \code{update_synthpop_path()}}{
Updates the synthpop path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$update_synthpop_path(new_path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_path}}{A string with the new synthpop path (absolute).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The invisible self for chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-print"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-print}{}}}
\subsection{Method \code{print()}}{
Prints the simulation object metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The invisible \code{Simulation} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Simulation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Simulation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
