% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design_class.R
\name{Design}
\alias{Design}
\title{R6 Class representing a simulation design}
\description{
A design has a sim_prm list that holds the simulation parameters.
This R6 class represents a simulation design with associated parameters and methods.
}
\details{
To be completed...
}
\examples{

## ------------------------------------------------
## Method `Design$new`
## ------------------------------------------------

design <- Design$new("./validation/design_for_trends_validation.yaml")
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{sim_prm}}{The simulation parameters.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Design-new}{\code{Design$new()}}
\item \href{#method-Design-save_to_disk}{\code{Design$save_to_disk()}}
\item \href{#method-Design-update_fromGUI}{\code{Design$update_fromGUI()}}
\item \href{#method-Design-print}{\code{Design$print()}}
\item \href{#method-Design-clone}{\code{Design$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Design-new"></a>}}
\if{latex}{\out{\hypertarget{method-Design-new}{}}}
\subsection{Method \code{new()}}{
Create a new design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Design$new(sim_prm)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sim_prm}}{Either a path to a yaml file or a list with
appropriate format.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Design} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{design <- Design$new("./validation/design_for_trends_validation.yaml")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Design-save_to_disk"></a>}}
\if{latex}{\out{\hypertarget{method-Design-save_to_disk}{}}}
\subsection{Method \code{save_to_disk()}}{
Create a new design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Design$save_to_disk(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path including file name and extension to save a yaml
file with the simulation parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{Design} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Design-update_fromGUI"></a>}}
\if{latex}{\out{\hypertarget{method-Design-update_fromGUI}{}}}
\subsection{Method \code{update_fromGUI()}}{
Updates the design object from GUI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Design$update_fromGUI(GUI_prm)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{GUI_prm}}{A GUI parameter object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{Design} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Design-print"></a>}}
\if{latex}{\out{\hypertarget{method-Design-print}{}}}
\subsection{Method \code{print()}}{
Print the simulation parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Design$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{Design} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Design-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Design-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Design$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
