"""
Django settings for DTMOB_webapp project.

Generated by 'django-admin startproject' using Django 5.1.3.

For more information on this file, see
https://docs.djangoproject.com/en/5.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.1/ref/settings/
"""

import os
from pathlib import Path

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent
DATA_DIR = Path(os.getenv("DATA_DIR", "../../data/webapp")).resolve()
LOGS_DIR = Path(os.getenv("LOGS_DIR", "../../logs/webapp")).resolve()

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = os.environ["DJANGO_SECRET_KEY"]

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = os.environ["DJANGO_DEBUG"] == "1"

_DJANGO_PROTOCOL_HOST_PORT = [
    s.split(":") for s in os.environ["DJANGO_PROTOCOL_HOST_PORT"].split(",")
]

if not _DJANGO_PROTOCOL_HOST_PORT:
    raise ValueError(
        "DJANGO_PROTOCOL_HOST_PORT environment variable is not set or is empty."
    )

if any(len(host_port) != 3 for host_port in _DJANGO_PROTOCOL_HOST_PORT):
    raise ValueError(
        "DJANGO_PROTOCOL_HOST_PORT environment variable must be in the format "
        " 'protocol:host:port,protocol:host:port'."
    )

if any(not host_port[0] for host_port in _DJANGO_PROTOCOL_HOST_PORT):
    raise ValueError("Protocol in DJANGO_PROTOCOL_HOST_PORT cannot be empty.")
if any(not host_port[1] for host_port in _DJANGO_PROTOCOL_HOST_PORT):
    raise ValueError("Host in DJANGO_PROTOCOL_HOST_PORT cannot be empty.")
if any(not host_port[2].isdigit() for host_port in _DJANGO_PROTOCOL_HOST_PORT):
    raise ValueError("Port in DJANGO_PROTOCOL_HOST_PORT must be a valid integer.")

ALLOWED_HOSTS = [host for _, host, _ in _DJANGO_PROTOCOL_HOST_PORT]

# Application definition

INSTALLED_APPS = [
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.staticfiles",
    "frontend",
    "api.general",
    "api.agent_calendar",
    "api.distrib",
    "api.forecast",
    "api.map",
    "api.stats",
    "api.whatif",
]

MIDDLEWARE = [
    "django.middleware.security.SecurityMiddleware",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
]

ROOT_URLCONF = "DTMOB_webapp.urls"

TEMPLATES = [  # type: ignore
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [BASE_DIR / "templates"],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ],
        },
    }
]

WSGI_APPLICATION = "DTMOB_webapp.wsgi.application"


# Database
# https://docs.djangoproject.com/en/5.1/ref/settings/#databases

DATABASES = {  # type: ignore
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": BASE_DIR / "db.sqlite3",
    }
}


# Password validation
# https://docs.djangoproject.com/en/5.1/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        "NAME": "django.contrib.auth.password_validation.UserAttributeSimilarityValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.MinimumLengthValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.CommonPasswordValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.NumericPasswordValidator",
    },
]


# Internationalization
# https://docs.djangoproject.com/en/5.1/topics/i18n/

LANGUAGE_CODE = "en-us"

TIME_ZONE = os.environ["TZ"]

USE_I18N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.1/howto/static-files/

STATIC_URL = "/static/"

STATICFILES_DIRS = [BASE_DIR / "staticfiles", BASE_DIR / "static"]


# Default primary key field type
# https://docs.djangoproject.com/en/5.1/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = "django.db.models.BigAutoField"

STATIC_ROOT = BASE_DIR.parent / "static"

# CSRF settings
CSRF_TRUSTED_ORIGINS = [
    f"{conn}://{host}:{port}" for conn, host, port in _DJANGO_PROTOCOL_HOST_PORT
]

SESSION_COOKIE_AGE = 4 * 60 * 60
SESSION_EXPIRE_AT_BROWSER_CLOSE = False
