#!/bin/bash

# Configuration
BASE_DIR="/home/merve/cheri/blinded-cheri-sw/benchmarks/synthetic-benchmark"
PORT_DIR="riscv-bare-metal"
GFE_TARGET="P3"
CHERI=1
POINTER_SPACE=16
TOOLCHAIN="LLVM"
TLSF=1
FPGA=1
XCFLAGS="-I$BASE_DIR/include -I$BASE_DIR/include/kremlib -DPERFORMANCE_RUN=1"

for SUFFIX in 10 25 50 75; do
    SPEC_FILE="$BASE_DIR/specBench_$SUFFIX"
    OUT="chacha_spec_cheri_$SUFFIX"

    echo "🔧 Building for specBench_$SUFFIX → $OUT.elf"


    make \
        PORT_DIR=$PORT_DIR \
        GFE_TARGET=$GFE_TARGET \
        CHERI=$CHERI \
        POINTER_SPACE=$POINTER_SPACE \
        TOOLCHAIN=$TOOLCHAIN \
        TLSF=$TLSF \
        FPGA=$FPGA \
        CORE_FILES="$BASE_DIR/Hacl_Chacha20 $SPEC_FILE" \
        XCFLAGS="$XCFLAGS" \
        OUT=$OUT

    echo "Done: $OUT_cheri.elf"
    echo "--------------------------------------------"
done


#!/bin/bash

# Configuration
BASE_DIR="/home/merve/cheri/blinded-cheri-sw/benchmarks/synthetic-benchmark"
PORT_DIR="riscv-bare-metal"
GFE_TARGET="P3"
CHERI=0
TOOLCHAIN="LLVM"
TLSF=1
FPGA=1
XCFLAGS="-I$BASE_DIR/include -I$BASE_DIR/include/kremlib -DPERFORMANCE_RUN=1"

for SUFFIX in 10 25 50 75; do
    SPEC_FILE="$BASE_DIR/specBench_$SUFFIX"
    OUT="chacha_spec_non_cheri$SUFFIX"

    echo " Building for specBench_$SUFFIX → $OUT.elf"


    make \
        PORT_DIR=$PORT_DIR \
        GFE_TARGET=$GFE_TARGET \
        CHERI=$CHERI \
        TOOLCHAIN=$TOOLCHAIN \
        TLSF=$TLSF \
        FPGA=$FPGA \
        CORE_FILES="$BASE_DIR/Hacl_Chacha20 $SPEC_FILE" \
        XCFLAGS="$XCFLAGS" \
        OUT=$OUT

    echo "Done: $OUT_noncheri.elf"
    echo "--------------------------------------------"
done
