#!/bin/bash

# Set base path
BASE_DIR="/home/merve/cheri/blinded-cheri-sw/benchmarks"

# Folders to compile from
MODES=("risc_oblivious_blinded" "risc_oblivious_hybrid" "risc_oblivious_nonblinded")

# Binary prefixes to compile
PREFIXES=(12 14 16 18 20)


for prefix in "${PREFIXES[@]}"; do
  core_file="${BASE_DIR}/risc_oblivious_blinded/binary_search_${prefix}"
  outname="binary_search_${prefix}_blinded"

  echo "Building $outname from $core_file"

  make PORT_DIR=riscv-bare-metal GFE_TARGET=P3 CHERI=1 POINTER_SPACE=16 FPGA=1  TOOLCHAIN=LLVM TLSF=1 \
  CORE_FILES=$core_file \
  OUT=$outname 
done


for prefix in "${PREFIXES[@]}"; do
  core_file="${BASE_DIR}/risc_oblivious_nonblinded/binary_search_${prefix}"
  outname="binary_search_${prefix}_hybrid"

  echo "Building $outname from $core_file"

  make PORT_DIR=riscv-bare-metal GFE_TARGET=P3 POINTER_SPACE=16 FPGA=1  TOOLCHAIN=LLVM TLSF=1  CORE_FILES=$core_file OUT=$outname 
done


for prefix in "${PREFIXES[@]}"; do
  core_file="${BASE_DIR}/risc_oblivious_nonblinded/binary_search_${prefix}"
  outname="binary_search_${prefix}_nonblinded"

  echo "Building $outname from $core_file"

  make PORT_DIR=riscv-bare-metal GFE_TARGET=P3 POINTER_SPACE=16 FPGA=1 CHERI=1 TOOLCHAIN=LLVM TLSF=1 \
  CORE_FILES=$core_file \
  OUT=$outname 
done
