#!/usr/bin/env bash

set -x

# Function to wait until all specified containers are terminated
wait_for_containers_to_terminate() {
  local container_names=("$@")
  local all_terminated=false

  while [ "$all_terminated" = false ]; do
    all_terminated=true
    for container_name in "${container_names[@]}"; do
      if [ "$(docker ps -q -f name=$container_name)" ]; then
        all_terminated=false
      fi
    done
    sleep 5
  done
}

# Function to get container names from docker compose
get_container_names() {
  docker compose ps -q | xargs -I {} docker inspect --format '{{.Name}}' {} | sed 's/^\///'
}

# Function to run the monitor with a specific client count
run_monitor() {
  local client_count=$1
  echo "Running monitor with $client_count clients"
  CLIENT_COUNT=$client_count docker compose up -d &> /dev/null
  container_names=$(get_container_names)
  wait_for_containers_to_terminate $container_names
  docker compose logs wireguard-eval --no-log-prefix
}

# Remove existing logs
rm -r logs

# Pulling/buidling the containers
docker compose build --quiet

# Run the monitor with different client counts
for client_count in 10 50 75 100; do
  run_monitor $client_count
done
