#!/usr/bin/env bash

# Store pre-trace for debugging
python3 pre-trace.py --format=json /etc/wireguard/server/private-key-server "/etc/wireguard/clients" "$CLIENT_COUNT" > /tmp/server-pre-trace.log

# Start SpecMon monitoring in background
/usr/bin/time -v -o "/tmp/time-monitor.log" specmon monitor --in "$GO_ANNOTATE_LOG_TARGET" -D SPECMON --rewrite-with go-rewrite.spthy --pre-trace /tmp/server-pre-trace.log wireguard.spthy 2> "/tmp/specmon.log" &


sleep 2

# Set up WireGuard interface

wireguard-go wg0
ip -4 addr add 10.0.0.1/32 dev wg0

# Set private key for the server
wg set wg0 private-key /etc/wireguard/server/private-key-server

# Set the listening port
wg set wg0 listen-port 51820

# Enable IP forwarding
sysctl -w net.ipv4.ip_forward=1

ENDPOINT_IP=$(getent hosts wireguard-clients | awk '{ print $1 }')
printf "IP Address of clients container: %s\n" "$ENDPOINT_IP"

ip -4 link set mtu 1420 up dev wg0
ip -4 route add 10.0.0.0/24 dev wg0

# Configure each client
for i in $(seq 1 "$CLIENT_COUNT"); do
    CLIENT_IP="10.0.0.$((1 + i))"
    CLIENT_PORT=$((51820 + i))

    PUBLIC_KEY=$(cat "/etc/wireguard/clients/public-key-client-$i")

    # Add the peer to the WireGuard server configuration
    wg set wg0 peer "$PUBLIC_KEY" allowed-ips "$CLIENT_IP/32" endpoint "$ENDPOINT_IP:$CLIENT_PORT"

    echo "Configured client $i with IP $CLIENT_IP and port $CLIENT_PORT"
done

# Wait for the clients to be ready
while [ ! -f /tmp/clients-done ]; do
    echo "Waiting for clients to finish"
    sleep 1
done

# Ping each client
for i in $(seq 1 "$CLIENT_COUNT"); do
   CLIENT_IP="10.0.0.$((1 + i))"

   echo "Pinging $CLIENT_IP..."
   ping -c 1 "$CLIENT_IP"
   
   sleep 0.1
done

# Wait for the last ping to complete
sleep 30

# Signal clients we are done
touch /tmp/server-done

# Stop the monitor
pkill specmon

sleep 5
