#!/bin/bash

# Get the project name (usually the parent directory's name)
PROJECT_NAME=$(basename "$PWD")

echo "Project name detected as: ${PROJECT_NAME}"

mkdir -p ../images

# Loop through each service defined in docker-compose.yml
for service in $(docker compose config --services); do
  IMAGE_NAME="${PROJECT_NAME}-${service}"
  OUTPUT_FILE="../images/${service}.tar.gz"
  
  echo "➡️  Exporting image '${IMAGE_NAME}' to '${OUTPUT_FILE}'..."
  
  # Save the multi-platform image to a tarball
  docker save "${IMAGE_NAME}" -o "${OUTPUT_FILE}"
  
  echo "✅  Successfully created ${OUTPUT_FILE}"
  echo ""
done

echo "🚀 All images have been exported."
