# GEO Mountains Inventory of In Situ Observational Infrastructure v3

This repository contains the **GEO Mountains Inventory of In Situ Observational Infrastructure v3**.  

The data are provided in two formats:

1. **GEO_Mountains_In_Situ_Inventory_v3.0.csv** – A flat tabular format  
2. **GEO_Mountains_In_Situ_Inventory_v3.0.gpkg** – A spatial file format which can be viewed directly in GIS software like QGIS (drag and drop).  

The inventory is also presented as a simple web map here:  
👉 [https://geomountains.github.io/in_situ_inventory/](https://geomountains.github.io/in_situ_inventory/)

The web map also shows mountain range polygons according to the **GMBA Mountain Inventory v2** (“Broad, 300 Selection”):  

- Snethlage, M.A., Geschke, J., Spehn, E.M., Ranipeta, A., Yoccoz, N.G., Körner, Ch., Jetz, W., Fischer, M. & Urbach, D. (2022). *A hierarchical inventory of the world’s mountains for global comparative mountain science*. Nature Scientific Data. [https://doi.org/10.1038/s41597-022-01256-y](https://doi.org/10.1038/s41597-022-01256-y)  
- Snethlage, M.A., Geschke, J., Spehn, E.M., Ranipeta, A., Yoccoz, N.G., Körner, Ch., Jetz, W., Fischer, M. & Urbach, D. (2022). *GMBA Mountain Inventory v2*. GMBA-EarthEnv. [https://doi.org/10.48601/earthenv-t9k2-1407](https://doi.org/10.48601/earthenv-t9k2-1407)  

---

## Aims, Scope, and Development Process

The inventory aims to capture fundamental metadata which can be used to:  

1. Characterise past and ongoing sustained in situ monitoring and data collection efforts spanning multiple disciplines.  
2. Find, access, and use the corresponding observations (generally time-series).  
3. Identify existing gaps in data coverage (spatially, by elevation, by variable/theme, by time period, or some combination of the above) to inform future infrastructure expansion.  
4. Enhance collaboration on monitoring and data exchange between institutions and disciplinary communities.  

Development history:  
- **v1** released July 2021  
- **v2** released October 2022  
- **v3** released August 2025  

For v3, sites are considered mountainous if they fall within one of the GMBA mountain range polygons, which cover the three “K” mountain delineations. All records are attributed with a “Main Network / Compilation” to which they belong.  

### Notes on Version 3
- Stations from each network are presented independently. This means that some stations may appear in multiple layers. This approach avoids erroneously removing distinct stations when attempting to de-duplicate.  
- Not all stations are associated with free and open datasets, although this number is increasing.  
- Records include both *research-oriented stations* (e.g. university sites, often missing from larger databases) and *operational stations* (e.g. national agencies).  
- Unlike inventories focused on one Earth system component (e.g. only climate or hydrosphere), this dataset spans multiple disciplines and monitoring strategies.  
- Sites contributed by GEO Mountains network members and those involved in GEO Mountains Small Grants projects (2023–2025) are included.  
- Sites should be *sustained*. Short-term campaigns (e.g. one summer) are excluded. Long-term historical sites that are no longer operational can be included due to their valuable datasets. 
- Fields which still require metadata adding are left NULL.  

---

## Available Metadata Fields (v3)

| Column Name                       | Description                                                                 |
|-----------------------------------|-----------------------------------------------------------------------------|
| `GEO_Mountains_v3_ID`             | Unique identifier for the site                                               |
| `Name`                            | Site name                                                                   |
| `Latitude`                        | Latitude (decimal degrees)                                                   |
| `Longitude`                       | Longitude (decimal degrees)                                                  |
| `Elevation`                       | Elevation (meters)                                                           |
| `Country`                         | Country name                                                                |
| `Mountain_Range_GMBA_v2`          | Mountain range (GMBA v2 classification)                                      |
| `Purpose`                         | Main purpose (e.g., Operational)                                            |
| `Type`                            | Environment type (e.g., Land, Lake, Glacier)                                |
| `Operating_Organisation`          | Institution responsible for operating the site                               |
| `Site_Description_or_Data_Access` | Description of site and/or data access link                                  |
| `Contact_Email`                   | Contact email (if available)                                                 |
| `Variables_Measured`              | Variables monitored (if available)                                           |
| `Record_Start`                    | Start year of records                                                        |
| `Record_End`                      | End year of records (if applicable)                                          |
| `Frequency`                       | Measurement frequency                                                        |
| `Methods_Protocols`               | Methods or protocols used                                                     |
| `Instrumentation`                 | Instruments used                                                             |
| `Open_Data`                       | Indicates if data is openly available (Yes/No)                               |
| `Associated_Publications`         | Relevant publications (if available)                                         |
| `Local_Network`                   | Local network affiliation                                                     |
| `Main_Network`                    | Main/global network affiliation                                              |
| `Comments`                        | Additional notes (e.g., WIGOS ID, site-specific details)                      |

---

## Citation and Permitted Uses

To facilitate long-term discoverability and unique citation, v3 of the inventory has been deposited on Zenodo:  
👉 [https://doi.org/10.5281/zenodo.17020536](https://doi.org/10.5281/zenodo.17020536)  

**Suggested citation:**  

> GEO Mountains (2025). Inventory of in situ mountain observational infrastructure, v3.0. DOI: 10.5281/zenodo.17020536  

⚠️ Only **scientific and non-commercial uses** are permitted.  

---

**Dr. James M. Thornton, August 2025**  
