data = load('cos.dat'); % Load cos data file
positions = data(:, 1); % Extract positions (first column)
dimensions = data(:, 2); % Extract dimensions (second column)
values = data(:, 3); % Extract sine values (third column)
% Find unique dimensions
unique_dims = unique(dimensions);
% Plot sine values for each dimension
figure;
hold on;
for i = 1:length(unique_dims)
%for i = 1:3
    dim = unique_dims(i);
    mask = dimensions == dim; % Select data for current dimension
    plot(positions(mask), values(mask), 'DisplayName', ['Dim ', num2str(dim)]);
end
hold off;
title('Cosin Positional Encoding');
xlabel('Position');
ylabel('Sine Value');
legend('show');
grid on;
