# Deblometer  
A Java Debloating Benchmark  

Deblometer consists of two main components:

1. **Analysis** (in the `Analysis` folder)  
   This contains the logic of the Deblometer analysis.  
   It requires:  
   - The **compiled ground truth code**  
   - The **JSON ground truth files** corresponding to the tested language features  

   Both the compiled ground truth JARs and the JSON files are already included in the resource folder (`undebloated Jars`) inside the `Analysis` directory and can be directly used for testing.  

2. **Groundtruth** (in the `DeblometerGroundtruth` folder)  
   This contains the language feature modules that define the ground truth.  
   Each module provides:  
   - The source code of the feature under test  
   - The JSON file with the expected outcome  

   The undebloated JARs used in the analysis can be generated by compiling these modules.

This setup allows you to evaluate the precision and soundness of the **debloating tool of your choice** with the Deblometer analysis.

## Installation Process

The installation process consists of four steps:

1. **Compile the Ground Truth language feature modules**  
   In each module inside the `DeblometerGroundtruth` folder, run:
   ```bash
   mvn compile package
2. **debloat** the produced JARs using the debloating tool of your choice.
3. In the Analysis resources folder, create a folder for the debloated JARs (e.g., `Analysis/src/main/resources/debloated-jars/`), copy the debloated JARs there, and update the path variable **`debloatedJarsFolder`** inside `Deblometer.java` to point to this folder.
4. Run the project

