/**#######################################
 Testing the overriding method resolution concept.

 In this test "add" method from the "OR02_AdvanceCalculator" should be removed. Hence, "OR02_AdvanceCalculator" class is also
 not required.

 Reason: Since method resolution in overriding is based on the Runtime object, that is OR02_SimpleCalculator,so in this
 example method of the parent class will be called.


 "class": {"required": [{"package": "Overriding","name": "OR_Standard_01"},
 {"package": "Overriding","name": "OR_Standard_01_SimpleCalculator"}],

 "bloated":[{"package": "Overriding","name": "OR_Standard_01_AdvanceCalculator"}] }

 "method":{ "required":
 [{"type": "OR_Standard_01_SimpleCalculator","name": "add","return": "void","param": "(int , int )"}
 ],
 "bloated":
 [{"type": "OR_Standard_01_AdvanceCalculator","name": "add","return": "void","param": "(int , int )"}]}

 #######################################**/
package Overriding;

class OR_Standard_01_SimpleCalculator{
    public void add(int n1,int n2 ){
        System.out.println(n1+n2);
    }
}

class OR_Standard_01_AdvanceCalculator extends OR_Standard_01_SimpleCalculator {
    public void add(int n1, int n2) {
        System.out.println(n1 + "+" + n2 + "=" + (n1 + n2));
    }
}

public class OR_Standard_01 {
    public static void main(String[] args) {
        OR_Standard_01_SimpleCalculator calc = new OR_Standard_01_SimpleCalculator();
        calc.add(2,3);
    }
}

