/**#######################################
 Testing the overriding method resolution concept.

 In this test "add" method from the "OR03_SimpleCalculator" should be removed.

 Reason: Since method resolution in overriding is based on the Runtime object, that is OR03_AdvanceCalculator in this
 example so the method of the child class will be called.

 "class": {"required": [{"package": "Overriding","name": "OR_Polymorphic_00"},
 {"package": "Overriding","name": "OR_Polymorphic_00_SimpleCalculator"},
 {"package": "Overriding","name": "OR_Polymorphic_00_AdvanceCalculator"}],

 "bloated":[] }

 "method":{ "required":
 [{"type": "OR_Polymorphic_00_AdvanceCalculator","name": "add","return": "void","param": "(int , int )"}
 ],
 "bloated":
 [{"type": "OR_Polymorphic_00_SimpleCalculator","name": "add","return": "void","param": "(int , int )"}]}

 #######################################**/
package Overriding;

class OR_Polymorphic_00_SimpleCalculator{
    public void add(int n1,int n2 ){
        System.out.println(n1+n2);
    }
}

class OR_Polymorphic_00_AdvanceCalculator extends OR_Polymorphic_00_SimpleCalculator {
    public void add(int n1, int n2) {
        System.out.println(n1 + "+" + n2 + "=" + (n1 + n2));
    }
}

public class OR_Polymorphic_00 {
    public static void main(String[] args) {
        OR_Polymorphic_00_SimpleCalculator calc = new OR_Polymorphic_00_AdvanceCalculator();

        calc.add(2,3);
    }
}

