/***********************
 CLASS
 "required": [{"package": "Generics","name": "GR_Interface_00_Processor"},
 {"package": "Generics","name": "GR_Interface_00_StringProcessor"},
 {"package": "Generics","name": "GR_Interface_00"}]

 "bloated":[{"package": "Generics","name": "GR_Interface_00_IntProcessor"}]

 METHOD
 "required": [{"type": "GR_Interface_00_StringProcessor","name": "process","return": "void","param": "(String)"}]

 "bloated":  [{"type": "GR_Interface_00_Processor","name": "process","return": "void","param": "(java.lang.Object)"},
 {"type": "GR_Interface_00_IntProcessor","name": "process","return": "void","param": "(java.lang.Integer)"}]

 FIELD
 "required": [],

 "bloated":[{"class": "GR_Interface_00_Processor","name": "value"},
 {"class": "GR_Interface_00_Processor","name": "container"}
 ]
 *************************/

package Generics;

interface GR_Interface_00_Processor<T> {
    int value = 42;
    String container = "obsolete";

    void process(T input);
}

class GR_Interface_00_StringProcessor implements GR_Interface_00_Processor<String> {
    public void process(String input) {
        System.out.println(input.toUpperCase() + ": " + value);
    }
}

class GR_Interface_00_IntProcessor implements GR_Interface_00_Processor<Integer> {
    public void process(Integer input) {
        System.out.println(input);
    }
}

public class GR_Interface_00 {

    public static void main(String[] args) {
        GR_Interface_00_StringProcessor processor = new GR_Interface_00_StringProcessor();
        processor.process("Hello World");
    }
}
