/***********************
CLASS
"required": [{"package": "Generics","name": "GR_InterfaceComposition_00"},{"package": "Generics","name": "GR_InterfaceComposition_00_Drawable"},
 {"package": "Generics","name": "GR_InterfaceComposition_00_Paint"},{"package": "Generics","name": "GR_InterfaceComposition_00_rectangle"},
 {"package": "Generics","name": "GR_InterfaceComposition_00_ShapeContainer"}],

"bloated":[] }

METHOD
"required": [{"type": "GR_InterfaceComposition_00_ShapeContainer","name": "drawShape","return": "void","param": ""},
 {"type": "GR_InterfaceComposition_00_rectangle","name": "draw","return": "void","param": ""},
 ],

"bloated":  [{"type": "GR_InterfaceComposition_00_Drawable","name": "draw","return": "void","param": ""},
 {"type": "GR_InterfaceComposition_00_Paint","name": "draw","return": "void","param": ""}]

FIELD
"required": [],

"bloated":[]
*************************/


package Generics;
// Interface
interface GR_InterfaceComposition_00_Drawable {
    void draw();
}

// Interface
interface GR_InterfaceComposition_00_Paint {
    void draw();
}


class GR_InterfaceComposition_00_rectangle implements GR_InterfaceComposition_00_Paint , GR_InterfaceComposition_00_Drawable {
    @Override
    public void draw() {
        System.out.println("GR_InterfaceComposition_00 Drawing a rectangle");
    }
}

class GR_InterfaceComposition_00_ShapeContainer<T extends GR_InterfaceComposition_00_Paint & GR_InterfaceComposition_00_Drawable> {
    public T shape;

    public GR_InterfaceComposition_00_ShapeContainer(T shape) {
        this.shape = shape;
    }

    public void drawShape() {
        shape.draw();
    }
}

public class GR_InterfaceComposition_00 {
    public static void main(String[] args) {
        GR_InterfaceComposition_00_rectangle circle = new GR_InterfaceComposition_00_rectangle();
        GR_InterfaceComposition_00_ShapeContainer<GR_InterfaceComposition_00_rectangle> container = new GR_InterfaceComposition_00_ShapeContainer<GR_InterfaceComposition_00_rectangle>(circle);
        container.drawShape();
    }
}
