/***********************
 CLASS
 "required": [{"package": "Generics","name": "GR_Inheritance_00"},
 {"package": "Generics","name": "GR_Inheritance_00_Animal"},
 {"package": "Generics","name": "GR_Inheritance_00_Cat"},
 {"package": "Generics","name": "GR_Inheritance_00_Printer"}]
 "bloated": [{"package": "Generics","name": "GR_Inheritance_00_Dog"}]

 METHOD
 "required": [{"type": "GR_Inheritance_00_Cat","name": "eat","return": "void","param": "()"},
 {"type": "GR_Inheritance_00_Printer","name": "print","return": "void","param": "()"}]

 "bloated":  [{"type": "GR_Inheritance_00_Animal","name": "eat","return": "void","param": "()"}]

 FIELD
 "required": [{"class": "GR_Inheritance_00_Printer","name": "thingToPrint"}]

 "bloated":[{"class": "GR_Inheritance_00_Animal","name": "age"},
 {"class": "GR_Inheritance_00_Cat","name": "name"}]
 *************************/

package Generics;

class GR_Inheritance_00_Animal{
    int age;

    public void eat(){
        System.out.println("GNR100_2 Animal eats");
    }

}

class GR_Inheritance_00_Dog extends GR_Inheritance_00_Animal{
}

class GR_Inheritance_00_Cat extends GR_Inheritance_00_Animal{
    String name;

    public void eat(){
        System.out.println("GNR100_2 Cat eats");
    }
}

class GR_Inheritance_00_Printer<T extends GR_Inheritance_00_Animal>{
    T thingToPrint;

    public GR_Inheritance_00_Printer(T thingToPrint){
        this.thingToPrint = thingToPrint;
    }

    public void print(){
        thingToPrint.eat();
    }
}

public class GR_Inheritance_00 {
    public static void main(String[] args) {
        GR_Inheritance_00_Printer<GR_Inheritance_00_Cat> printer = new GR_Inheritance_00_Printer<>(new GR_Inheritance_00_Cat());
        printer.print();
    }
}
