/************************
 CLASS
 "required": [{"package": "Externalization","name": "EXT_Write_00"},{"package": "Externalization","name": "EXT_Write_00_Person"}],

 "bloated":[{"package": "Externalization","name": "EXT_Write_00_Animal"}]

 METHOD
 "required": [{"type": "EXT_Write_00_Person","name": "writeExternal","return": "void","param": "java.io.ObjectOutput"}],

 "bloated":  [{"type": "EXT_Write_00_Person","name": "readExternal","return": "void","param": "java.io.ObjectInput"},
 {"type": "EXT_Write_00_Animal","name": "readExternal","return": "void","param": "java.io.ObjectInput"},
 {"type": "EXT_Write_00_Animal","name": "writeExternal","return": "void","param": "java.io.ObjectOutput"}
 ]

 FIELD
 "required": [{"class": "EXT_Write_00_Person","name": "name"},
 {"class": "EXT_Write_00_Person","name": "age"}]

 "bloated":[{"class": "EXT_Write_00_Person","name": "surname"},
 {"class": "EXT_Write_00_Animal","name": "name"},
 {"class": "EXT_Write_00_Animal","name": "age"},
 ]
 *************************/
package Externalization;

import java.io.*;

class EXT_Write_00_Person implements Externalizable {
    private String name;
    private String surname;
    private int age;

    public EXT_Write_00_Person() {

    }

    public EXT_Write_00_Person(String name, int age) {
        this.name = name;
        this.age = age;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(name);
        out.writeInt(age);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        name = (String) in.readObject();
        age = in.readInt();
    }
}

class EXT_Write_00_Animal implements Externalizable {
    private String name;
    private int age;

    public EXT_Write_00_Animal() {

    }

    public EXT_Write_00_Animal(String name, int age) {
        this.name = name;
        this.age = age;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(name);
        out.writeInt(age);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        name = (String) in.readObject();
        age = in.readInt();
    }
}

public class EXT_Write_00 {
    public static void main(String[] args) throws Exception {

        EXT_Write_00_Person person = new EXT_Write_00_Person("Sam",42);
        FileOutputStream fos = new FileOutputStream("EXT_Write_00.ser");
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(person);
    }
}
