/************************
 CLASS
 "required": [{"package": "Externalization","name": "EXT_Read_00"},{"package": "Externalization","name": "EXT_Read_00_Person"}],

 "bloated":[{"package": "Externalization","name": "EXT_Read_00_Animal"}]

 METHOD
 "required": [{"type": "EXT_Read_00_Person","name": "readExternal","return": "void","param": "java.io.ObjectInput"}],

 "bloated":  [{"type": "EXT_Read_00_Person","name": "writeExternal","return": "void","param": "java.io.ObjectOutput"},
 {"type": "EXT_Read_00_Animal","name": "readExternal","return": "void","param": "java.io.ObjectInput"},
 {"type": "EXT_Read_00_Animal","name": "writeExternal","return": "void","param": "java.io.ObjectOutput"}
 ]

 FIELD
 "required": [{"class": "EXT_Read_00_Person","name": "name"},
 {"class": "EXT_Read_00_Person","name": "age"}]

 "bloated":[{"class": "EXT_Read_00_Person","name": "surname"},
 {"class": "EXT_Read_00_Animal","name": "name"},
 {"class": "EXT_Read_00_Animal","name": "age"},
 ]
 *************************/
package Externalization;

import java.io.*;

class EXT_Read_00_Person implements Externalizable {
    String name;
    String surname;
    int age;

    public EXT_Read_00_Person() {

    }

    public EXT_Read_00_Person(String name, int age) {
        this.name = name;
        this.age = age;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(name);
        out.writeInt(age);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        name = (String) in.readObject();
        age = in.readInt();
    }
}

class EXT_Read_00_Animal implements Externalizable {
     String name;
     int age;

    public EXT_Read_00_Animal() {

    }

    public EXT_Read_00_Animal(String name, int age) {
        this.name = name;
        this.age = age;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(name);
        out.writeInt(age);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        name = (String) in.readObject();
        age = in.readInt();
    }
}

public class EXT_Read_00 {
    public static void main(String[] args) throws Exception {

        FileInputStream fis = new FileInputStream("EXT_Read_00.ser");
        ObjectInputStream ois = new ObjectInputStream(fis);
        EXT_Read_00_Person person = (EXT_Read_00_Person)ois.readObject();
        System.out.println(person.name+"...."+person.age);
    }
}
