/************************
 CLASS
 "required": [{"package": "Serialization","name": "DS_MethodOverwriting_00"},{"package": "Serialization","name": "DS_MethodOverwriting_00_Game"}],

 "bloated":[] }

 METHOD
 "required": [
 {"type": "DS_MethodOverwriting_00_Game","name": "readObject","return": "void","param": "java.io.ObjectInputStream"},
 {"type": "DS_MethodOverwriting_00_Game","name": "deserialize_method","return": "void","param": ""}],

 "bloated":  [{"type": "DS_MethodOverwriting_00_Game","name": "serialize_method","return": "void","param": "Deserialization.DS_MethodOverwriting_00_Game"}
 ,{"type": "DS_MethodOverwriting_00_Game","name": "writeObject","return": "void","param": "java.io.ObjectOutputStream"}]

 FIELD
 "required": [{"class": "DS_MethodOverwriting_00_Game","name": "username"},{"class": "DS_MethodOverwriting_00_Game","name": "password"}],

 "bloated":[]
 *************************/

package Deserialization;
import java.io.*;


class DS_MethodOverwriting_00_Game implements Serializable {
    String username = "MadMax";
    transient String password = "pwdMadmax";

    private void writeObject(ObjectOutputStream os) throws Exception {
        os.defaultWriteObject();
        os.writeObject("123" + password);
    }

    private void readObject(ObjectInputStream is) throws Exception {
        is.readObject();
    }

    public static void serialize_method(DS_MethodOverwriting_00_Game game) throws Exception {
        try (FileOutputStream fos = new FileOutputStream("test/DS_MethodOverwriting_00_demo.ser");
             ObjectOutputStream oos = new ObjectOutputStream(fos)) {
            oos.writeObject(game);
        }
    }

    public static void deserialize_method() throws Exception {
        try (FileInputStream fis = new FileInputStream("test/DS_MethodOverwriting_00_demo.ser");
             ObjectInputStream ois = new ObjectInputStream(fis)) {
            System.out.println("HI2");
            DS_MethodOverwriting_00_Game tetris = (DS_MethodOverwriting_00_Game) ois.readObject();
            System.out.println(tetris.username + "...." + tetris.password);
        }
    }
}

public class DS_MethodOverwriting_00 {
    public static void main(String[] args) throws Exception {
        DS_MethodOverwriting_00_Game tetris = new DS_MethodOverwriting_00_Game();
        tetris.username = "MadMax";
        tetris.password = "pwdMadmax";
        DS_MethodOverwriting_00_Game.deserialize_method();
    }
}
