package de.upb.deblometer;

import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.signatures.MethodSignature;
import sootup.java.bytecode.inputlocation.JavaClassPathAnalysisInputLocation;
import sootup.java.core.JavaSootClass;
import sootup.java.core.JavaSootField;
import sootup.java.core.JavaSootMethod;
import sootup.java.core.views.JavaView;

import java.util.ArrayList;
import java.util.Collections;

public class MemberExtraction {

    public static ArrayList<GroundTruth.FieldSpecifier> extractField(String jarLocation){

        ArrayList<GroundTruth.FieldSpecifier> extractedList = new ArrayList<>();
        AnalysisInputLocation inputLocation =
                new JavaClassPathAnalysisInputLocation(jarLocation);

        JavaView view = new JavaView(Collections.singletonList(inputLocation));

        for(JavaSootClass javaSootClass : view.getClasses()){
            for (JavaSootField javaSootField : javaSootClass.getFields()) {

                GroundTruth.FieldSpecifier fieldSpecifier = new GroundTruth.FieldSpecifier();
                fieldSpecifier.setAffectedClass(javaSootField.getDeclaringClassType().getClassName());
                fieldSpecifier.setName(javaSootField.getName());
                extractedList.add(fieldSpecifier);

            }
        }
        return extractedList;
    }

    public static ArrayList<GroundTruth.MethodSpecifier> extractMethod(String jarLocation){

        ArrayList<GroundTruth.MethodSpecifier> extractedList = new ArrayList<>();
        AnalysisInputLocation inputLocation =
                new JavaClassPathAnalysisInputLocation(jarLocation);

        JavaView view = new JavaView(Collections.singletonList(inputLocation));

        for(JavaSootClass javaSootClass : view.getClasses()){
            for(JavaSootMethod javaSootMethod : javaSootClass.getMethods()) {

                GroundTruth.MethodSpecifier methodSpecifier = new GroundTruth.MethodSpecifier();

                MethodSignature methodSignatureOutput = javaSootMethod.getSignature();
                methodSpecifier.setType(methodSignatureOutput.getDeclClassType().getClassName());
                methodSpecifier.setName(methodSignatureOutput.getName());
                methodSpecifier.setReturnParameter(methodSignatureOutput.getType().toString());
                String methodParameterArray = methodSignatureOutput.getParameterTypes().toString().replace("java.lang.String","String");
                methodSpecifier.setParam(methodParameterArray.replace('[', '(').replace(']', ')').replace(" ",""));
                extractedList.add(methodSpecifier);

            }
        }
        return extractedList;
    }

    public static ArrayList<GroundTruth.ClassSpecifier> extractClass(String jarLocation){

        ArrayList<GroundTruth.ClassSpecifier> extractedList = new ArrayList<>();
        AnalysisInputLocation inputLocation =
                new JavaClassPathAnalysisInputLocation(jarLocation);

        JavaView view = new JavaView(Collections.singletonList(inputLocation));

        for(JavaSootClass javaSootClass : view.getClasses()){

            GroundTruth.ClassSpecifier classSpecifier = new GroundTruth.ClassSpecifier();
            String rawClassName = javaSootClass.getName();
            int lastDotIndex = rawClassName.lastIndexOf('.');

            classSpecifier.setName(rawClassName.substring(lastDotIndex + 1));
            classSpecifier.setPackageDirectory(rawClassName.substring(0, lastDotIndex).replace(".","_"));

            extractedList.add(classSpecifier);
        }

        return extractedList;
    }

}
