package de.upb.deblometer;
import com.google.gson.annotations.SerializedName;

import java.util.List;

public class GroundTruth {

    @SerializedName(value = "abstract", alternate = {
            "annotation", "deserialization", "dynamic_class_loading",
            "exception", "externalization", "overloading",
            "generics", "interface", "lambda",
            "overriding", "reflection",
            "serialization"
    })

    private Language_Feature lf;

    public Language_Feature getLF() {
        return lf;
    }

    public class Language_Feature {

        @SerializedName("method")
        private MethodGroundTruth methodGroundTruth;

        @SerializedName("field")
        private FieldGroundTruth fieldGroundTruth;

        @SerializedName("class")
        private ClassGroundTruth classGroundTruth;

        public MethodGroundTruth getMethodGroundTruth() {
            return methodGroundTruth;
        }

        public FieldGroundTruth getFieldGroundTruth() {
            return fieldGroundTruth;
        }

        public ClassGroundTruth getClassGroundTruth() {
            return classGroundTruth;
        }
    }

    public class MethodGroundTruth{
        private List<MethodSpecifier> required;
        private List<MethodSpecifier> bloated;

        public List<MethodSpecifier> getRequired() {
            return required;
        }

        public List<MethodSpecifier> getBloated() {
            return bloated;
        }
    }

    public class FieldGroundTruth{
        private List<FieldSpecifier> required;

        private List<FieldSpecifier> bloated;

        public List<FieldSpecifier> getRequired() {
            return required;
        }

        public List<FieldSpecifier> getBloated() {
            return bloated;
        }
    }

    public class ClassGroundTruth{
        private List<ClassSpecifier> required;

        private List<ClassSpecifier> bloated;

        public List<ClassSpecifier> getRequired() {
            return required;
        }

        public List<ClassSpecifier> getBloated() {
            return bloated;
        }
    }

    public static class MethodSpecifier{
        private String type;
        private String name;
        @SerializedName("return")
        private String returnParameter;
        private String param;

        // Getters
        public String getType() {
            return type;
        }
        public String getName() {
            return name;
        }
        public String getReturnType() {
            return returnParameter;
        }
        public String getParam() {
            return param;
        }

        //Setters
        public void setType(String type) {
            this.type = type;
        }
        public void setName(String name) {
            this.name = name;
        }
        public void setReturnParameter(String returnParameter) {
            this.returnParameter = returnParameter;
        }
        public void setParam(String param) {
            this.param = param;
        }

        //getter method to return all attributes as a single string separated by ';'
        public String getAllAttributesAsString() {
            StringBuilder result = new StringBuilder();

            // Append each field value, checking for null to avoid NullPointerException
            if (type != null) result.append(type);
            if (name != null) result.append(";").append(name);
            if (returnParameter != null) result.append(";").append(returnParameter);
            if (param != null) result.append(";").append(param);

            return result.toString();
        }

    }

    public static class FieldSpecifier{
        @SerializedName("class")
        private String affectedClass;
        private String name;

        public void setAffectedClass(String affectedClass) {
            this.affectedClass = affectedClass;
        }
        public void setName(String name) {
            this.name = name;
        }

        public String getAffectedClass() {
            return affectedClass;
        }
        public String getName() {
            return name;
        }

        public String getAllAttributesAsString() {
            StringBuilder result = new StringBuilder();

            // Append each field value, checking for null to avoid NullPointerException
            if (affectedClass != null) result.append(affectedClass);
            if (name != null) result.append(";").append(name);

            return result.toString();
        }
    }

    public static class ClassSpecifier{
        @SerializedName("package")
        private String packageDirectory;
        private String name;

        public void setPackageDirectory(String packageDirectory) {
            this.packageDirectory = packageDirectory;
        }
        public void setName(String name) {
            this.name = name;
        }

        public String getPackageDirectory() {
            return packageDirectory;
        }
        public String getName() {
            return name;
        }

        public String getAllAttributesAsString() {
            StringBuilder result = new StringBuilder();

            // Append each field value, checking for null to avoid NullPointerException
            if (packageDirectory != null) result.append(packageDirectory);
            if (name != null) result.append(";").append(name);

            return result.toString();
        }
    }
}