package de.upb.deblometer;

public class AnalysisResult{
    String type;
    Integer required;
    Integer bloated;
    Integer notDebloated_required;
    Integer false_positives;
    Integer false_negatives;
    Integer soundness;
    Integer precision;
    boolean crashed = false;

    /***
     *
     * @param type of the class member (class, method, field)
     * @param required number of members within the type for the given groundtruth
     * @param bloated number of members within the type for the given groundtruth
     * @param notDebloated_required is the amount of not debloated members, that are actually required
     * @param false_positives is a bloated program construct that is still included in the debloated jar
     */
    public AnalysisResult(String type, int required, int bloated, int notDebloated_required, int false_positives){
        this.type = type;
        this.required = required;
        this.bloated = bloated;
        this.notDebloated_required = notDebloated_required;
        this.false_positives = false_positives;
        this.false_negatives = required - notDebloated_required;
        this.soundness = (int) Math.round((double) notDebloated_required / required * 100);
        this.precision = (int) Math.round(((double) (notDebloated_required)
                / (required + false_positives)) * 100);
    }

    public AnalysisResult(boolean crashed) {
        this.crashed = crashed;
        this.required = null;
        this.bloated = null;
        this.notDebloated_required = null;
        this.false_positives = null;
        this.false_negatives = null;
        this.soundness = null;
        this.precision = null;
        this.type = null;
    }

    public String getType() {return type;}
    public int getRequired() {return required;}
    public int getBloated() {return bloated;}
    public int getNotDebloated_required() {return notDebloated_required;}
    public int getFalse_positives() {return false_positives;}
    public int getFalse_negatives() {return false_negatives;}
    public int getSoundness() {return soundness;}
    public int getPrecision() {return precision;}
    public boolean isCrashed() {return crashed;}

}
