library(CMDdemux)
library(Seurat)
library(scran)
library(scater)
library(deMULTIplex2)
library(demuxmix)
library(cellhashR)
library(DropletUtils)
library(stringr)
library(tidyverse)
library(clValid)

source(~/bench.R)

# PDX CellPlex
load("~/pdxcmo.hash.count.rdata")
load("~/pdxcmo.gex.count.rdata")

# 1. CMDdemux
pdxcmo.clr.norm <- LocalCLRNorm(pdxcmo.hash.count)
pdxcmo.kmed.cl <- KmedCluster(pdxcmo.clr.norm, optional = TRUE)
pdxcmo.cl.dist <- EuclideanClusterDist(pdxcmo.clr.norm, pdxcmo.kmed.cl)
pdxcmo.noncore <- DefineNonCore(pdxcmo.cl.dist, pdxcmo.kmed.cl, c(0.98, 0.85, 0.945, 0.93, 0.83), optional = TRUE, clr.norm = pdxcmo.clr.norm)
pdxcmo.cluster.assign <- LabelClusterHTO(pdxcmo.clr.norm, pdxcmo.kmed.cl2, pdxcmo.noncore, "expression")
pdxcmo.md.mat <- CalculateMD(pdxcmo.clr.norm, pdxcmo.noncore, pdxcmo.kmed.cl, pdxcmo.cluster.assign)
pdxcmo.outlier.assign <- AssignOutlierDrop(pdxcmo.md.mat,  md_cut_q = 0.52)
pdxcmo.cmddemux.assign <- CMDdemuxClass(pdxcmo.md.mat, pdxcmo.hash.count, pdxcmo.outlier.assign, TRUE, pdxcmo.gex.count, 10, 18, NULL, TRUE, pdxcmo.kmed.cl, pdxcmo.cluster.assign)
pdxcmo.demux.result <- data.frame("CMDdemux" = pdxcmo.cmddemux.assign$demux_global_class)
rownames(pdxcmo.demux.result) <- rownames(pdxcmo.cmddemux.assign)

# 2. HTOdemux
pdxcmo.obj <- CreateSeuratObject(counts = pdxcmo.hash.count)
pdxcmo.obj[["HTO"]] <- CreateAssayObject(counts = pdxcmo.hash.count)
pdxcmo.obj <- NormalizeData(pdxcmo.obj, assay = "HTO", normalization.method = "CLR")
pdxcmo.obj <- HTODemux(pdxcmo.obj, assay = "HTO", positive.quantile = 0.99)
pdxcmo.demux.result$HTODemux <- pdxcmo.obj$hash.ID[rownames(pdxcmo.demux.result)]  

# 3. GMM-Demux
# Prepare input data
pdxcmo.gmm.input <- t(pdxcmo.hash.count)
write.csv(pdxcmo.gmm.input, "~/pdxcmo.gmm.input.csv", quote=F)
# Command: GMM-demux -c ~/pdxcmo.gmm.input.csv CMO301,CMO302,CMO303,CMO304 -x CMO301,CMO302,CMO303,CMO304 -f .
pdxcmo.gmm.output <- read.csv("~/pdxcmo_GMM_full.csv")
pdxcmo.gmm.config <- read.table("~/pdxcmo_GMM_full.config", header = FALSE, sep = ",")
pdxcmo.gmm.demux <- GMM_demux_class(pdxcmo.gmm.output, pdxcmo.gmm.config, pdxcmo.hash.count)
pdxcmo.demux.result$`GMM-Demux` <- pdxcmo.gmm.demux

# 4. deMULTIplex2
pdxcmo.demultiplex2.output <- demultiplexTags(pdxcmo.gmm.input, plot.diagnostics = FALSE, seed = 2024)
pdxcmo.demultiplex2.assign <- deMULTIplex2_class(pdxcmo.demultiplex2.output)
# deMULTIplex2 cannot classify 6 cells. We label them as "Uncertain"
pdxcmo.demultiplex2.assign2 <- rep("Uncertain", ncol(pdxcmo.hash.count))
names(pdxcmo.demultiplex2.assign2) <- colnames(pdxcmo.hash.count)
pdxcmo.demultiplex2.assign2[names(pdxcmo.demultiplex2.assign)] <- pdxcmo.demultiplex2.assign
pdxcmo.demux.result$deMULTIplex2 <- pdxcmo.demultiplex2.assign2

# 5. demuxEM
# The results are not available for demuxEM
pdxcmo.hash.write <- as.data.frame(pdxcmo.hash.count) %>% rownames_to_column('Antibody')
pdxcmo.hash.write$Antibody <- 1:nrow(pdxcmo.hash.write)
write.csv(pdxcmo.hash.write, "~/pdxcmo.demuxEM.input.csv", quote=F)
write10xCounts("~/pdxcmo.demuxEM.gex.h5", pdxcmo.gex.count, version='3')
# demuxEM -p 8 --random-state 2024 ~/pdxcmo.demuxEM.gex.h5 ~/pdxcmo.demuxEM.input.csv pdxcmo

# 6. demuxmix
pdxcmo.gex.genes <- colSums(pdxcmo.gex.count > 0)
pdxcmo.demuxmix.model <- demuxmix(hto = as.matrix(pdxcmo.hash.count), rna = pdxcmo.gex.genes)
pdxcmo.demuxmix.labels <- dmmClassify(pdxcmo.demuxmix.model)
pdxcmo.demuxmix.assign <- demuxmix_class(pdxcmo.demuxmix.labels)
pdxcmo.demux.result$demuxmix <- pdxcmo.demuxmix.assign[rownames(pdxcmo.demux.result)]

# 7. hashedDrops
pdxcmo.hasheddrops.output <- hashedDrops(pdxcmo.hash.count)
pdxcmo.hasheddrops.assign <- hashedDrops_class(pdxcmo.hasheddrops.output, pdxcmo.hash.count)
pdxcmo.demux.result$hashedDrops <- pdxcmo.hasheddrops.assign[rownames(pdxcmo.demux.result)]

# 8. BFF
pdxcmo.bff.output <- GenerateCellHashingCalls(barcodeMatrix = pdxcmo.hash.count, methods = c("bff_raw", "bff_cluster"))
pdxcmo.demux.result$BFF_raw <- pdxcmo.bff.output$bff_raw
pdxcmo.demux.result$BFF_cluster <- pdxcmo.bff.output$bff_cluster

# Dimensional reduction for visualization
pdxcmo.sce <- SingleCellExperiment(assays = list(hto = pdxcmo.hash.count, clr = pdxcmo.clr.norm))
pdxcmo.sce <- runTSNE(pdxcmo.sce,exprs_values = "clr")
pdxcmo.sce <- runUMAP(pdxcmo.sce,exprs_values = "clr")

# Library size
pdxcmo.gex.lib <- log(colSums(pdxcmo.gex.count))

# Library size ratios of doublets vs. singlets and singlets vs. negatives across different methods
pdxcmo.lib.ratio <- LibRatio(pdxcmo.gex.lib, pdxcmo.demux.result)

# Summary of library size ratio
pdxcmo.ratio.sum <- LibRatioSum(pdxcmo.gex.lib, pdxcmo.demux.result)

# Proportion of doublets
pdxcmo.demux.result2 <- DemuxSingletClass(pdxcmo.demux.result, pdxcmo.hash.count)
pdxcmo.doublet.prop <- AssignProp(pdxcmo.demux.result2, "doublet")

# Proportion of negatives
pdxcmo.negative.prop <- AssignProp(pdxcmo.demux.result2, "negative")

# Check extra CMO301 singlets and extra doublets
cmo301.common.sig <- rownames(pdxcmo.demux.result)[which(pdxcmo.demux.result$HTODemux == "CMO301" & pdxcmo.demux.result$demuxmix == "CMO301")]
cmo301.extra.sig <- rownames(pdxcmo.demux.result)[which(pdxcmo.demux.result$CMDdemux == "CMO301")]
cmo301.extra.sig <- cmo301.extra.sig[which(!cmo301.extra.sig %in% cmo301.common.sig)]
pdxcmo.common.db <- rownames(pdxcmo.demux.result)[which(pdxcmo.demux.result$CMDdemux == "Doublet" & pdxcmo.demux.result$`GMM-Demux` == "Doublet")]
gmmdemux.extra.db <- rownames(pdxcmo.demux.result)[which(pdxcmo.demux.result$`GMM-Demux` == "Doublet")]
gmmdemux.extra.db <- gmmdemux.extra.db[which(!gmmdemux.extra.db %in% pdxcmo.common.db)]
set.seed(2025)
pdxcmo.check.barcodes <- list("CMO301_extra_singlet" = cmo301.extra.sig[sample(1:length(cmo301.extra.sig), 30, replace = FALSE)], 
                              "GMM-Demux_extra_doublet" = gmmdemux.extra.db[sample(1:length(gmmdemux.extra.db), 30, replace = FALSE)])

CheckAssign2DPlot(pdxcmo.hash.count, pdxcmo.gex.count, pdxcmo.md.mat, pdxcmo.cmddemux.assign, pdxcmo.check.barcodes$CMO301_extra_singlet)
CheckAssign2DPlot(pdxcmo.hash.count, pdxcmo.gex.count, pdxcmo.md.mat, pdxcmo.cmddemux.assign, pdxcmo.check.barcodes$GMM-Demux_extra_doublet)


# PDX Hashtag Ab
load("~/pdxhto.hash.count.rdata")
load("~/pdxhto.gex.count.rdata")

# 1. CMDdemux
pdxhto.clr.norm <- LocalCLRNorm(pdxhto.hash.count)
pdxhto.kmed.cl <- KmedCluster(pdxhto.clr.norm, optional = TRUE, extra_cluster = 3)
pdxhto.cl.dist <- EuclideanClusterDist(pdxhto.clr.norm, pdxhto.kmed.cl)
pdxhto.noncore <- DefineNonCore(pdxhto.cl.dist, pdxhto.kmed.cl, c(0.9,0.95,0.95,0.88,0.9,0.88,0.71), optional = TRUE, clr.norm = pdxhto.clr.norm)
pdxhto.cluster.assign <- LabelClusterHTO(pdxhto.clr.norm, pdxhto.kmed.cl, pdxhto.noncore, "expression")
pdxhto.md.mat <- CalculateMD(pdxhto.clr.norm, pdxhto.noncore, pdxhto.kmed.cl, pdxhto.cluster.assign)
pdxhto.outlier.assign <- AssignOutlierDrop(pdxhto.md.mat, md_cut_q = 0.4)
pdxhto.cmddemux.assign <- CMDdemuxClass(pdxhto.md.mat, pdxhto.hash.count, pdxhto.outlier.assign, TRUE, pdxhto.gex.count, 8, 4, NULL, TRUE, pdxhto.kmed.cl, pdxhto.cluster.assign)
pdxhto.demux.result <- data.frame("CMDdemux" = pdxhto.cmddemux.assign$demux_global_class)
rownames(pdxhto.demux.result) <- rownames(pdxhto.cmddemux.assign)

# 2. HTOdemux
pdxhto.obj <- CreateSeuratObject(counts = pdxhto.hash.count)
pdxhto.obj[["HTO"]] <- CreateAssayObject(counts = pdxhto.hash.count)
pdxhto.obj <- NormalizeData(pdxhto.obj, assay = "HTO", normalization.method = "CLR")
pdxhto.obj <- HTODemux(pdxhto.obj, assay = "HTO", positive.quantile = 0.99)
pdxhto.demux.result$HTODemux <- gsub("-", "_", pdxhto.obj$hash.ID[rownames(pdxhto.demux.result)]) 

# 3. GMM-Demux
# Prepare input data
pdxhto.gmm.input <- t(pdxhto.hash.count)
write.csv(pdxhto.gmm.input, "~/pdxhto.gmm.input.csv", quote=F)
# Command: GMM-demux -c ~/pdxhto.gmm.input.csv HTO_1,HTO_2,HTO_3,HTO_4 -x HTO_1,HTO_2,HTO_3,HTO_4 -f .
pdxhto.gmm.output <- read.csv("~/pdxhto_GMM_full.csv")
pdxhto.gmm.config <- read.table("~/pdxhto_GMM_full.config", header = FALSE, sep = ",")
pdxhto.gmm.demux <- GMM_demux_class(pdxhto.gmm.output, pdxhto.gmm.config, pdxhto.hash.count)
pdxhto.demux.result$`GMM-Demux` <- pdxhto.gmm.demux

# 4. deMULTIplex2
pdxhto.demultiplex2.output <- demultiplexTags(pdxhto.gmm.input, plot.diagnostics = FALSE, seed = 2024)
pdxhto.demultiplex2.assign <- deMULTIplex2_class(pdxhto.demultiplex2.output)
pdxhto.demux.result$deMULTIplex2 <- pdxhto.demultiplex2.assign

# 5. demuxEM
# The results are not available for demuxEM
pdxhto.hash.write <- as.data.frame(pdxhto.hash.count) %>% rownames_to_column('Antibody')
pdxhto.hash.write$Antibody <- 1:nrow(pdxhto.hash.write)
write.csv(pdxhto.hash.write, "~/pdxhto.demuxEM.input.csv", quote=F)
write10xCounts("~/pdxhto.demuxEM.gex.h5", pdxcmo.gex.count, version='3')
# demuxEM -p 8 --random-state 2024 ~/pdxhto.demuxEM.gex.h5 ~/pdxhto.demuxEM.input.csv pdxhto

# 6. demuxmix
pdxhto.gex.genes <- colSums(pdxhto.gex.count > 0)
pdxhto.demuxmix.model <- demuxmix(hto = as.matrix(pdxhto.hash.count), rna = pdxhto.gex.genes)
pdxhto.demuxmix.labels <- dmmClassify(pdxhto.demuxmix.model)
pdxhto.demuxmix.assign <- demuxmix_class(pdxhto.demuxmix.labels)
pdxhto.demux.result$demuxmix <- pdxhto.demuxmix.assign[rownames(pdxhto.demux.result)]

# 7. hashedDrops
pdxhto.hasheddrops.output <- hashedDrops(pdxhto.hash.count)
pdxhto.hasheddrops.assign <- hashedDrops_class(pdxhto.hasheddrops.output, pdxhto.hash.count)
pdxhto.demux.result$hashedDrops <- pdxhto.hasheddrops.assign[rownames(pdxhto.demux.result)]

# 8. BFF
# BFF does not work
pdxhto.bff.output <- GenerateCellHashingCalls(barcodeMatrix = pdxhto.hash.count, methods = c("bff_raw", "bff_cluster"))
# BFF raw assign all droplets as negatives
#pdxhto.demux.result$BFF_raw <- pdxhto.bff.output$bff_raw
# BFF cluster result not available for HTO
#pdxhto.demux.result$BFF_cluster <- pdxhto.bff.output$bff_cluster

# Dimensional reduction for visualization
pdxhto.sce <- SingleCellExperiment(assays = list(hto = pdxhto.hash.count, clr = pdxhto.clr.norm))
pdxhto.sce <- runTSNE(pdxhto.sce,exprs_values = "clr")
pdxhto.sce <- runUMAP(pdxhto.sce,exprs_values = "clr")

# Library size
pdxhto.hto.lib <- log(colSums(pdxhto.hash.count)+1)
pdxhto.gex.lib <- log(colSums(pdxhto.gex.count))

# Summary of library size ratio
pdxhto.ratio.sum <- LibRatioSum(pdxhto.gex.lib, pdxhto.demux.result)

# Proportion of doublets
pdxhto.demux.result2 <- DemuxSingletClass(pdxhto.demux.result, pdxhto.hash.count)
pdxhto.doublet.prop <- AssignPropPlot(pdxhto.demux.result2, "doublet")

# Proportion of negatives
pdxhto.negative.prop <- AssignProp(pdxhto.demux.result2, "negative")

# Check extra HTO_3 singlets, extra HTO_4 singlets and extra doublets
pdxhto.extra.db <- rownames(pdxhto.demux.result)[which(pdxhto.demux.result$CMDdemux == "Doublet" & pdxhto.demux.result$HTODemux == "HTO_1" &  pdxhto.demux.result$`GMM-Demux` == "HTO_1")]
pdxhto.extra.hto3 <- rownames(pdxhto.demux.result)[which(pdxhto.demux.result$CMDdemux == "HTO_3" & pdxhto.demux.result$HTODemux == "Doublet" &  pdxhto.demux.result$`GMM-Demux` == "Doublet")]
pdxhto.extra.hto4 <- rownames(pdxhto.demux.result)[which(pdxhto.demux.result$CMDdemux == "HTO_4" & pdxhto.demux.result$HTODemux == "Doublet" &  pdxhto.demux.result$`GMM-Demux` == "Doublet")]
set.seed(2025)
pdxhto.check.barcodes <- list("Extra_HTO_3" = pdxhto.extra.hto3[sample(1:length(pdxhto.extra.hto3), 30, replace = FALSE)], 
                              "Extra_HTO_4" = pdxhto.extra.hto4[sample(1:length(pdxhto.extra.hto4), 30, replace = FALSE)], 
                              "Extra_Doublet" = pdxhto.extra.db[sample(1:length(pdxhto.extra.db), 30, replace = FALSE)])
CheckAssign2DPlot(pdxhto.hash.count, pdxhto.gex.count, pdxhto.md.mat, pdxhto.cmddemux.assign, pdxhto.check.barcodes$Extra_HTO_3)
CheckAssign2DPlot(pdxhto.hash.count, pdxhto.gex.count, pdxhto.md.mat, pdxhto.cmddemux.assign, pdxhto.check.barcodes$Extra_HTO_4)
CheckAssign2DPlot(pdxhto.hash.count, pdxhto.gex.count, pdxhto.md.mat, pdxhto.cmddemux.assign, pdxhto.check.barcodes$Extra_Doublet)


# PDX MULTI-Seq CMO
load("~/pdxnxt.hash.count.rdata")
load("~/pdxnxt.gex.count.rdata")

# 1. CMDdemux
pdxnxt.clr.norm <- LocalCLRNorm(pdxnxt.hash.count)
pdxnxt.kmed.cl <- KmedCluster(pdxnxt.clr.norm) 
pdxnxt.cl.dist <- EuclideanClusterDist(pdxnxt.clr.norm, pdxnxt.kmed.cl)
pdxnxt.noncore <- DefineNonCore(pdxnxt.cl.dist, pdxnxt.kmed.cl, c(0.95, 0.95, 0.81, 0.86))
pdxnxt.cluster.assign <- LabelClusterHTO(pdxnxt.clr.norm, pdxnxt.kmed.cl, pdxnxt.noncore, "medoids")
pdxnxt.md.mat <- CalculateMD(pdxnxt.clr.norm, pdxnxt.noncore, pdxnxt.kmed.cl, pdxnxt.cluster.assign)
pdxnxt.outlier.assign <- AssignOutlierDrop(pdxnxt.md.mat, 0.8)
pdxnxt.cmddemux.assign <- CMDdemuxClass(pdxnxt.md.mat, pdxnxt.hash.count, pdxnxt.outlier.assign, TRUE, pdxnxt.gex.count, 7, 4)
pdxnxt.demux.result <- data.frame("CMDdemux" = pdxnxt.cmddemux.assign$demux_global_class)
rownames(pdxnxt.demux.result) <- rownames(pdxnxt.cmddemux.assign)

# 2. HTOdemux
pdxnxt.obj <- CreateSeuratObject(counts = pdxnxt.hash.count)
pdxnxt.obj[["HTO"]] <- CreateAssayObject(counts = pdxnxt.hash.count)
pdxnxt.obj <- NormalizeData(pdxnxt.obj, assay = "HTO", normalization.method = "CLR")
pdxnxt.obj <- HTODemux(pdxnxt.obj, assay = "HTO", positive.quantile = 0.99)
pdxnxt.demux.result$HTODemux <- gsub("-", "_", pdxnxt.obj$hash.ID[rownames(pdxnxt.demux.result)])    

# 3. GMM-Demux
# Prepare input data
pdxnxt.gmm.input <- t(pdxnxt.hash.count)
write.csv(pdxnxt.gmm.input, "~/pdxnxt.gmm.input.csv", quote=F)
# Command: GMM-demux -c ~/pdxnxt.gmm.input.csv Nxt_451,Nxt_452,Nxt_453,Nxt_455 -x Nxt_451,Nxt_452,Nxt_453,Nxt_455 -f .
pdxnxt.gmm.output <- read.csv("~/pdxnxt_GMM_full.csv")
pdxnxt.gmm.config <- read.table("~/pdxnxt_GMM_full.config", header = FALSE, sep = ",")
pdxnxt.gmm.demux <- GMM_demux_class(pdxnxt.gmm.output, pdxnxt.gmm.config, pdxnxt.hash.count)
pdxnxt.demux.result$`GMM-Demux` <- pdxnxt.gmm.demux

# 4. deMULTIplex2
pdxnxt.demultiplex2.output <- demultiplexTags(pdxnxt.gmm.input, plot.diagnostics = FALSE, seed = 2024)
pdxnxt.demultiplex2.assign <- deMULTIplex2_class(pdxnxt.demultiplex2.output)
pdxnxt.demux.result$deMULTIplex2 <- pdxnxt.demultiplex2.assign

# 5. demuxEM
# The results are not available for demuxEM
pdxnxt.hash.write <- as.data.frame(pdxnxt.hash.count) %>% rownames_to_column('Antibody')
pdxnxt.hash.write$Antibody <- 1:nrow(pdxnxt.hash.write)
write.csv(pdxnxt.hash.write, "~/pdxnxt.demuxEM.input.csv", quote=F)
write10xCounts("~/pdxnxt.demuxEM.gex.h5", pdxcmo.gex.count, version='3')

# 6. demuxmix
pdxnxt.gex.genes <- colSums(pdxnxt.gex.count > 0)
pdxnxt.demuxmix.model <- demuxmix(hto = as.matrix(pdxnxt.hash.count), rna = pdxnxt.gex.genes)
pdxnxt.demuxmix.labels <- dmmClassify(pdxnxt.demuxmix.model)
pdxnxt.demuxmix.assign <- demuxmix_class(pdxnxt.demuxmix.labels)
pdxnxt.demux.result$demuxmix <- pdxnxt.demuxmix.assign[rownames(pdxnxt.demux.result)]

# 7. hashedDrops
pdxnxt.hasheddrops.output <- hashedDrops(pdxnxt.hash.count)
pdxnxt.hasheddrops.assign <- hashedDrops_class(pdxnxt.hasheddrops.output, pdxnxt.hash.count)
pdxnxt.demux.result$hashedDrops <- pdxnxt.hasheddrops.assign[rownames(pdxnxt.demux.result)]

# 8. BFF
pdxnxt.bff.output <- GenerateCellHashingCalls(barcodeMatrix = pdxnxt.hash.count, methods = c("bff_raw", "bff_cluster"))
pdxnxt.demux.result$BFF_raw <- pdxnxt.bff.output$bff_raw
# BFF cluster result not available for MULTI-Seq CMO
#pdxnxt.demux.result$BFF_cluster <- pdxnxt.bff.output$bff_cluster

# Dimensional reduction for visualization
pdxnxt.sce <- SingleCellExperiment(assays = list(hto = pdxnxt.hash.count, clr = pdxnxt.clr.norm))
pdxnxt.sce <- runTSNE(pdxnxt.sce,exprs_values = "clr")
pdxnxt.sce <- runUMAP(pdxnxt.sce,exprs_values = "clr")

# Proportion of doublets
pdxnxt.demux.result2 <- DemuxSingletClass(pdxnxt.demux.result, pdxnxt.hash.count)
pdxnxt.doublet.prop <- AssignProp(pdxnxt.demux.result2, "doublet")

# Proportion of negatives
pdxnxt.negative.prop <- AssignProp(pdxnxt.demux.result2, "negative")

# Library size
pdxnxt.hto.lib <- log(colSums(pdxnxt.hash.count)+1)
pdxnxt.gex.lib <- log(colSums(pdxnxt.gex.count))

# HTO library size ratios of doublets vs. singlets and singlets vs. negatives across different methods
pdxnxt.htolib.ratio <- LibRatio(pdxnxt.hto.lib, pdxnxt.demux.result)

# GEX library size ratios of doublets vs. singlets and singlets vs. negatives across different methods
pdxnxt.gexlib.ratio <- LibRatio(pdxnxt.gex.lib, pdxnxt.demux.result)

# Summary of HTO library size ratio
pdxnxt.htoratio.sum <- LibRatioSum(pdxnxt.hto.lib, pdxnxt.demux.result)

# Summary of GEX library size ratio
pdxnxt.gexratio.sum <- LibRatioSum(pdxnxt.gex.lib, pdxnxt.demux.result)

# Check extra Nxt_451 and extra Nxt_452 singlets
pdxnxt.extra.nxt451 <- rownames(pdxnxt.demux.result)[which(pdxnxt.demux.result$CMDdemux == "Nxt_451" & pdxnxt.demux.result$HTODemux == "Negative" &  pdxnxt.demux.result$demuxmix == "Negative")]
pdxnxt.extra.nxt452 <- rownames(pdxnxt.demux.result)[which(pdxnxt.demux.result$CMDdemux == "Nxt_452" & pdxnxt.demux.result$HTODemux == "Negative" &  pdxnxt.demux.result$demuxmix == "Negative")]
set.seed(2025)
pdxnxt.check.barcodes <- list("Extra_Nxt_451" = pdxnxt.extra.nxt451[sample(1:length(pdxnxt.extra.nxt451), 30, replace = FALSE)], 
                              "Extra_Nxt_452" = pdxnxt.extra.nxt452[sample(1:length(pdxnxt.extra.nxt452), 30, replace = FALSE)])
CheckAssign2DPlot(pdxnxt.hash.count, pdxnxt.gex.count, pdxnxt.md.mat, pdxnxt.cmddemux.assign, pdxnxt.check.barcodes$Extra_Nxt_451)
CheckAssign2DPlot(pdxnxt.hash.count, pdxnxt.gex.count, pdxnxt.md.mat, pdxnxt.cmddemux.assign, pdxnxt.check.barcodes$Extra_Nxt_452)
