MODULE trcsms_my_trc
#include "bamhbi.h90"
   !!======================================================================
   !!                         ***  MODULE trcsms_my_trc  ***
   !! TOP :   Main module of the MY_TRC tracers
   !!======================================================================
   !! History :      !  2007  (C. Ethe, G. Madec)  Original code
   !!                !  2016  (C. Ethe, T. Lovato) Revised architecture
   !!----------------------------------------------------------------------
   !! trc_sms_my_trc       : MY_TRC model main routine
   !! trc_sms_my_trc_alloc : allocate arrays specific to MY_TRC sms
   !!----------------------------------------------------------------------
   USE par_trc         ! TOP parameters
   USE oce_trc         ! Ocean variables
   USE trc             ! TOP variables
   USE trd_oce
   USE trdtrc

   USE iom
   USE bamhbi
   USE bamhbi_sinking
#ifdef alkalinity_system
   USE bamhbi_alkalinity_vars
   USE bamhbi_alkalinity
#endif
   USE trcrst_ben
   USE trcwbstress
   USE trcsms_ben
   
   IMPLICIT NONE
   PRIVATE

   PUBLIC   trc_sms_my_trc       ! called by trcsms.F90 module
   PUBLIC   trc_sms_my_trc_alloc ! called by trcini_my_trc.F90 module

   !!----------------------------------------------------------------------
   !! NEMO/TOP 4.0 , NEMO Consortium (2018)
   !! $Id: trcsms_my_trc.F90 12377 2020-02-12 14:39:06Z acc $
   !! Software governed by the CeCILL license (see ./LICENSE)
   !!----------------------------------------------------------------------
#include "do_loop_substitute.h90"
#include "domzgr_substitute.h90"
CONTAINS

   SUBROUTINE trc_sms_my_trc( kt, Kbb, Kmm, Krhs )
      !!----------------------------------------------------------------------
      !!                     ***  trc_sms_my_trc  ***
      !!
      !! ** Purpose :   main routine of MY_TRC model
      !!
      !! ** Method  : -
      !!----------------------------------------------------------------------
      !
      INTEGER, INTENT(in) ::   kt   ! ocean time-step index
      INTEGER, INTENT(in) ::   Kbb, Kmm, Krhs  ! time level indices
      INTEGER ::   jn   ! dummy loop index
      REAL(wp), ALLOCATABLE, DIMENSION(:,:,:) :: ztrmyt
      real(wp)::   integrated_budget
      !!----------------------------------------------------------------------
      !
      IF( ln_timing )   CALL timing_start('trc_sms_my_trc')
      !
      IF(lwp) WRITE(numout,*)
      IF(lwp) WRITE(numout,*) ' trc_sms  bamhbi pelagic, kt=',kt
      IF(lwp) WRITE(numout,*) ' ~~~~~~~~~~~~~~'

      IF( l_trdtrc )  ALLOCATE( ztrmyt(jpi,jpj,jpk) )

#ifdef temp_clip
      ! Save Kbb, then call all BAMHBI (incl. pre_bio clipping), benthic, then copy back unclipped_var into Kbb.
      unclipped_var=tr(:,:,:,jp_myt0:jp_myt1,Kbb)
#endif

      ! calls to BGC model
#ifdef fulloptics
      CALL zenith()
#endif
      call pre_bio( kt , kbb, kmm, krhs )  ! clipping and conservation ; and put trends to zero (using bt(:,:,:,:,Krhs) for benthic)
#ifdef testcons
      call iom_put('consC',consC) ; call iom_put('consN',consN) ; ! call iom_put('consSi',consSi) ; call iom_put('consDOX',consOXY) ; call iom_put('consPHO',consPHO)
#endif
      call iom_put( 'PAR', par ) ! could come from simpleoptics, fulloptics
      !
      call CalculateFlagellates( kbb, kmm )
      call CalculateDiatoms(     kbb, kmm )
      call CalculateEmiliana(    kbb, kmm )
      call CalculateMicroZoo(    kbb, kmm )
      call CalculateMesoZoo(     kbb, kmm )
#ifdef gelatinous
      call CalculateGelatinous(  kbb, kmm )
      call CalculateNoctiluca(   kbb, kmm )
#endif
      call CalculateBacteria(    kbb, kmm )
      call CalculateDOM(         kbb, kmm )
      call ChemicalDynamics(     kbb, kmm )
#ifdef aggregation
      call CalculateAggregation( kbb, kmm )
#endif
      call DynamicsOxygen(       kbb, kmm )
#ifdef alkalinity_system
      call DynamicsDIC(     kt , kbb, kmm )     
#endif
      !      
#ifdef agg_diag
      call iom_put( 'shearrate', shearrate3D )
#endif
#ifdef fulloptics
      call iom_put( 'KBIOL', kbio_long )
      call iom_put( 'KBIOS', kbio_short)
#endif

#ifndef chlorophyll_geider
      call iom_put( 'CHD', chlorophyll(:,:,:,2) )  ! if we're NOT using Geider, we can still save the 3 chlorophyll diagnostics
      call iom_put( 'CHE', chlorophyll(:,:,:,3) )  !   if we're using Geider, they will be saved as state variables
      call iom_put( 'CHF', chlorophyll(:,:,:,1) )      
#endif
      call iom_put( 'CHL', sum(chlorophyll,dim=4) )
      call iom_rstput( kt, nitrst, numrtw, 'CHL', sum(chlorophyll,dim=4) )      ! save CHL for data assimilation
#ifdef chlorophyll_geider
      call iom_put( 'CHL_Geider', CHL_Geider )
      call iom_put( 'PphotoC_DIAT',PphotoC_DIAT)
      call iom_put( 'RespChl_DIAT', RespChl_DIAT)
      call iom_put( 'MortChl_DIAT', MortChl_DIAT)
      call iom_put( 'growthCHD_DIAT', growthCHD_DIAT) 
      call iom_put( 'PmaxC_DIAT', PmaxC_DIAT)
      call iom_put( 'RhoChl_DIAT', RhoChl_DIAT)
      call iom_put( 'ChlorosynthesisCHD_DIAT', ChlorosynthesisCHD_DIAT)
      call iom_put( 'VNC_DIAT', VNC_DIAT)
      call iom_put( 'LightLimCHD_DIAT',  LightLimCHD_DIAT) 
      call iom_put( 'Growth_DIAT',Growth_DIAT) 
      call iom_put( 'tf_DIAT',tf_DIAT)
      call iom_put( 'tf_SILICATE',tf_SILICATE)
      call iom_put( 'ChlCr_DIAT',ChlCr_DIAT)
      call iom_put( 'ChlCr_DIAT_borne',ChlCr_DIAT_borne)
      call iom_put( 'ChlCr_DIAT_bamhbi',ChlCr_DIAT_bamhbi)
      call iom_put( 'Nitrate_uptake_DIAT',Nitrate_uptake_DIAT) 
      call iom_put( 'Ammonium_uptake_DIAT',Ammonium_uptake_DIAT) 
      call iom_put( 'Phosphate_uptake_DIAT',Phosphate_uptake_DIAT)
      call iom_put( 'NCr_DIAT',NCr_DIAT)
      call iom_put( 'NCr_DIAT_borne',NCr_DIAT_borne)
      call iom_put( 'DOC_extra_excr_DIAT',DOC_extra_excr_DIAT)
     !call iom_put( 'Nitrogen_Uptake_Diatoms', Nitrogen_Uptake_Diatoms)        
     !call iom_put( 'Carbon_UptakeDiatoms' , Carbon_UptakeDiatoms )            
     !call iom_put( 'Silicate_upDiatoms' , Silicate_upDiatoms )                
#endif      
#ifdef primaryprod
      call iom_put( 'GPP', GPP )
      call iom_put( 'NPP', NPP )
      call iom_put( 'NPPint', NPPintegrated )
#endif
#ifdef biodiagrates
      call iom_put( 'PhytoNitrateReduction', PhytoNitrateReduction ) ;          call iom_put( 'PhytoNitrateReduction2D', PhytoNitrateReductionIntegrated )
      call iom_put( 'TotalRespiration_Zoo' , TotalRespiration_Zoo )  ;          call iom_put( 'TotalRespiration_Zoo2D' , TotalRespiration_ZooIntegrated )
      call iom_put( 'TotalRespiration_Gel' , TotalRespiration_Gel )  ;          call iom_put( 'TotalRespiration_Gel2D' , TotalRespiration_GelIntegrated )
      call iom_put( 'DOCLuptake_BAC' , DOCLuptake_BAC )   ;                           call iom_put( 'DOCLuptake_BAC2D' , DOCLuptake_BACIntegrated )
      ! from chemicaldynamics
      call iom_put( 'ANAMMOX', anammox )   ;                                      call iom_put( 'ANAMMOX2D', anammoxintegrated )
      call iom_put( 'NITRIFICATION', nitrification ) ;                          call iom_put( 'NITRIFICATION2D', nitrificationintegrated )
      ! from bacteria
      call iom_put( 'DENITRIFICATION', denitrification )  ;                     call iom_put( 'DENITRIFICATION2D' , denitrificationintegrated )
      call iom_put( 'BAC_respiration' , Bacteria_respiration )  ;               call iom_put( 'BAC_respiration2D' , Bacteria_respirationIntegrated )
      call iom_put( 'C_Phymort', C_Phymort_output)
      call iom_put( 'N_Phymort', N_Phymort_output)
      call iom_put( 'NHSuptake_BAC', NHSuptake_BAC)
      call iom_put( 'BACExcretion', BACExcretion)
      call iom_put( 'DOXprod_PHY_nutuptake', DOXprod_PHY_nutuptake)
      call iom_put( 'DOXprod_PHY_growth', DOXprod_PHY_growth)
      call iom_put( 'AirSeaOxygenFlux', AirSeaOxygenFlux/ e3t(:,:,1,Kmm))
      call iom_put( 'SID_dissolution', SID_dissolution)
      call iom_put( 'SIO_uptake_diatoms', SIO_uptake_diatoms)
      call iom_put( 'SID_creation', SID_creation)
      call iom_put( 'PHY_NHS_excr', PHY_NHS_excr)
      call iom_put( 'PHY_N_uptake', PHY_N_uptake)
      call iom_put( 'ZOO_excretion', ZOO_n_excretion)

      call iom_put( 'bac_anoxrem' , Bacteria_anoxrem ) ;                        call iom_put( 'bac_anoxrem2D' , Bacteria_anoxremIntegrated )
      call iom_put( 'bac_oxygenconsumption' , Bacteria_oxygenconsumption ) ;    call iom_put( 'bac_oxygenconsumption2D' , Bacteria_oxygenconsumptionIntegrated )
      call iom_put( 'OXIDATIONBYDOX' , oxidation_by_oxygen  )   ;               call iom_put( 'OXIDATIONBYDOX2D' , oxidation_by_oxygenIntegrated )
      call iom_put( 'OXIDATIONBYNOS' , Oxidation_by_nitrate )   ;               call iom_put( 'OXIDATIONBYNOS2D' , Oxidation_by_nitrateIntegrated )
      call iom_put( 'Nitrogen_UptakeDiatoms', Nitrogen_Uptake_Diatoms)  ;       call iom_put( 'Nitrogen_UptakeDiatoms2D', Nitrogen_Uptake_DiatomsIntegrated )
      call iom_put( 'Carbon_UptakeDiatoms' , Carbon_UptakeDiatoms ) ;           call iom_put( 'Carbon_UptakeDiatoms2D' , Carbon_UptakeDiatomsIntegrated )
      call iom_put( 'TotalRespirationDiatoms' , TotalRespirationDiatoms ) ;     call iom_put( 'TotalRespirationDiatoms2D' , TotalRespirationDiatomsIntegrated )
      call iom_put( 'Silicate_upDiatoms' , Silicate_upDiatoms ) ;               call iom_put( 'Silicate_upDiatoms2D' , Silicate_upDiatomsIntegrated )
      call iom_put( 'Nitrogen_UptakeEmiliana', Nitrogen_Uptake_Emiliana ) ;     call iom_put( 'Nitrogen_UptakeEmiliana2D', Nitrogen_Uptake_EmilianaIntegrated )
      call iom_put( 'Carbon_UptakeEmiliana' , Carbon_UptakeEmiliana );          call iom_put( 'Carbon_UptakeEmiliana2D' , Carbon_UptakeEmilianaIntegrated )
      call iom_put( 'TotalRespirationEmiliana' , TotalRespirationEmiliana ) ;   call iom_put( 'TotalRespirationEmiliana2D' , TotalRespirationEmilianaIntegrated )
      call iom_put( 'Nitrogen_UptakeFlagellates', Nitrogen_Uptake_Flagellates); call iom_put( 'Nitrogen_UptakeFlagellates2D', Nitrogen_Uptake_FlagellatesIntegrated )
      call iom_put( 'Carbon_UptakeFlagellates' , Carbon_UptakeFlagellates );    call iom_put( 'Carbon_UptakeFlagellates2D' , Carbon_UptakeFlagellatesIntegrated )
      call iom_put( 'TotalRespirationFlagellates',TotalRespirationFlagellates); call iom_put( 'TotalRespirationFlagellates2D' , TotalRespirationFlagellatesIntegrated )
      call iom_put( 'DOCSLHYDR', DOCSLHYDR_output )
      call iom_put( 'DONSLHYDR', DONSLHYDR_output )
      call iom_put( 'POCHYDR', POCHYDR_output )
      call iom_put( 'PONHYDR', PONHYDR_output )
      call iom_put( 'BAC_GROWTH', BAC_GROWTH )
      call iom_put( 'DONLuptake_BAC', DONLuptake_BAC)
      call iom_put( 'C_BACMort', C_BACMort_output )
      call iom_put( 'N_BACMort', N_BACMort_output )
#endif
#ifdef biodiagtrophic
      call iom_put( 'PHY_TO_ZOO' , PHY_TO_ZOO ) ;                               call iom_put( 'PHY_TO_ZOO2D' , PHY_TO_ZOOIntegrated )
      call iom_put( 'BAC_TO_ZOO' , BAC_TO_ZOO ) ;                               call iom_put( 'BAC_TO_ZOO2D' , BAC_TO_ZOOIntegrated )
      call iom_put( 'POC_TO_ZOO' , POC_TO_ZOO ) ;                               call iom_put( 'POC_TO_ZOO2D' , POC_TO_ZOOIntegrated )
      call iom_put( 'PON_TO_ZOO' , PON_TO_ZOO ) ;                               call iom_put( 'PON_TO_ZOO2D' , PON_TO_ZOOIntegrated )
      call iom_put( 'ZOO_TO_POC', ZOO_TO_POC)
      call iom_put( 'ZOO_TO_PON', ZOO_TO_PON)
      call iom_put( 'DOC_leakage', DOC_leakage_output)
      call iom_put( 'DON_leakage', DON_leakage_output)
      call iom_put( 'DOC_extra_excr', DOC_extra_excr_output)
      call iom_put( 'C_ZOOMessyfeeding', C_ZOOMessyfeeding_output)
      call iom_put( 'N_ZOOMessyfeeding', N_ZOOMessyfeeding_output)
#endif
#ifdef alkalinity_system
      call iom_put( 'pH', pH )
      call iom_rstput( kt, nitrst, numrtw, 'pH', pH )
      call iom_put( 'pCO2', pco2 )
      call iom_put( 'AirSeaDICFlux', AirseaDICFlux )
#ifdef co2syscheck
      ! save here : ta_co2sys, dic_co2sys, co2_co2sys, co3_co2sys, co3_co2sys, hco3,co2sys, ph_co2sys, ta_nato, ta_goyet
      call iom_put( 'TA',   ta_co2sys )
      call iom_put( 'CO2',  co2_co2sys )
      call iom_put( 'CO3',  co3_co2sys )
      call iom_put( 'HCO3', hco3_co2sys )
#endif
#ifdef csystemcheck
      call iom_put( 'pCO2air', pCO2air )
      call iom_put( 'nonCOcharge', noncochargeout )   ;  call iom_put( 'COcharge', cochargeout )
      call iom_put( 'Sicharge', sichargeout )         ;  call iom_put( 'Pcharge', pchargeout )
      call iom_put( 'Boratecharge', boratechargeout ) ;  call iom_put( 'Ammoniumcharge', ammoniumchargeout )
      call iom_put( 'HScharge', hscharge )
      call iom_put( 'SumCO2', sumco2_out ) ! also SumP, SumSi, SumNHx, SumNit, SumBorate, SumHSout, Hplusout
      call iom_put( 'K1_CO2', K1CO2out )    ! also K2CO2, K_H2O, K_BOH3, K1_H3PO4, K2_H3PO4, K3_H3PO4, K_HNO3, K_NH4, K_HNO2, K_H2S, K_Si
#endif
#endif
      !
      ! compute sinking velocity
      call SinkingVelocities(kbb,kmm)
      ! output depends if aggregation is defined in bamhbi.h90
      ! sinking velocities have signs modified (e.g. WDIA=-sinkingspeedDiatom)
      ! trc_sink will modify tr(:,:,:,:,Krhs)
      call trc_sink(kbb,kmm,krhs,CDI,ws_in=WDIA)
      call trc_sink(kbb,kmm,krhs,NDI,ws_in=WDIA)
      call trc_sink(kbb,kmm,krhs,POC,ws_in=WPOM)
      call trc_sink(kbb,kmm,krhs,PON,ws_in=WPOM)
      call trc_sink(kbb,kmm,krhs,SID,ws_scalar=-vsinkingrate_silicious_detritus)
#ifdef aggregation
#ifdef agg_diag
      call iom_put( 'sinkingDIA', WDIA )
      call iom_put( 'sinkingPOM', WPOM )
#endif
      call trc_sink(kbb,kmm,krhs,AGG,ws_in=WAGG)
#endif

#ifdef redistributeSinking
      ! redistribute sinking material to the surface layers (this modifies dPxxx and dDxxx)
      call redistribute_sinking(kbb,kmm)
#endif

#ifdef redistributeLoss
      call redistribute_loss(kbb,kmm)
#endif
      
      ! put all the computed source and sinks in the tracer trend that will be time-integrated by Nemo
      tr(:,:,:,CFL,Krhs) = tr(:,:,:,CFL,Krhs) + dPCFL - dDCFL
      tr(:,:,:,NFL,Krhs) = tr(:,:,:,NFL,Krhs) + dPNFL - dDNFL
      tr(:,:,:,CEM,Krhs) = tr(:,:,:,CEM,Krhs) + dPCEM - dDCEM
      tr(:,:,:,NEM,Krhs) = tr(:,:,:,NEM,Krhs) + dPNEM - dDNEM
      tr(:,:,:,CDI,Krhs) = tr(:,:,:,CDI,Krhs) + dPCDI - dDCDI
      tr(:,:,:,NDI,Krhs) = tr(:,:,:,NDI,Krhs) + dPNDI - dDNDI
      tr(:,:,:,MIC,Krhs) = tr(:,:,:,MIC,Krhs) + dPMIC - dDMIC
      tr(:,:,:,MES,Krhs) = tr(:,:,:,MES,Krhs) + dPMES - dDMES
      tr(:,:,:,BAC,Krhs) = tr(:,:,:,BAC,Krhs) + dPBAC - dDBAC
      tr(:,:,:,DCL,Krhs) = tr(:,:,:,DCL,Krhs) + dPDCL - dDDCL
      tr(:,:,:,DNL,Krhs) = tr(:,:,:,DNL,Krhs) + dPDNL - dDDNL
      tr(:,:,:,DCS,Krhs) = tr(:,:,:,DCS,Krhs) + dPDCS - dDDCS
      tr(:,:,:,DNS,Krhs) = tr(:,:,:,DNS,Krhs) + dPDNS - dDDNS
      tr(:,:,:,NOS,Krhs) = tr(:,:,:,NOS,Krhs) + dPNOS - dDNOS
      tr(:,:,:,NHS,Krhs) = tr(:,:,:,NHS,Krhs) + dPNHS - dDNHS
      tr(:,:,:,SIO,Krhs) = tr(:,:,:,SIO,Krhs) + dPSIO - dDSIO
      tr(:,:,:,DOX,Krhs) = tr(:,:,:,DOX,Krhs) + dPDOX - dDDOX  ; tr(:,:,1,DOX,Krhs)= tr(:,:,1,DOX,Krhs) + AirSeaOxygenFlux / e3t(:,:,1,Kmm)
      tr(:,:,:,DIC,Krhs) = tr(:,:,:,DIC,Krhs) + dPDIC - dDDIC
#ifdef alkalinity_system
      tr(:,:,1,DIC,Krhs) = tr(:,:,1,DIC,Krhs) + AirseaDICFlux / e3t(:,:,1,Kmm)
#endif
      tr(:,:,:,ODU,Krhs) = tr(:,:,:,ODU,Krhs) + dPODU - dDODU
      tr(:,:,:,POC,Krhs) = tr(:,:,:,POC,Krhs) + dPPOC - dDPOC
      tr(:,:,:,PON,Krhs) = tr(:,:,:,PON,Krhs) + dPPON - dDPON
      tr(:,:,:,SID,Krhs) = tr(:,:,:,SID,Krhs) + dPSID - dDSID
#ifdef aggregation
      tr(:,:,:,AGG,Krhs) = tr(:,:,:,AGG,Krhs) + dPAGG - dDAGG
#endif
#ifdef gelatinous
      tr(:,:,:,GEL,Krhs) = tr(:,:,:,GEL,Krhs) + dPGEL - dDGEL
      tr(:,:,:,NOC,Krhs) = tr(:,:,:,NOC,Krhs) + dPNOC - dDNOC
#endif
      tr(:,:,:,PHO,Krhs) = tr(:,:,:,PHO,Krhs) + dPPHO - dDPHO
#ifdef chlorophyll_geider
      tr(:,:,:,CHD,Krhs) = tr(:,:,:,CHD,Krhs) + dPCHD - dDCHD
      tr(:,:,:,CHE,Krhs) = tr(:,:,:,CHE,Krhs) + dPCHE - dDCHE
      tr(:,:,:,CHF,Krhs) = tr(:,:,:,CHF,Krhs) + dPCHF - dDCHF
#endif
#ifdef alkalinity_system
      tr(:,:,:,CHA,Krhs) = tr(:,:,:,CHA,Krhs) + dPCHA - dDCHA
#endif

      ! apply here trend of BENTHIC model
      if ( ln_benthic) then
         if (waves_botstr .gt. 0 ) then
             call trc_wbstress(kt,kmm)
#ifdef botstressdiag
             call iom_put( 'wav_stress', wavestress )
#endif
         end if
         call trc_sms_ben( kt , kbb, kmm, krhs )
#ifdef botstressdiag
         call iom_put( 'cur_stress', curstress )
         call iom_put( 'tot_stress', botstress ) 
         call iom_put( 'resuspcounter_f', resuspcounter_f)
         call iom_put( 'resuspcounter_s', resuspcounter_s) 
#endif
      end if

#ifdef aggregation
      ! Limit AGG production in the trend tr(:,:,:,AGG,Krhs)
      call limit_dAGG(Krhs)
#endif

#ifdef temp_clip
      ! now copy back the (unclipped) state to Kbb
      tr(:,:,:,jp_myt0:jp_myt1,Kbb)=unclipped_var
#endif

#ifdef testcons2
      ! here we use "budgetC" to avoid defining a new variable, but we actually check if the spatial sum of the TREND (tra) is zero
      BudgetC=0. ; BudgetN=0. ; BudgetSi=0.
      ! cvol is defined in module TRC, cvol = tmask * e1 * e2 * e3

      BudgetC= cvol * (tr(:,:,:,CFL,Krhs)+tr(:,:,:,CDI,Krhs)+tr(:,:,:,CEM,Krhs)+tr(:,:,:,MES,Krhs)+tr(:,:,:,MIC,Krhs)+tr(:,:,:,BAC,Krhs)+tr(:,:,:,POC,Krhs)+tr(:,:,:,DCL,Krhs)+tr(:,:,:,DCS,Krhs)+tr(:,:,:,DIC,Krhs) )
      BudgetN= cvol * (tr(:,:,:,NFL,Krhs)+tr(:,:,:,NDI,Krhs)+tr(:,:,:,NEM,Krhs)+ NCrMesoZoo*tr(:,:,:,MES,Krhs) + NCrMicroZoo*tr(:,:,:,MIC,Krhs) + NCrBAC*tr(:,:,:,BAC,Krhs) + tr(:,:,:,PON,Krhs)+tr(:,:,:,DNL,Krhs)+tr(:,:,:,DNS,Krhs)+tr(:,:,:,NOS,Krhs)+tr(:,:,:,NHS,Krhs) )
#ifdef gelatinous
      BudgetC=BudgetC + cvol*( tr(:,:,:,GEL,Krhs)+tr(:,:,:,NOC,Krhs) )
      BudgetN=BudgetN + cvol*( NCrNoctiluca*tr(:,:,:,NOC,Krhs) + NCrGelatinous*tr(:,:,:,GEL,Krhs) )
#endif
      BudgetSi=cvol * (SiNrDiatoms*tr(:,:,:,NDI,Krhs) + tr(:,:,:,SIO,Krhs) + tr(:,:,:,SID,Krhs))

      integrated_budget=glob_sum(budgetC) ; if (lwp) write(numout,*) "tra(C) = ",integrated_budget
      integrated_budget=glob_sum(budgetN) ; if (lwp) write(numout,*) "tra(N) = ",integrated_budget
      integrated_budget=glob_sum(budgetSi); if (lwp) write(numout,*) "tra(Si)= ",integrated_budget

      BudgetC= cvol*(abs(tr(:,:,:,CFL,Krhs))+abs(tr(:,:,:,CEM,Krhs))+abs(tr(:,:,:,CDI,Krhs))+abs(tr(:,:,:,MIC,Krhs))+abs(r(:,:,:,MES,Krhs))+abs(tr(:,:,:,BAC,Krhs))+abs(tr(:,:,:,POC,Krhs))+abs(tr(:,:,:,DCL,Krhs))+abs(tr(:,:,:,DCS,Krhs))+abs(tr(:,:,:,DIC,Krhs)))
#ifdef gelatinous
      BudgetC=BudgetC+cvol*(abs(tr(:,:,:,GEL,Krhs))+abs(tr(:,:,:,NOC,Krhs)))
#endif
      integrated_budget=glob_sum(budgetC) ; if (lwp) write(numout,*) "abs(tra(C)) = ",integrated_budget
#endif

      ! Save the trends in the mixed layer
      IF( l_trdtrc ) THEN
          DO jn = jp_myt0, jp_myt1
            ztrmyt(:,:,:) = tr(:,:,:,jn,Krhs)
            CALL trd_trc( ztrmyt, jn, jptra_sms, kt, Kmm )   ! save trends
          END DO
          DEALLOCATE( ztrmyt )
      END IF
      !
      IF( ln_timing )   CALL timing_stop('trc_sms_my_trc')
      !
   END SUBROUTINE trc_sms_my_trc


   INTEGER FUNCTION trc_sms_my_trc_alloc(kbb,kmm)
      !!----------------------------------------------------------------------
      !!              ***  ROUTINE trc_sms_my_trc_alloc  ***
      !!----------------------------------------------------------------------
      integer :: alloc_ok, kbb, kmm
      !
      ! ALLOCATE here the arrays specific to MY_TRC
      ! ALLOCATE( tab(...) , STAT=trc_sms_my_trc_alloc )
      !
      call bioinit(alloc_ok,kbb,kmm)
      trc_sms_my_trc_alloc = alloc_ok
      !
      IF( trc_sms_my_trc_alloc /= 0 ) CALL ctl_stop( 'STOP', 'trc_sms_my_trc_alloc : failed to allocate arrays' )
      !
   END FUNCTION trc_sms_my_trc_alloc

   !!======================================================================
END MODULE trcsms_my_trc
