MODULE trcnam_my_trc
#include "bamhbi.h90"
   !!======================================================================
   !!                      ***  MODULE trcnam_my_trc  ***
   !! TOP :   initialisation of some run parameters for MY_TRC bio-model
   !!======================================================================
   !! History :      !  2007  (C. Ethe, G. Madec) Original code
   !!                !  2016  (C. Ethe, T. Lovato) Revised architecture
   !!----------------------------------------------------------------------
   !! trc_nam_my_trc      : MY_TRC model initialisation
   !!----------------------------------------------------------------------
   USE oce_trc         ! Ocean variables
   USE par_trc         ! TOP parameters
   USE trc             ! TOP variables
   USE bamhbi_params
   
   IMPLICIT NONE
   PRIVATE

   PUBLIC   trc_nam_my_trc   ! called by trcnam.F90 module

   !!----------------------------------------------------------------------
   !! NEMO/TOP 4.0 , NEMO Consortium (2018)
   !! $Id: trcnam_my_trc.F90 10068 2018-08-28 14:09:04Z nicolasmartin $ 
   !! Software governed by the CeCILL license (see ./LICENSE)
   !!----------------------------------------------------------------------

CONTAINS

   SUBROUTINE trc_nam_my_trc
      !!----------------------------------------------------------------------
      !!                     ***  trc_nam_my_trc  ***  
      !!
      !! ** Purpose :   read MY_TRC namelist
      !!
      !!----------------------------------------------------------------------
      !
      !
      READ( numnat_cfg, namtrc_bamhbi )
      IF(lwp) WRITE(numout,*)
      IF(lwp) WRITE(numout,*) ' trc_nam_my_trc : read BAMHBI namelists'
      IF(lwp) WRITE(numout,*) ' ~~~~~~~~~~~~~~~'
      IF(lwp) WRITE(numout,*)
      !
#ifdef chlorophyll_geider
      READ( numnat_cfg, namtrc_bamhbi_geider )
      IF(lwp) WRITE(numout,*) ' namtrc_bamhbi_geider: read BAMHBI Geider Chlorophyll namelist'
#endif
#ifdef aggregation
     READ( numnat_cfg, namtrc_bamhbi_aggregation )
     IF(lwp) WRITE(numout,*) ' namtrc_bamhbi_aggregation: read BAMHBI Aggregation namelist'
#endif
#ifdef gelatinous
      READ( numnat_cfg, namtrc_bamhbi_gelatinous )
      IF(lwp) WRITE(numout,*) ' namtrc_bamhbi_gelatinous: read BAMHBI Gelatinous namelist'
#endif
#if defined fulloptics || defined simpleoptics
      READ( numnat_cfg, namtrc_bamhbi_optics )
      IF(lwp) WRITE(numout,*) ' namtrc_bamhbi_optics: read BAMHBI Fulloptics and simpleoptics namelist'
#endif
#ifdef benthic
      READ( numnat_cfg, namtrc_bamhbi_benthic )
      IF(lwp) WRITE(numout,*) ' namtrc_bamhbi_benthic: read BAMHBI Benthic namelist'
#endif
#ifdef alkalinity_system
      READ( numnat_cfg, namtrc_bamhbi_alka )
      IF(lwp) WRITE(numout,*) ' namtrc_bamhbi_alka: read BAMHBI alkalinity system namelist'
#endif
#ifdef redistributeSinking
      READ( numnat_cfg, namtrc_bamhbi_redist )
      IF(lwp) WRITE(numout,*) ' namtrc_bamhbi_redist: read BAMHBI redistribution namelist'
#endif
      IF(lwp) WRITE(numout,*) ' ~~~~~~~~~~~~~~~'
   END SUBROUTINE trc_nam_my_trc
   
   !!======================================================================
END MODULE trcnam_my_trc
