MODULE trcini_my_trc
#include "bamhbi.h90"
   !!======================================================================
   !!                         ***  MODULE trcini_my_trc  ***
   !! TOP :   initialisation of the MY_TRC tracers
   !!======================================================================
   !! History :        !  2007  (C. Ethe, G. Madec) Original code
   !!                  !  2016  (C. Ethe, T. Lovato) Revised architecture
   !!----------------------------------------------------------------------
   !! trc_ini_my_trc   : MY_TRC model initialisation
   !!----------------------------------------------------------------------
   USE par_trc         ! TOP parameters
   USE oce_trc
   USE trc
   USE par_my_trc
   USE trcnam_my_trc     ! MY_TRC SMS namelist
   USE trcsms_my_trc
   USE iom
   USE bamhbi
   USE trcini_ben
   USE trcwbstress
   
   IMPLICIT NONE
   PRIVATE

   PUBLIC   trc_ini_my_trc   ! called by trcini.F90 module

   !!----------------------------------------------------------------------
   !! NEMO/TOP 4.0 , NEMO Consortium (2018)
   !! $Id: trcini_my_trc.F90 12377 2020-02-12 14:39:06Z acc $ 
   !! Software governed by the CeCILL license (see ./LICENSE)
   !!----------------------------------------------------------------------
CONTAINS

   SUBROUTINE trc_ini_my_trc( Kbb, Kmm )
      !!----------------------------------------------------------------------
      !!                     ***  trc_ini_my_trc  ***  
      !!
      !! ** Purpose :   initialization for MY_TRC model
      !!
      !! ** Method  : - Read the namcfc namelist and check the parameter values
      !!----------------------------------------------------------------------
      INTEGER, INTENT(in) ::   Kbb, Kmm  ! time level indices
      INTEGER             :: jn
      !
      CALL trc_nam_my_trc
      !
      !                       ! Allocate MY_TRC arrays
      IF( trc_sms_my_trc_alloc(kbb,kmm) /= 0 )   CALL ctl_stop( 'STOP', 'trc_ini_my_trc: unable to allocate MY_TRC arrays' )

      IF(lwp) WRITE(numout,*)
      IF(lwp) WRITE(numout,*) ' trc_ini_my_trc: passive tracer unit vector'
      IF(lwp) WRITE(numout,*) ' To check conservation : '
      IF(lwp) WRITE(numout,*) '   1 - No sea-ice model '
      IF(lwp) WRITE(numout,*) '   2 - No runoff ' 
      IF(lwp) WRITE(numout,*) '   3 - precipitation and evaporation equal to 1 : E=P=1 ' 
      IF(lwp) WRITE(numout,*) ' ~~~~~~~~~~~~~~'
      !
#ifdef alkalinity_system
      IF( .not.ln_reinitialize_pH .and. ln_rsttr ) THEN
         IF (lwp) WRITE(numout,*) 'initializing pH from restart file'
         CALL iom_get (numrtr, jpdom_auto , 'pH', pHB )
      ENDIF
#ifdef airpco2
      call init_air_pCO2            ! read atmospheric pCO2 from netcdf files
#endif
#endif
      IF( ln_benthic ) then
         CALL trc_ini_ben(Kbb,Kmm)  ! benthic module
         CALL trc_ini_wbstress      ! wave bottom stress effect on tracers
         CALL trc_ini_curstress      ! option for bottom current stress (BAMHBI vs NEMO)
         call benthic_init(Kbb,Kmm) ! bamhbi benthic pointers
      ENDIF

      IF( .NOT. ln_rsttr ) THEN
         DO jn=jp_myt0,jp_myt1
            tr(:,:,:,jn,Kmm) = small_concentration * tmask(:,:,:)  ! instead of 0._wp , initialize to "small_concentration" defined in bamhbi
         END DO
      ENDIF
      !
   END SUBROUTINE trc_ini_my_trc

   !!======================================================================
END MODULE trcini_my_trc
