MODULE trcwri_ben
   !!======================================================================
   !!                         ***  MODULE tr  ***
   !! BEN :   Manage the benthic module restart
   !!======================================================================
   !! History :      !  2017  (T. Lovato) Create Benthic infrastructure
   !!----------------------------------------------------------------------

   !!----------------------------------------------------------------------
   !!   trc_rst        : Restart for passive tracer
   !!   trc_rst_opn    : open  restart file
   !!   trc_rst_read   : read  restart file
   !!   trc_rst_wri    : write restart file
   !!----------------------------------------------------------------------
   USE oce_trc
   USE trc
   USE iom
   USE daymod
   USE par_ben

   IMPLICIT NONE
   PRIVATE

   PUBLIC   trc_wri_ben

CONTAINS

   SUBROUTINE trc_wri_ben (Kmm)
      !!----------------------------------------------------------------------
      !!                    ***  trc_wri_ben  ***
      !!
      !! ** purpose  :   output of benthic variable in Netcdf file
      !!        Here we write the Kmm step, to be consistent with trcwri_my_trc and trcwri.F90
      !!----------------------------------------------------------------------
      INTEGER, INTENT(in)  :: Kmm
      CHARACTER (len=20)   :: cltra
      INTEGER              :: jn
      !!----------------------------------------------------------------------

      ! write the tracer concentrations in the file
      ! ---------------------------------------
      DO jn = 1, jp_ben
         cltra = TRIM( cbennm(jn) )                  ! short title for tracer
         CALL iom_put( cltra, bt(:,:,:,jn,Kmm) )
      END DO 

   END SUBROUTINE trc_wri_ben

   !!======================================================================
END MODULE trcwri_ben


