MODULE trcnam_ben
#include "bamhbi.h90"
   !!======================================================================
   !!                      ***  MODULE trcnam_ben  ***
   !! TOP :   initialisation of some run parameters for Benthic module
   !!======================================================================
   !! History :      !  2017  (T. Lovato) Create Benthic infrastructure
   !!----------------------------------------------------------------------
   !! trc_nam_ben      : Benthic module initialisation
   !!----------------------------------------------------------------------
   USE oce_trc         ! Ocean variables
   USE par_trc         ! TOP parameters
   USE trc             ! TOP variables
   USE par_ben

   IMPLICIT NONE
   PRIVATE

   PUBLIC   trc_nam_ben   ! called by trcnam.F90 module

   TYPE(BTRACER),  DIMENSION(jpmaxben), PUBLIC  :: sn_bentrc  ! type of tracer for saving if not key_iomput
   !!----------------------------------------------------------------------
   !! NEMO/TOP 4.0 , NEMO Consortium (2017)
   !! $Id$
   !! Software governed by the CeCILL licence (NEMOGCM/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------

CONTAINS

   SUBROUTINE trc_nam_ben
      !!----------------------------------------------------------------------
      !!                     ***  trc_nam_ben  ***
      !!
      !! ** Purpose :   read Benthic namelist
      !!
      !!----------------------------------------------------------------------
      INTEGER :: jn, ierr, benthiccounter
      CHARACTER(LEN=6), PARAMETER :: BENTRC_NAMES(*) = (/ 'fCSED ','sCSED ','sSSED ','fSSED ','NCrSED', '      ' /)
      !
      NAMELIST/namben/ jp_ben, jp_benlvl, ln_bendta, cn_benrst_in, cn_benrst_out, sn_bentrc
      !
      !!---------------------------------------------------------------------
      ! default values
      jp_ben    = 1
      jp_benlvl = 1
      ln_bendta = .FALSE.
      cn_benrst_in  = 'restart_ben'
      cn_benrst_out = 'restart_ben'

      ! Dummy settings to fill tracers data structure
      !                  !   name   !   title   !   unit   !   init  !   sbc   !   cbc   !   obc   !   ais   !
      sn_bentrc = BTRACER( 'NONAME' , 'NOTITLE' , 'NOUNIT' , .false. )


      IF(lwp) WRITE(numout,*)
      IF(lwp) WRITE(numout,*) 'trc_nam_ben : read the benthic module namelist'
      IF(lwp) WRITE(numout,*) '~~~~~~~'
      !
      READ  ( numnat_cfg, namben )
      IF (ln_enforce_consistency) THEN
          benthiccounter=5
          !first total number check
          IF (jp_ben /= benthiccounter) THEN
              WRITE(ctmp1,*) 'BAMHBI BENTHIC TRACER CHECK: Wrong number of tracers - Namelist jp_ben = ', jp_ben, 'Model configuration (bamhbi.h90) requires = ', benthiccounter
              CALL ctl_stop(ctmp1)
          ENDIF
    
          !
          DO jn = 1, jp_ben
              IF (ln_bendta) THEN
                  IF (TRIM(BENTRC_NAMES(jn)) /= '      ') THEN
                      ! Check base tracer name
                      IF (TRIM(sn_bentrc(jn)%clsname) /= TRIM(BENTRC_NAMES(jn))) THEN
                          WRITE(ctmp1,*) 'BAMHBI BENTHIC CHECK: Wrong tracer at position ', jn, ' Expected ', &
                                         TRIM(BENTRC_NAMES(jn)), ' Found ', TRIM(sn_bentrc(jn)%clsname)
                          CALL ctl_stop(ctmp1) 
                      ENDIF
                  ENDIF
              ENDIF
          ENDDO
      ENDIF

      IF(lwp) THEN                  ! control print
         WRITE(numout,*) ' '
         WRITE(numout,*) ' Benthic module'
         WRITE(numout,*) ' '
         WRITE(numout,*) '  Namelist : namben '
         WRITE(numout,*) ' ~~~~~~~'
         WRITE(numout,*) '   Total number of benthic tracers              jp_ben        = ', jp_ben
         WRITE(numout,*) '   Total number of benthic vertical levels      jp_benlvl     = ', jp_benlvl
         WRITE(numout,*) '   Initialize benthic tracers from data         ln_bendta     = ', ln_bendta
         WRITE(numout,*) '   Input restart file is                        cn_benrst_in  = ', TRIM(cn_benrst_in)
         WRITE(numout,*) '   Output restart file is                       cn_benrst_out = ', TRIM(cn_benrst_out)
         WRITE(numout,*) ' '
      ENDIF
      !
   END SUBROUTINE trc_nam_ben

   !!======================================================================
END MODULE trcnam_ben

