MODULE trcini_ben
#include "bamhbi.h90"
   !!======================================================================
   !!                         ***  MODULE trcini_ben  ***
   !! TOP :   initialisation of the Benthic tracers
   !!======================================================================
   !! History :      !  2017  (T. Lovato) Create benthic infrastructure
   !!----------------------------------------------------------------------
   !! trc_ini_ben    : Benthic  model initialisation
   !!----------------------------------------------------------------------
   USE par_trc         ! TOP parameters
   USE oce_trc
   USE trc
   USE par_ben
   USE trcnam_ben      ! Benthic namelist
   USE trcrst_ben

   IMPLICIT NONE
   PRIVATE

   PUBLIC   trc_ini_ben   ! called by trcini.F90 module

   !!----------------------------------------------------------------------
   !! NEMO/TOP 4.0 , NEMO Consortium (2017)
   !! $Id$ 
   !! Software governed by the CeCILL licence     (NEMOGCM/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------
#include "do_loop_substitute.h90"
CONTAINS

   SUBROUTINE trc_ini_ben ( kbb, kmm )
      !!----------------------------------------------------------------------
      !!                     ***  trc_ini_ben  ***  
      !!
      !! ** Purpose :   initialization for benthic module
      !!
      !! ** Method  : - Read the namben namelist and check the parameter values
      !!----------------------------------------------------------------------
      INTEGER, intent(in) :: kbb, kmm
      INTEGER  :: jn, ji,jj,jk
      !!----------------------------------------------------------------------
      !
      CALL trc_nam_ben
      !
      ! Allocate benthic arrays
      IF( trc_ben_alloc() /= 0 )   CALL ctl_stop( 'STOP', 'trc_ini_ben: unable to allocate Benthic arrays' )

      IF(lwp) WRITE(numout,*)
      IF(lwp) WRITE(numout,*) ' trc_ini_ben   : Initialize benthic tracers vector'
      IF(lwp) WRITE(numout,*) ' ~~~~~~~~~~~~~~'
      IF(lwp) WRITE(numout,*)
      ! 
      ! zeroing arrays 
      bt = 0._wp
      !
      ! TL:  add here by hand layers depths, need to be read somewhere!
      ben_depths = 0.1_wp
      IF(lwp) WRITE(numout,*) '  Benthic vertical layers ben_depths : ', ben_depths
      !
      ! Pass sn_bentrc fields to specialized arrays
      IF(lwp) WRITE(numout,*) '   ##  NAME     DESCRIPTION     UNIT     INIT '   
      DO jn = 1, jp_ben
         cbennm    (jn) = TRIM( sn_bentrc(jn)%clsname )
         cbenln    (jn) = TRIM( sn_bentrc(jn)%cllname )
         cbenun    (jn) = TRIM( sn_bentrc(jn)%clunit  )
         ln_ben_ini(jn) =       sn_bentrc(jn)%llinit
         IF(lwp) WRITE(numout,'(i6,2x,a9,a16,a10,l2)') jn,cbennm(jn),cbenln(jn),cbenun(jn),ln_ben_ini(jn)
      END DO

      ! Initialize tracers
      IF( .NOT. ln_rsttr ) THEN 
         call trc_dta_ben(nit000, kbb, kmm)
      ELSE
         call ben_rst_cal( nittrc000, 'READ' )   ! calendar
         call ben_rst_read (kbb, kmm)
      ENDIF
      !
      ! Mask land points
      do jn = 1, jp_ben
        do jk = 1, jp_benlvl
          DO_2D(0,0,0,0)
            if (tmask(ji,jj,1).eq.0)  bt(ji,jj,jk,jn,kbb) = 0.0_wp
          END_2D
        end do
      end do      
      IF( .NOT. ln_rsttr ) bt(:,:,:,:,kmm) = bt(:,:,:,:,kbb) 

    END SUBROUTINE trc_ini_ben

   SUBROUTINE trc_dta_ben(kt, kbb, kmm)
      !!----------------------------------------------------------------------
      !!                     ***  trc_dta_ben  ***
      !!
      !! ** Purpose :   Read initial conditions (IC) for benthic system
      !!
      !! ** Method  : - Read the namben_dta namelist and fill in IC from file
      !!----------------------------------------------------------------------
      use iom
      USE fldread       !  read input fields
      !
      INTEGER, INTENT( in )  ::   kt, kbb, kmm               ! time step
      ! arrays for data I/O
      INTEGER                                 :: nb_trcdta   ! number of tracers to be initialised with data
      INTEGER  , ALLOCATABLE, DIMENSION(:)    :: n_trc_index ! indice of tracer which is initialised with data 
      REAL(wp) , ALLOCATABLE, DIMENSION(:)    :: rf_benfac   ! field multiplicative factor for tracer values
      TYPE(FLD), ALLOCATABLE, DIMENSION(:)    :: sf_bendta   ! field structure of input (file informations, fields read)
      REAL(wp) , ALLOCATABLE, DIMENSION(:)    :: rn_benfac   ! namelist multiplicative factor for tracer values
      TYPE(FLD_N), ALLOCATABLE, DIMENSION(:)  :: sn_bendta   ! namelist structure of input (file informations, fields read)
      TYPE(FLD_N), ALLOCATABLE, DIMENSION(:)  :: slf_i       ! structure of input for fldread (file informations, fields read)
      !
      INTEGER :: jn, jl, ierr1, ierr2
      CHARACTER(LEN=6), PARAMETER :: BENTRC_NAMES(*) = (/ 'fCSED ','sCSED ','sSSED ','fSSED ','NCrSED', '      ' /)

      CHARACTER(len=100) :: cn_dir
      !
      NAMELIST/namben_dta/ sn_bendta, cn_dir, rn_benfac
      !!----------------------------------------------------------------------
      ierr1 = 0  ;  ierr2 = 0
      !
      ALLOCATE( n_trc_index(jp_ben), rn_benfac(jp_ben), sn_bendta(jp_ben), STAT=ierr1 )
      IF( ierr1 > 0 ) THEN
         CALL ctl_stop( 'trc_dta_ben: unable to allocate namelist arrays' )   ;   RETURN
      ENDIF
      ! dummy values of namelist
      cn_dir  = './'
      rn_benfac(:) = 1._wp 
      !              ! filename ! freq !  title   ! interp !  clim  ! 1m/1y ! wgt ! rot ! SoL !
      sn_bendta = FLD_N( 'NONAME' ,  0   , 'NOTITLE', .false., .false.,  ''   ,  '' ,  '' , '')
      !
      IF(lwp) WRITE(numout,*)
      IF(lwp) WRITE(numout,*) ' trc_dta_ben  : Read namelist namben_dta '
      IF(lwp) WRITE(numout,*) ' ~~~~~~~~~~~~~~'
      !
      READ  ( numnat_cfg, namben_dta )
      
      IF (ln_enforce_consistency) THEN
              !benthic tracer namelist check
              DO jn = 1, jp_ben
                  IF (ln_bendta) THEN
                      IF (TRIM(BENTRC_NAMES(jn)) /= '      ') THEN
                          ! Check initialization data if enabled
                              IF (TRIM(sn_bendta(jn)%clvar) /= TRIM(BENTRC_NAMES(jn))) THEN
                                  WRITE(ctmp1,*) 'BAMHBI BENTHIC CHECK: Wrong initialization data for tracer ', &
                                                TRIM(BENTRC_NAMES(jn)), ' at position ', jn, 'Found ', TRIM(sn_bendta(jn)%clvar)
                                  CALL ctl_stop(ctmp1)
                              ENDIF
                      ENDIF
                  ENDIF
              END DO
      ENDIF


      !
      nb_trcdta = 0
      n_trc_index(:) = 0
      DO jn = 1, jp_ben
         IF ( ln_ben_ini(jn) ) THEN 
            nb_trcdta = nb_trcdta + 1
            n_trc_index(jn) = nb_trcdta
            IF (lwp) write(numout,*) &
               '  -> read IC for ',TRIM(cbennm(jn)),' form file ',TRIM(sn_bendta(jn)%clname), ' with varname ',TRIM(sn_bendta(jn)%clvar)
         ENDIF
      ENDDO
      ! 
      ! skip if no data to read
      IF ( nb_trcdta == 0 ) RETURN
      !
      ! Load input data structure 
      ALLOCATE( sf_bendta(nb_trcdta), rf_benfac(nb_trcdta), slf_i(nb_trcdta), STAT=ierr1 )
      IF( ierr1 > 0 ) THEN
         CALL ctl_stop( 'trc_dta_ben: unable to allocate field arrays' )   ;   RETURN
      ENDIF
      ! 
      DO jn = 1, jp_ben
         IF( ln_ben_ini(jn) ) THEN      ! update passive tracers arrays with input data read from file
            jl = n_trc_index(jn)
            slf_i(jl)     = sn_bendta(jn)
            rf_benfac(jl) = rn_benfac(jn)
                                         ALLOCATE( sf_bendta(jl)%fnow(jpi,jpj,jp_benlvl)   , STAT=ierr1 )
            IF( sn_bendta(jn)%ln_tint )  ALLOCATE( sf_bendta(jl)%fdta(jpi,jpj,jp_benlvl,2) , STAT=ierr2 )
            IF( ierr1 + ierr2 > 0 ) THEN
              CALL ctl_stop( 'trc_dta_ben : unable to allocate benthic tracer data arrays' )   ;   RETURN
            ENDIF
         ENDIF
         !
      ENDDO
      !                         ! fill sf_trcdta with slf_i and control print
      CALL fld_fill( sf_bendta, slf_i, cn_dir, 'trc_dta_ben', 'Benthic tracer data', 'namben_dta' )
      ! 
      ! read data at kt time step
      CALL fld_read( kt, 1, sf_bendta )
      !
      ! Fill arrays with initial fields
      DO jn = 1, nb_trcdta
         bt(:,:,:,jn,Kbb) = sf_bendta(jn)%fnow(:,:,:)  * rf_benfac(jn)   ! NO mask
      ENDDO
      !
      DEALLOCATE( n_trc_index, rn_benfac, sn_bendta )      
      !
   END SUBROUTINE trc_dta_ben

   INTEGER FUNCTION trc_ben_alloc()
      !!----------------------------------------------------------------------
      !!              ***  ROUTINE trc_sms_ben_alloc  ***
      !!----------------------------------------------------------------------
      !
      ! ALLOCATE here the arrays specific to Benthic system
      ALLOCATE( bt(jpi,jpj,jp_benlvl,jp_ben,jpt),                                   &
              & cbennm(jp_ben), cbenln(jp_ben), cbenun(jp_ben), ln_ben_ini(jp_ben), &
              & ben_depths(jp_benlvl), &
              & STAT=trc_ben_alloc )
      !
      IF( trc_ben_alloc /= 0 ) CALL ctl_warn('trc_sms_ben_alloc : failed to allocate arrays')
      !
   END FUNCTION trc_ben_alloc

   !!======================================================================
END MODULE trcini_ben
