MODULE par_ben
   !!======================================================================
   !!                        ***  par_ben  ***
   !! TOP :   set the Benthic parameters
   !!======================================================================
   !! History :      !  2017  (T. Lovato) Create Benthic infrastructure
   !!----------------------------------------------------------------------
   !! NEMO/TOP 3.3 , NEMO Consortium (2017)
   !! $Id$
   !! Software governed by the CeCILL licence (NEMOGCM/NEMO_CeCILL.txt)
   !!----------------------------------------------------------------------
   USE par_kind

   IMPLICIT NONE
   INTEGER, PUBLIC             :: jp_ben        ! number of benthic tracers (solid+pore water)
   INTEGER, PUBLIC             :: jp_benlvl     ! number of benthic system vertical layers
   INTEGER, PUBLIC,  PARAMETER :: jpmaxben = 10   ! Maximum number of benthic tracers
   !
   CHARACTER(len = 80), PUBLIC  :: cn_benrst_in   !: suffix of pass. tracer restart name (input)
   CHARACTER(len = 80), PUBLIC  :: cn_benrst_out  !: suffix of pass. tracer restart name (output)
   CHARACTER(len = 256), PUBLIC :: cn_benrst_indir    !: restart input directory
   CHARACTER(len = 256), PUBLIC :: cn_benrst_outdir   !: restart output directory
   !
   LOGICAL, PUBLIC             :: ln_bendta       ! Read inputs data from files
   !
   REAL(wp), PUBLIC, ALLOCATABLE, SAVE, DIMENSION(:) ::  ben_depths !: Benthic system vertical levels
   ! 
   REAL(wp), PUBLIC, ALLOCATABLE, SAVE, DIMENSION(:,:,:,:,:) ::  bt  !: Benthic tracer concentration for all time steps
   !
   CHARACTER(len = 20), PUBLIC, ALLOCATABLE, SAVE, DIMENSION(:)    ::  cbennm         !: tracer name
   CHARACTER(len = 80), PUBLIC, ALLOCATABLE, SAVE, DIMENSION(:)    ::  cbenln         !: trccer field long name
   CHARACTER(len = 20), PUBLIC, ALLOCATABLE, SAVE, DIMENSION(:)    ::  cbenun         !: tracer unit
   LOGICAL            , PUBLIC, ALLOCATABLE, SAVE, DIMENSION(:)    ::  ln_ben_ini     !: Initialisation from data input file
   ! 
   !!======================================================================
END MODULE par_ben
