module benthic_metamodels
#include "bamhbi.h90"

#ifdef forcingmodel_nemo
  use par_kind, only : wp
#endif
#ifdef forcingmodel_deSolve
  use bamhbi_nemo2r, only : wp
#endif

contains

#ifdef metamodel_ORIG
      subroutine Panoxfun(CFLUXPERHOUR,nmin,BDOX,bN3n,bN4n,Panox)
      IMPLICIT NONE
      real(wp),intent(IN) :: CFLUXPERHOUR,nmin,BDOX,bN3n,bN4n
      real(wp)            :: Panox


      panox = 1.056&
             -0.132*log(CFLUXPERHOUR)&
             +0.005*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)&
             +0.057*log(CFLUXPERHOUR)*log(BDOX)&
             -0.017*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(BDOX)&
             -0.008*log(BDOX)*log(BDOX)

      Panox=max(Panox,0.d0)
      Panox=min(Panox,1.d0)
      end subroutine Panoxfun

      subroutine Pnitfun(CFLUXPERHOUR,nmin,BDOX,BNOS,BNHS,Pnit)
      IMPLICIT NONE
      real(wp),intent(IN)  :: CFLUXPERHOUR,nmin,BDOX,BNOS,BNHS
      real(wp),intent(OUT) :: Pnit

      pnit = -6.280&
             -0.286*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)&
             +0.127*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)&
             +0.006*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)&
             +0.098*log(CFLUXPERHOUR)*log(BDOX)&
             +0.202*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(BDOX)&
             -0.021*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(BDOX)&
             -0.031*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(BDOX)*log(BDOX)&
             -0.066*log(CFLUXPERHOUR)*log(BNHS)&
             +0.009*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(BNOS)&
             +0.823*log(BDOX)&
             -0.028*log(BDOX)*log(BDOX)&
             -0.012*log(BDOX)*log(BNHS)&
             +0.119*log(BNHS)&
             +0.015*log(BNHS)*log(BNHS)
      if (Nmin.eq.0) then
         pnit=0
      else
         pnit=exp(pnit)/(Nmin)
      end if
 
      end subroutine Pnitfun


      subroutine Pdenitfun(CFLUXPERHOUR,nmin,BDOX,BNOS,bN4n,Pdenit)
      IMPLICIT NONE
      real(wp),intent(IN) :: CFLUXPERHOUR,nmin,BDOX,BNOS,bN4n
      real(wp)            :: Pdenit

      pdenit = -5.475&
             -0.786*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)&
             +0.662*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)&
             +0.042*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)&
             +0.064*log(CFLUXPERHOUR)*log(BDOX)&
             +0.794*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(BDOX)&
             -0.082*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(BDOX)&
             -0.122*log(CFLUXPERHOUR)*log(CFLUXPERHOUR)*log(BDOX)*log(BDOX)&
             +0.077*log(BDOX)*log(BDOX)&
             -0.155*log(BDOX)*log(BNOS)&
             +0.875*log(BNOS)&
             +0.046*log(BNOS)*log(BNOS)
      pdenit=exp(pdenit)/(CFLUXPERHOUR)

      end subroutine Pdenitfun
#endif

#ifdef metamodel_L2
      subroutine Panoxfun(cmin,nmin,bO2o,bN3n,bN4n,Panox)
      IMPLICIT NONE
      real(wp),intent(IN) :: cmin,nmin,bO2o,bN3n,bN4n
      real(wp)            :: Panox

      real(wp) :: lnC,lnN,lnbO,lnbNO,lnbNH,lnC2,lnbO2
      real(wp) :: lnbNO2,lnbNH2,lnC3,lnbO3,lnC4

      lnC=log(cmin)
      lnbO=log(bO2o)
      lnbNO=log(bN3n)
      lnbNH=log(bN4n)
      lnC2=lnC*lnC
      lnbO2=lnbO*lnbO
      lnbNO2=lnbNO*lnbNO
      lnbNH2=lnbNH*lnbNH
      lnC3=lnC*lnC*lnC
      lnbO3=lnbO*lnbO*lnbO
      lnC4=lnC*lnC*lnC*lnC

      Panox=2.400557D+00                                      &
     & -0.8043453D+00 * lnC                                      &
     & -0.2304263D+00 * lnN                                      &
     & -4.753817D+00 * lnbO                                      &
     & -0.008878167D+00 * lnbNO                                      &
     & -0.5669056D+00 * lnbNH                                      &
     & +0.1398377D+00 * lnC2                                      &
     & +1.374379D+00 * lnbO2                                      &
     & +0.0007990145D+00 * lnbNO2                                      &
     & +0.1982981D+00 * lnbNH2                                      &
     & -0.006483501D+00 * lnC3                                      &
     & -0.1014291D+00 * lnbO3                                      &
     & +2.875004D+00 * lnC*lnbO                                      &
     & +0.1064991D+00 * lnC*lnbNH                                      &
     & -0.9218759D+00 * lnC*lnbO2                                      &
     & -0.004236559D+00 * lnC*lnbNO2                                      &
     & -0.0356309D+00 * lnC*lnbNH2                                      &
     & +0.07453076D+00 * lnC*lnbO3                                      &
     & +0.06410433D+00 * lnN*lnbO                                      &
     & -0.02188682D+00 * lnN*lnbNH                                      &
     & +0.01129599D+00 * lnN*lnC2                                      &
     & -0.01593521D+00 * lnN*lnbO2                                      &
     & +0.007386242D+00 * lnN*lnbNH2                                      &
     & -0.001106949D+00 * lnN*lnC3                                      &
     & +0.001233933D+00 * lnN*lnbO3                                      &
     & +0.1522658D+00 * lnbO*lnbNH                                      &
     & -0.531877D+00 * lnbO*lnC2                                      &
     & -0.05630243D+00 * lnbO*lnbNH2                                      &
     & +0.02989955D+00 * lnbO*lnC3                                      &
     & +0.009934945D+00 * lnbNO*lnbNH                                      &
     & -0.0003257677D+00 * lnbNO*lnbNO2                                      &
     & -0.004031109D+00 * lnbNO*lnbNH2                                      &
     & +0.00003818888D+00 * lnbNO*lnbO3                                      &
     & -0.005964211D+00 * lnbNH*lnC2                                      &
     & -0.03512191D+00 * lnbNH*lnbO2                                      &
     & +0.002514035D+00 * lnbNH*lnbO3                                      &
     & +0.1785983D+00 * lnC2*lnbO2                                      &
     & +0.000353053D+00 * lnC2*lnbNO2                                      &
     & +0.001946622D+00 * lnC2*lnbNH2                                      &
     & -0.01523342D+00 * lnC2*lnbO3                                      &
     & +0.0003752246D+00 * lnbO2*lnbNO2                                      &
     & +0.01335066D+00 * lnbO2*lnbNH2                                      &
     & -0.01037889D+00 * lnbO2*lnC3                                      &
     & -0.00001014966D+00 * lnbO2*lnbO3                                      &
     & -0.00003923253D+00 * lnbNO2*lnbO3                                      &
     & -0.0009836222D+00 * lnbNH2*lnbO3                                      &
     & +0.000919233D+00 * lnC3*lnbO3                                      &
     & +0.0006593485D+00 * lnN*lnbNO2                 
                    
      Panox=max(Panox,0.d0)
      Panox=min(Panox,1.d0)
      end subroutine Panoxfun
      subroutine Pnitfun(cmin,nmin,bO2o,bN3n,bN4n,Pnit)
      IMPLICIT NONE
      real(wp),intent(IN) :: cmin,nmin,bO2o,bN3n,bN4n
      real(wp)            :: Pnit

      real(wp) :: lnC,lnN,lnbO,lnbNO,lnbNH,lnC2,lnbO2
      real(wp) :: lnbNO2,lnbNH2,lnC3,lnbO3,lnC4

      lnC=log(cmin)
      lnN=log(nmin)
      lnbO=log(bO2o)
      lnbNO=log(bN3n)
      lnbNH=log(bN4n)
      lnC2=lnC*lnC
      lnbO2=lnbO*lnbO
      lnbNO2=lnbNO*lnbNO
      lnbNH2=lnbNH*lnbNH
      lnC3=lnC*lnC*lnC
      lnbO3=lnbO*lnbO*lnbO
      lnC4=lnC*lnC*lnC*lnC

      Pnit=-10.33222D+00                                      &
     & +3.345593D+00 * lnC                                      &
     & +0.6247991D+00 * lnN                                      &
     & +14.7211D+00 * lnbO                                      &
     & +0.2339188D+00 * lnbNO                                      &
     & +4.18093D+00 * lnbNH                                      &
     & -0.5104023D+00 * lnC2                                      &
     & -5.01517D+00 * lnbO2                                      &
     & +0.003643839D+00 * lnbNO2                                      &
     & -1.020424D+00 * lnbNH2                                      &
     & +0.01433474D+00 * lnC3                                      &
     & +0.4715221D+00 * lnbO3                                      &
     & -7.540137D+00 * lnC*lnbO                                      &
     & -0.1207112D+00 * lnC*lnbNO                                      &
     & -1.631971D+00 * lnC*lnbNH                                      &
     & +2.893813D+00 * lnC*lnbO2                                      &
     & +0.5361894D+00 * lnC*lnbNH2                                      &
     & -0.2924634D+00 * lnC*lnbO3                                      &
     & -0.1230441D+00 * lnN*lnbO                                      &
     & -0.01698431D+00 * lnN*lnC2                                      &
     & +0.0565059D+00 * lnN*lnbO2                                      &
     & -0.04365361D+00 * lnN*lnbNH2                                      &
     & +0.002593954D+00 * lnN*lnC3                                      &
     & -0.005170156D+00 * lnN*lnbO3                                      &
     & -0.05282515D+00 * lnbO*lnbNH                                      &
     & +1.300047D+00 * lnbO*lnC2                                      &
     & -0.008825258D+00 * lnbO*lnbNO2                                      &
     & -0.06957573D+00 * lnbO*lnC3                                      &
     & +0.0006546449D+00 * lnbO*lnbO3                                      &
     & +0.01980454D+00 * lnbNO*lnC2                                      &
     & -0.001062082D+00 * lnbNO*lnC3                                      &
     & +0.222948D+00 * lnbNH*lnC2                                      &
     & +0.005516081D+00 * lnbNH*lnbO2                                      &
     & -0.004189402D+00 * lnbNH*lnbNO2                                      &
     & +0.01737069D+00 * lnbNH*lnbNH2                                      &
     & -0.01008823D+00 * lnbNH*lnC3                                      &
     & -0.511477D+00 * lnC2*lnbO2                                      &
     & -0.07678764D+00 * lnC2*lnbNH2                                      &
     & +0.05333731D+00 * lnC2*lnbO3                                      &
     & +0.003228422D+00 * lnbO2*lnbNO2                                      &
     & -0.004406457D+00 * lnbO2*lnbNH2                                      &
     & +0.02788174D+00 * lnbO2*lnC3                                      &
     & +0.001641579D+00 * lnbNO2*lnbNH2                                      &
     & -0.0002988112D+00 * lnbNO2*lnbO3                                      &
     & +0.003768596D+00 * lnbNH2*lnC3                                      &
     & +0.0003024528D+00 * lnbNH2*lnbO3                                      &
     & -0.002974215D+00 * lnC3*lnbO3                                      &
     & +0.0003885222D+00 * lnbNO*lnbNO2    

      Pnit=exp(Pnit)/(nmin)
      end subroutine Pnitfun
      subroutine Pdenitfun(cmin,nmin,bO2o,bN3n,bN4n,Pdenit)
      IMPLICIT NONE
      real(wp),intent(IN) :: cmin,nmin,bO2o,bN3n,bN4n
      real(wp)            :: Pdenit

      real(wp) :: lnC,lnN,lnbO,lnbNO,lnbNH,lnC2,lnbO2
      real(wp) :: lnbNO2,lnbNH2,lnC3,lnbO3,lnC4

      lnC=log(cmin)
      lnN=log(nmin)
      lnbO=log(bO2o)
      lnbNO=log(bN3n)
      lnbNH=log(bN4n)
      lnC2=lnC*lnC
      lnbO2=lnbO*lnbO
      lnbNO2=lnbNO*lnbNO
      lnbNH2=lnbNH*lnbNH
      lnC3=lnC*lnC*lnC
      lnbO3=lnbO*lnbO*lnbO
      lnC4=lnC*lnC*lnC*lnC

      Pdenit=-53.44275D+00                                      &
     & +61.37789D+00 * lnC                                      &
     & -0.221119D+00 * lnN                                      &
     & -11.14079D+00 * lnbO                                      &
     & +3.008286D+00 * lnbNO                                      &
     & +9.523186D+00 * lnbNH                                      &
     & -27.82216D+00 * lnC2                                      &
     & +0.02956812D+00 * lnbO2                                      &
     & -1.089762D+00 * lnbNO2                                      &
     & -4.639752D+00 * lnbNH2                                      &
     & +6.036474D+00 * lnC3                                      &
     & +0.3279226D+00 * lnbO3                                      &
     & -0.569511D+00 * lnC4                                      &
     & +11.47106D+00 * lnC*lnbO                                      &
     & -1.351149D+00 * lnC*lnbNO                                      &
     & -6.495136D+00 * lnC*lnbNH                                      &
     & -1.282151D+00 * lnC*lnbO2                                      &
     & +0.7997892D+00 * lnC*lnbNO2                                      &
     & +3.208914D+00 * lnC*lnbNH2                                      &
     & -0.1411538D+00 * lnC*lnbO3                                      &
     & -0.1826358D+00 * lnN*lnbO                                      &
     & -0.1289398D+00 * lnN*lnbNO                                      &
     & +0.05318425D+00 * lnN*lnbNH                                      &
     & +0.09127716D+00 * lnN*lnC2                                      &
     & +0.03411813D+00 * lnN*lnbO2                                      &
     & -0.01677399D+00 * lnN*lnbNH2                                      &
     & -0.01643059D+00 * lnN*lnC3                                      &
     & +0.0008013776D+00 * lnN*lnC4                                      &
     & +0.2376353D+00 * lnbO*lnbNO                                      &
     & -0.1763633D+00 * lnbO*lnbNH                                      &
     & -3.932244D+00 * lnbO*lnC2                                      &
     & -0.0566252D+00 * lnbO*lnbNO2                                      &
     & +0.04878695D+00 * lnbO*lnbNH2                                      &
     & +0.545569D+00 * lnbO*lnC3                                      &
     & +0.001642162D+00 * lnbO*lnbO3                                      &
     & -0.02618147D+00 * lnbO*lnC4                                      &
     & -0.01522551D+00 * lnbNO*lnbNH                                      &
     & +0.3054259D+00 * lnbNO*lnC2                                      &
     & -0.1094626D+00 * lnbNO*lnbO2                                      &
     & +0.004489754D+00 * lnbNO*lnbNO2                                      &
     & -0.02712808D+00 * lnbNO*lnC3                                      &
     & +0.00834673D+00 * lnbNO*lnbO3                                      &
     & +0.0009246466D+00 * lnbNO*lnC4                                      &
     & +1.655171D+00 * lnbNH*lnC2                                      &
     & +0.02906863D+00 * lnbNH*lnbO2                                      &
     & -0.1830134D+00 * lnbNH*lnC3                                      &
     & -0.001371916D+00 * lnbNH*lnbO3                                      &
     & +0.007382716D+00 * lnbNH*lnC4                                      &
     & +0.7152295D+00 * lnC2*lnbO2                                      &
     & -0.2186236D+00 * lnC2*lnbNO2                                      &
     & -0.8117987D+00 * lnC2*lnbNH2                                      &
     & +0.003644781D+00 * lnC2*lnC4                                      &
     & +0.02936952D+00 * lnbO2*lnbNO2                                      &
     & -0.004961562D+00 * lnbO2*lnbNH2                                      &
     & -0.1228087D+00 * lnbO2*lnC3                                      &
     & +0.006624196D+00 * lnbO2*lnC4                                      &
     & +0.02606646D+00 * lnbNO2*lnC3                                      &
     & -0.003136837D+00 * lnbNO2*lnbO3                                      &
     & -0.001133972D+00 * lnbNO2*lnC4                                      &
     & +0.08872D+00 * lnbNH2*lnC3                                      &
     & -0.003541967D+00 * lnbNH2*lnC4                                      &
     & +0.004317963D+00 * lnC3*lnbO3                                      &
     & -0.0001771039D+00 * lnC3*lnC4                                      &
     & -0.0003452209D+00 * lnbO3*lnC4   

      Pdenit=exp(Pdenit)/(cmin)
      end subroutine Pdenitfun
#endif

#ifdef metamodel_L10
      subroutine Panoxfun(cmin,nmin,bO2o,bN3n,bN4n,Panox)
      IMPLICIT NONE
      real(wp),intent(IN) :: cmin,nmin,bO2o,bN3n,bN4n
      real(wp)            :: Panox

      real(wp) :: lnC,lnN,lnbO,lnbNO,lnbNH,lnC2,lnbO2
      real(wp) :: lnbNO2,lnbNH2,lnC3,lnbO3,lnC4

      lnC=log(cmin)
      lnbO=log(bO2o)
      lnbNO=log(bN3n)
      lnbNH=log(bN4n)
      lnC2=lnC*lnC
      lnbO2=lnbO*lnbO
      lnbNO2=lnbNO*lnbNO
      lnbNH2=lnbNH*lnbNH
      lnC3=lnC*lnC*lnC
      lnbO3=lnbO*lnbO*lnbO
      lnC4=lnC*lnC*lnC*lnC

      Panox=19.61319D+00                                      &
     & -8.992891D+00 * lnC                                      &
     & -0.4064292D+00 * lnN                                      &
     & -23.76361D+00 * lnbO                                      &
     & -1.012065D+00 * lnbNO                                      &
     & +0.09801692D+00 * lnbNH                                      &
     & +1.352545D+00 * lnC2                                      &
     & +7.453864D+00 * lnbO2                                      &
     & +0.2743694D+00 * lnbNO2                                      &
     & +0.1252222D+00 * lnbNH2                                      &
     & -0.06396442D+00 * lnC3                                      &
     & -0.6834892D+00 * lnbO3                                      &
     & +12.19126D+00 * lnC*lnbO                                      &
     & +0.4777453D+00 * lnC*lnbNO                                      &
     & -0.03663977D+00 * lnC*lnbNH                                      &
     & -4.003797D+00 * lnC*lnbO2                                      &
     & -0.1341915D+00 * lnC*lnbNO2                                      &
     & -0.06482764D+00 * lnC*lnbNH2                                      &
     & +0.3867391D+00 * lnC*lnbO3                                      &
     & +0.008481588D+00 * lnN*lnbNO                                      &
     & +0.03364019D+00 * lnN*lnbNH                                      &
     & +0.02681754D+00 * lnN*lnC2                                      &
     & +0.0004019482D+00 * lnN*lnbO2                                      &
     & -0.002114938D+00 * lnN*lnbNO2                                      &
     & -0.01307342D+00 * lnN*lnbNH2                                      &
     & -0.002646656D+00 * lnN*lnC3                                      &
     & +0.04223044D+00 * lnbO*lnbNO                                      &
     & -1.949723D+00 * lnbO*lnC2                                      &
     & +0.09926081D+00 * lnbO*lnC3                                      &
     & -0.002895455D+00 * lnbO*lnbO3                                      &
     & -0.07762478D+00 * lnbNO*lnC2                                      &
     & -0.01270609D+00 * lnbNO*lnbO2                                      &
     & -0.0007052964D+00 * lnbNO*lnbNO2                                      &
     & +0.004043729D+00 * lnbNO*lnC3                                      &
     & +0.001161563D+00 * lnbNO*lnbO3                                      &
     & +0.6577974D+00 * lnC2*lnbO2                                      &
     & +0.02062849D+00 * lnC2*lnbNO2                                      &
     & +0.01221087D+00 * lnC2*lnbNH2                                      &
     & -0.06515479D+00 * lnC2*lnbO3                                      &
     & +0.0008460741D+00 * lnbO2*lnbNO2                                      &
     & -0.03419092D+00 * lnbO2*lnC3                                      &
     & +0.0001023019D+00 * lnbO2*lnbO3                                      &
     & -0.001019181D+00 * lnbNO2*lnC3                                      &
     & -0.00009035078D+00 * lnbNO2*lnbO3                                      &
     & -0.0006101587D+00 * lnbNH2*lnC3                                      &
     & +0.003461699D+00 * lnC3*lnbO3                               
            
      Panox=max(Panox,0.d0)
      Panox=min(Panox,1.d0)
      end subroutine Panoxfun
      subroutine Pnitfun(cmin,nmin,bO2o,bN3n,bN4n,Pnit)
      IMPLICIT NONE
      real(wp),intent(IN) :: cmin,nmin,bO2o,bN3n,bN4n
      real(wp)            :: Pnit

      real(wp) :: lnC,lnN,lnbO,lnbNO,lnbNH,lnC2,lnbO2
      real(wp) :: lnbNO2,lnbNH2,lnC3,lnbO3,lnC4

      lnC=log(cmin)
      lnN=log(nmin)
      lnbO=log(bO2o)
      lnbNO=log(bN3n)
      lnbNH=log(bN4n)
      lnC2=lnC*lnC
      lnbO2=lnbO*lnbO
      lnbNO2=lnbNO*lnbNO
      lnbNH2=lnbNH*lnbNH
      lnC3=lnC*lnC*lnC
      lnbO3=lnbO*lnbO*lnbO
      lnC4=lnC*lnC*lnC*lnC

      Pnit=-7.798918D+00                                      &
     & -1.051477D+00 * lnC                                      &
     & +0.06813078D+00 * lnN                                      &
     & +11.1981D+00 * lnbO                                      &
     & -0.7611672D+00 * lnbNO                                      &
     & +3.895326D+00 * lnbNH                                      &
     & +0.6616457D+00 * lnC2                                      &
     & -5.075171D+00 * lnbO2                                      &
     & -0.06990543D+00 * lnbNO2                                      &
     & -1.610656D+00 * lnbNH2                                      &
     & -0.06707688D+00 * lnC3                                      &
     & +0.5648598D+00 * lnbO3                                      &
     & +0.4709661D+00 * lnC*lnbNO                                      &
     & -1.730944D+00 * lnC*lnbNH                                      &
     & +1.253237D+00 * lnC*lnbO2                                      &
     & +0.9735099D+00 * lnC*lnbNH2                                      &
     & -0.2466544D+00 * lnC*lnbO3                                      &
     & +0.1108147D+00 * lnN*lnbO                                      &
     & -0.008449214D+00 * lnN*lnbNO                                      &
     & -0.1199252D+00 * lnN*lnbNH                                      &
     & +0.009805731D+00 * lnN*lnC2                                      &
     & -0.001899799D+00 * lnN*lnbO3                                      &
     & -0.3066145D+00 * lnbO*lnbNO                                      &
     & -0.8012346D+00 * lnbO*lnC2                                      &
     & +0.05936627D+00 * lnbO*lnbNO2                                      &
     & -0.01495289D+00 * lnbO*lnbNH2                                      &
     & +0.08090238D+00 * lnbO*lnC3                                      &
     & +0.02224776D+00 * lnbO*lnbO3                                      &
     & +0.0625425D+00 * lnbNO*lnbNH                                      &
     & -0.06569368D+00 * lnbNO*lnC2                                      &
     & +0.07349925D+00 * lnbNO*lnbO2                                      &
     & +0.0008515013D+00 * lnbNO*lnbNO2                                      &
     & -0.021941D+00 * lnbNO*lnbNH2                                      &
     & +0.00307261D+00 * lnbNO*lnC3                                      &
     & -0.005447011D+00 * lnbNO*lnbO3                                      &
     & +0.2739172D+00 * lnbNH*lnC2                                      &
     & -0.01559704D+00 * lnbNH*lnbNO2                                      &
     & -0.01350844D+00 * lnbNH*lnC3                                      &
     & +0.03925886D+00 * lnC2*lnbO2                                      &
     & -0.1643534D+00 * lnC2*lnbNH2                                      &
     & +0.0208709D+00 * lnC2*lnbO3                                      &
     & -0.01255904D+00 * lnbO2*lnbNO2                                      &
     & -0.01477765D+00 * lnbO2*lnC3                                      &
     & -0.001395507D+00 * lnbO2*lnbO3                                      &
     & +0.005703824D+00 * lnbNO2*lnbNH2                                      &
     & +0.0008072359D+00 * lnbNO2*lnbO3                                      &
     & +0.008724314D+00 * lnbNH2*lnC3   
     
      Pnit=exp(Pnit)/(nmin)
      end subroutine Pnitfun
      subroutine Pdenitfun(cmin,nmin,bO2o,bN3n,bN4n,Pdenit)
      IMPLICIT NONE
      real(wp),intent(IN) :: cmin,nmin,bO2o,bN3n,bN4n
      real(wp)            :: Pdenit

      real(wp) :: lnC,lnN,lnbO,lnbNO,lnbNH,lnC2,lnbO2
      real(wp) :: lnbNO2,lnbNH2,lnC3,lnbO3,lnC4

      lnC=log(cmin)
      lnN=log(nmin)
      lnbO=log(bO2o)
      lnbNO=log(bN3n)
      lnbNH=log(bN4n)
      lnC2=lnC*lnC
      lnbO2=lnbO*lnbO
      lnbNO2=lnbNO*lnbNO
      lnbNH2=lnbNH*lnbNH
      lnC3=lnC*lnC*lnC
      lnbO3=lnbO*lnbO*lnbO
      lnC4=lnC*lnC*lnC*lnC

      Pdenit=73.5124D+00                                      &
     & -0.9586651D+00 * lnC                                      &
     & -0.1308616D+00 * lnN                                      &
     & -173.699D+00 * lnbO                                      &
     & -11.91855D+00 * lnbNO                                      &
     & -0.09416997D+00 * lnbNH                                      &
     & -36.02221D+00 * lnC2                                      &
     & +57.88135D+00 * lnbO2                                      &
     & +2.747746D+00 * lnbNO2                                      &
     & +2.171803D+00 * lnbNH2                                      &
     & +18.34701D+00 * lnC3                                      &
     & -5.629093D+00 * lnbO3                                      &
     & -4.215035D+00 * lnC4                                      &
     & +125.7891D+00 * lnC*lnbO                                      &
     & +8.139937D+00 * lnC*lnbNO                                      &
     & -43.22192D+00 * lnC*lnbO2                                      &
     & -1.672685D+00 * lnC*lnbNO2                                      &
     & -1.591298D+00 * lnC*lnbNH2                                      &
     & +4.24202D+00 * lnC*lnbO3                                      &
     & +0.5246851D+00 * lnC*lnC4                                      &
     & -0.1161025D+00 * lnN*lnbNO                                      &
     & +0.02264713D+00 * lnN*lnC2                                      &
     & -0.01840637D+00 * lnN*lnbO2                                      &
     & +0.004350559D+00 * lnN*lnbO3                                      &
     & -0.0002397542D+00 * lnN*lnC4                                      &
     & -0.1399885D+00 * lnbO*lnbNO                                      &
     & -32.42279D+00 * lnbO*lnC2                                      &
     & +0.02121901D+00 * lnbO*lnbNO2                                      &
     & +0.01171698D+00 * lnbO*lnbNH2                                      &
     & +3.551263D+00 * lnbO*lnC3                                      &
     & +0.01652495D+00 * lnbO*lnbO3                                      &
     & -0.1404394D+00 * lnbO*lnC4                                      &
     & +0.1747381D+00 * lnbNO*lnbNH                                      &
     & -1.854709D+00 * lnbNO*lnC2                                      &
     & +0.0033624D+00 * lnbNO*lnbNO2                                      &
     & -0.07748791D+00 * lnbNO*lnbNH2                                      &
     & +0.1857915D+00 * lnbNO*lnC3                                      &
     & -0.00136142D+00 * lnbNO*lnbO3                                      &
     & -0.006777996D+00 * lnbNO*lnC4                                      &
     & -0.03778371D+00 * lnbNH*lnbNO2                                      &
     & +0.0264966D+00 * lnbNH*lnbNH2                                      &
     & +11.46458D+00 * lnC2*lnbO2                                      &
     & +0.3657349D+00 * lnC2*lnbNO2                                      &
     & +0.4190935D+00 * lnC2*lnbNH2                                      &
     & -1.149764D+00 * lnC2*lnbO3                                      &
     & -0.03474202D+00 * lnC2*lnC4                                      &
     & +0.007265042D+00 * lnbO2*lnbNO2                                      &
     & -1.286503D+00 * lnbO2*lnC3                                      &
     & -0.001015517D+00 * lnbO2*lnbO3                                      &
     & +0.05196553D+00 * lnbO2*lnC4                                      &
     & +0.01527531D+00 * lnbNO2*lnbNH2                                      &
     & -0.03493034D+00 * lnbNO2*lnC3                                      &
     & -0.001311158D+00 * lnbNO2*lnbO3                                      &
     & +0.001240546D+00 * lnbNO2*lnC4                                      &
     & -0.0474535D+00 * lnbNH2*lnC3                                      &
     & +0.001950547D+00 * lnbNH2*lnC4                                      &
     & +0.1315699D+00 * lnC3*lnbO3                                      &
     & +0.000965551D+00 * lnC3*lnC4                                      &
     & -0.005410488D+00 * lnbO3*lnC4                                      &
     & -0.00009413385D+00 * lnbNH2*lnbO3  
                                     
      Pdenit=exp(Pdenit)/(cmin)
      end subroutine Pdenitfun
#endif

end module

