      subroutine Panoxfun(cmin,nmin,bO2o,bN3n,bN4n,Panox)
      IMPLICIT NONE
      DOUBLE PRECISION,intent(IN) :: cmin,nmin,bO2o,bN3n,bN4n
      DOUBLE PRECISION            :: Panox

      DOUBLE PRECISION :: lnC,lnN,lnbO,lnbNO,lnbNH,lnC2,lnbO2
      DOUBLE PRECISION :: lnbNO2,lnbNH2,lnC3,lnbO3,lnC4

      lnC=log(cmin)
      lnbO=log(bO2o)
      lnbNO=log(bN3n)
      lnbNH=log(bN4n)
      lnC2=lnC*lnC
      lnbO2=lnbO*lnbO
      lnbNO2=lnbNO*lnbNO
      lnbNH2=lnbNH*lnbNH
      lnC3=lnC*lnC*lnC
      lnbO3=lnbO*lnbO*lnbO
      lnC4=lnC*lnC*lnC*lnC

      Panox=2.400557D+00                                      &
     & -0.8043453D+00 * lnC                                      &
     & -0.2304263D+00 * lnN                                      &
     & -4.753817D+00 * lnbO                                      &
     & -0.008878167D+00 * lnbNO                                      &
     & -0.5669056D+00 * lnbNH                                      &
     & +0.1398377D+00 * lnC2                                      &
     & +1.374379D+00 * lnbO2                                      &
     & +0.0007990145D+00 * lnbNO2                                      &
     & +0.1982981D+00 * lnbNH2                                      &
     & -0.006483501D+00 * lnC3                                      &
     & -0.1014291D+00 * lnbO3                                      &
     & +2.875004D+00 * lnC*lnbO                                      &
     & +0.1064991D+00 * lnC*lnbNH                                      &
     & -0.9218759D+00 * lnC*lnbO2                                      &
     & -0.004236559D+00 * lnC*lnbNO2                                      &
     & -0.0356309D+00 * lnC*lnbNH2                                      &
     & +0.07453076D+00 * lnC*lnbO3                                      &
     & +0.06410433D+00 * lnN*lnbO                                      &
     & -0.02188682D+00 * lnN*lnbNH                                      &
     & +0.01129599D+00 * lnN*lnC2                                      &
     & -0.01593521D+00 * lnN*lnbO2                                      &
     & +0.007386242D+00 * lnN*lnbNH2                                      &
     & -0.001106949D+00 * lnN*lnC3                                      &
     & +0.001233933D+00 * lnN*lnbO3                                      &
     & +0.1522658D+00 * lnbO*lnbNH                                      &
     & -0.531877D+00 * lnbO*lnC2                                      &
     & -0.05630243D+00 * lnbO*lnbNH2                                      &
     & +0.02989955D+00 * lnbO*lnC3                                      &
     & +0.009934945D+00 * lnbNO*lnbNH                                      &
     & -0.0003257677D+00 * lnbNO*lnbNO2                                      &
     & -0.004031109D+00 * lnbNO*lnbNH2                                      &
     & +0.00003818888D+00 * lnbNO*lnbO3                                      &
     & -0.005964211D+00 * lnbNH*lnC2                                      &
     & -0.03512191D+00 * lnbNH*lnbO2                                      &
     & +0.002514035D+00 * lnbNH*lnbO3                                      &
     & +0.1785983D+00 * lnC2*lnbO2                                      &
     & +0.000353053D+00 * lnC2*lnbNO2                                      &
     & +0.001946622D+00 * lnC2*lnbNH2                                      &
     & -0.01523342D+00 * lnC2*lnbO3                                      &
     & +0.0003752246D+00 * lnbO2*lnbNO2                                      &
     & +0.01335066D+00 * lnbO2*lnbNH2                                      &
     & -0.01037889D+00 * lnbO2*lnC3                                      &
     & -0.00001014966D+00 * lnbO2*lnbO3                                      &
     & -0.00003923253D+00 * lnbNO2*lnbO3                                      &
     & -0.0009836222D+00 * lnbNH2*lnbO3                                      &
     & +0.000919233D+00 * lnC3*lnbO3                                      &
     & +0.0006593485D+00 * lnN*lnbNO2                 
                    
      Panox=max(Panox,0.d0)
      Panox=min(Panox,1.d0)
      end subroutine Panoxfun
