      subroutine Panoxfun(cmin,nmin,bO2o,bN3n,bN4n,Panox)
      IMPLICIT NONE
      DOUBLE PRECISION,intent(IN) :: cmin,nmin,bO2o,bN3n,bN4n
      DOUBLE PRECISION            :: Panox

      DOUBLE PRECISION :: lnC,lnN,lnbO,lnbNO,lnbNH,lnC2,lnbO2
      DOUBLE PRECISION :: lnbNO2,lnbNH2,lnC3,lnbO3,lnC4

      lnC=log(cmin)
      lnbO=log(bO2o)
      lnbNO=log(bN3n)
      lnbNH=log(bN4n)
      lnC2=lnC*lnC
      lnbO2=lnbO*lnbO
      lnbNO2=lnbNO*lnbNO
      lnbNH2=lnbNH*lnbNH
      lnC3=lnC*lnC*lnC
      lnbO3=lnbO*lnbO*lnbO
      lnC4=lnC*lnC*lnC*lnC

      Panox=19.61319D+00                                      &
     & -8.992891D+00 * lnC                                      &
     & -0.4064292D+00 * lnN                                      &
     & -23.76361D+00 * lnbO                                      &
     & -1.012065D+00 * lnbNO                                      &
     & +0.09801692D+00 * lnbNH                                      &
     & +1.352545D+00 * lnC2                                      &
     & +7.453864D+00 * lnbO2                                      &
     & +0.2743694D+00 * lnbNO2                                      &
     & +0.1252222D+00 * lnbNH2                                      &
     & -0.06396442D+00 * lnC3                                      &
     & -0.6834892D+00 * lnbO3                                      &
     & +12.19126D+00 * lnC*lnbO                                      &
     & +0.4777453D+00 * lnC*lnbNO                                      &
     & -0.03663977D+00 * lnC*lnbNH                                      &
     & -4.003797D+00 * lnC*lnbO2                                      &
     & -0.1341915D+00 * lnC*lnbNO2                                      &
     & -0.06482764D+00 * lnC*lnbNH2                                      &
     & +0.3867391D+00 * lnC*lnbO3                                      &
     & +0.008481588D+00 * lnN*lnbNO                                      &
     & +0.03364019D+00 * lnN*lnbNH                                      &
     & +0.02681754D+00 * lnN*lnC2                                      &
     & +0.0004019482D+00 * lnN*lnbO2                                      &
     & -0.002114938D+00 * lnN*lnbNO2                                      &
     & -0.01307342D+00 * lnN*lnbNH2                                      &
     & -0.002646656D+00 * lnN*lnC3                                      &
     & +0.04223044D+00 * lnbO*lnbNO                                      &
     & -1.949723D+00 * lnbO*lnC2                                      &
     & +0.09926081D+00 * lnbO*lnC3                                      &
     & -0.002895455D+00 * lnbO*lnbO3                                      &
     & -0.07762478D+00 * lnbNO*lnC2                                      &
     & -0.01270609D+00 * lnbNO*lnbO2                                      &
     & -0.0007052964D+00 * lnbNO*lnbNO2                                      &
     & +0.004043729D+00 * lnbNO*lnC3                                      &
     & +0.001161563D+00 * lnbNO*lnbO3                                      &
     & +0.6577974D+00 * lnC2*lnbO2                                      &
     & +0.02062849D+00 * lnC2*lnbNO2                                      &
     & +0.01221087D+00 * lnC2*lnbNH2                                      &
     & -0.06515479D+00 * lnC2*lnbO3                                      &
     & +0.0008460741D+00 * lnbO2*lnbNO2                                      &
     & -0.03419092D+00 * lnbO2*lnC3                                      &
     & +0.0001023019D+00 * lnbO2*lnbO3                                      &
     & -0.001019181D+00 * lnbNO2*lnC3                                      &
     & -0.00009035078D+00 * lnbNO2*lnbO3                                      &
     & -0.0006101587D+00 * lnbNH2*lnC3                                      &
     & +0.003461699D+00 * lnC3*lnbO3                               
            
      Panox=max(Panox,0.d0)
      Panox=min(Panox,1.d0)
      end subroutine Panoxfun
