#!/bin/bash
# this script combines the metamodels into a module usable by Bamhbi benthic model

# options

output="../benthic_metamodels.F90"
versions="ORIG L2 L10"
version_to_use=ORIG

# don't modify below this line

echo "#define metamodel_${version_to_use}" > $output
echo "module benthic_metamodels" >> $output
echo "use par_kind" >> $output
echo "contains" >> $output
echo "" >> $output
for v in $versions
do
  echo "#ifdef metamodel_$v" >> $output
  cat panox_${v}.f  | sed "s/DOUBLE PRECISION/real(wp)/" >> $output
  cat pnit_${v}.f   | sed "s/DOUBLE PRECISION/real(wp)/" >> $output
  cat pdenit_${v}.f | sed "s/DOUBLE PRECISION/real(wp)/" >> $output
  echo "#endif" >> $output
  echo "" >> $output
done
echo "end module" >> $output
echo "" >> $output

