module bamhbi_params
#include "bamhbi.h90"
#ifdef forcingmodel_nemo
  !we don't need bamhbi_driver_nemo here, just wp
  use par_kind, only : wp
#endif

  ! parameters used by the BAMHBI biogeochemical model
  ! conversion day->second is NOT always written in commented units

! =============================
! bamhbi state variable indexes
! =============================
         integer :: CFL,NFL,CEM,NEM,CDI,NDI,MIC,MES,BAC,DCL,DNL,DCS,DNS
         integer :: NOS,NHS,SIO,DOX,DIC,ODU,POC,PON,SID,PHO
         integer :: AGG, GEL,NOC, CHD,CHE,CHF  ! optional state vars
         ! CHA is declared in bamhbi_alkalinity_vars
         real(wp), allocatable, save ::   Chlorophyll(:,:,:,:)
         real(wp), allocatable, save ::   rtPAR(:,:,:)
         
!==========
! physics
!==========
         real(wp) :: daytosecond
         real(wp) :: pi
         real(wp) :: WattToPhotons
         
!===============!
! Aggregation parameters taken from Kriest, 2002, DSR
!===============!

         real(wp) :: shear                               ! /day        shear rate Kriest 2002, DSR
         real(wp) :: etabio                              !       -           sinking exponent Kriest 2002, DSR
         real(wp) :: B                                   ! /m^(etabio-1)/day  sinking factor  Kriest 2002, case 9 table 2, agaisnt 206087 for single cell,DSR 
         real(wp) :: stick                               !       -           stickness  Kriest 2002, DSR
         real(wp) :: m                                   !     m           cell size  Kriest 2002, DSR
         real(wp) :: dzetabio                            !     -              N content exponent  Kriest 2002, table 1, ref 2a, aigains 2.28 for case 5DSR
         real(wp) :: C                                   !       mmolN/m^dzetabio   N content coefficient Kriest 2002 ,table 1, ref 2a, aigains 206.95 for case 5, DSR
         real(wp) :: Maxsize                             !   m    Maximum cell size. Fitted Kriest 2002, DSR proposed a value of 1.5/100 m
         real(wp) :: epsini                              !  -epsilon initial value Kriest 2002, DSR
         real(wp) :: dAGG_limit                          ! L.V. limits AGG trend for stability reasons, should dissaear if sinking is stabilized

!===============!
! Chemical model!
!===============!

! Bacterial respiration
         real(wp) :: OCr                                 ! moldox/molC  Oxygen to carbon ratio of respiration process
         real(wp) :: NCr                                 ! molN/molC    Nitrogen to carbon ratio of denitRification
         real(wp) :: ksremindox                          ! mmoldox/m3     Half saturation constant for oxygen limitation in oxic mineralization,Soetaert et al., 1996
         real(wp) :: ksdeninos                           ! mmolnos/m3     Half saturation constant for nitrate limination in denitrification, Soetaert et al., 1996
         real(wp) :: kindenidox                          ! mmoldox/m3     Half saturation constant for oxygen inhibition in denitrification, Soetaert et al., 1996
         real(wp) :: kinanoxremdox                       ! mmoldox/m3     Half saturation constant for oxygen inhibition in anoxic remineralization, fitted
         real(wp) :: kinanoxremnos                       ! mmolnos/m3     Half saturation constant for nitrate inhibition in anoxic remineralization, fitted
         real(wp) :: ODUCr                               !   molODU/molC    mol ODU formed per mol C in anoxic mineralization
         real(wp) :: ODU_solid                           !   - Pourcentage of formation of solid ODU

! Ammonium oxidation
         real(wp) :: Roxnhs                              ! d-1  maximum rate of ammonium oxidation by oxygen, Soeteart et al, 
         real(wp) :: ksoxnhsdox                          ! mmoldox/m3  Half saturation constant for oxygen limitation in ammonium oxidation, Soetaert et al., 1996
         real(wp) :: kinoxnhsdox                         ! mmoldox/m3  Half saturation constant for oxygen inhibition in ammonium oxidation by nitrate fitted
         real(wp) :: kinoxnhsodu                         ! inhibition of amanox by ODU .. amanox dont need nitrate !! 
         real(wp) :: ksoxnhsnos                          ! bug fix 2019-01-07

         real(wp) :: ONoxnhsr                            ! moldox/molnhs   mol of dox needed to oxidize one mol of NHs 
         real(wp) :: NOsNHsr                             !      molnos/molnhs mol of nos needed to oxidize one mol of nhs

         real(wp) :: Roxnhsnos                           ! d-1  maximum rate of ammonium oxidation by nitrate

! Reduced Substances oxidation
         real(wp) :: Roxodu                              ! d-1 maximum oxidation rate of Oxygen demands units, Oguz et al. 2000 (obtained for H2S and Mn oxidation)
         real(wp) :: ksoxodudox                          ! mmoldox/m3  Half saturation constant for oxygen limitation in ODU oxidation Soetaert et al., 1996
         real(wp) :: ksoxodunos                          ! mmolNOs/m3  Half saturation constant for nitrate limitation in ODU oxidation fitted
         real(wp) :: kinoxodudox                         ! mmoldox/m3 Half saturation constant for oxygen inhibition in ODU oxidation by nitrate fitted
         real(wp) :: OODUr                               ! moldox/molODU mol of dox needed to oxidize one mol of ODU
         real(wp) :: NODUr                               ! molnos/molodu mol of nitrate needed to oxidize one mol of ODU
         real(wp) :: Roxodunos                           ! d-1 maximum oxidation rate of Oxygen demands units by nitrate Oguz et al. 2000 (obtained for Mn oxidation)

!Definition of the suboxic layer
         real(wp) :: Q10chem=2.                          ! - Q10 factor for chemical processes

!Phosphate precipitation
         real(wp) :: Fe3Mn3_density
         real(wp) :: Pho_precip_fac
         
!===============!
! BACTERIA !
!===============!
         real(wp) :: NCrBac                              !  mmolN/mmolC   Goldman ratio for Bacteria Anderson and Pondhaven, 2003
         real(wp) :: maxhydrDOCSL                        ! /day  max.semi-labile DOC hydrolysis Anderson and Pondhaven, 2003
         real(wp) :: csatdocsl                           ! mmolC/m3  half-saturation for semi-labile DOC uptake Anderson and Pondhaven, 2003 instaed of 417
         real(wp) :: maxgrowthbac                        !  /day  max.labile DOC or ammonium uptake Anderson and Pondhaven, 2003
         real(wp) :: csatdocl                            ! mmolC/m3  half saturation for labile DOC uptake Anderson and Pondhaven, 2003
         real(wp) :: csatamm                             ! mmolN/m3 half saturation for ammonium uptake Anderson and Pondhaven, 2003
         real(wp) :: mortbac                             ! /day bacteria natural mortality Anderson and Pondhaven, 2003
         real(wp) :: bactgrowtheff                       ! - bacterial gross growth efficiency on carbon  Anderson and Pondhaven, 2003
         real(wp) :: Q10bac                              ! - Q10 factor for bacteria  
         real(wp) :: Halfsaturation_Iron                 !  nmole/l half sauration constant for iron limitation function
         real(wp) :: IronCsurf                           ! nmole/l  Concentration of iron in surface waters
         real(wp) :: Param1IronCurve                     !  - Parameter of the curve simulating the iron concentration
         real(wp) :: Param2IronCurve                     !  -  Parameter of the curve simulating the iron c

!===============!
! POM
!===============!
         real(wp) :: hydPOCmax                           !  /day detrital breakdown rate, C  Anderson and Pondhaven, 2003 0.04
         real(wp) :: hydPONmax                           !  /day detrital breakdown rate, N  Anderson and Pondhaven, 2003 0.055
         real(wp) :: SinkingRatePOM_Constant             !   m/day sinking rate of POM in case of not using the aggregation model
        !real(wp) :: BurialOfCarbon                      ! - % of the sediment carbon flux which is burried (not used)
        !real(wp) :: BurialOfNitrogen                    ! - % of the sediment nitrogen flux which is burried  (not used)
         real(wp) :: ksatOxygenHydrolysis                !  mmolO2/m3 HAlf saturation constant for the oxygen limitation function of te hydrolysis rate instead of 0.02,0.1

!===============!
! DON
!===============!
         real(wp) :: labilefraction                      !   - labile fraction phyto and non-phyto produced DOM  Anderson and Pondhaven, 2003
         real(wp) :: labileextradocphyexcr               !   - labile fraction phyto-excreted DOC,  Anderson and Pondhaven, 2003

!===============!
! PHYTOPLANKTON !
!===============!
   real(wp) :: QuantumYieldDiatoms                  ! mmolC(mgChldW/m2)-1 Maximum quantun yield of diatoms Soetaert et al., 2001
   real(wp) :: QuantumYieldFlagellates              ! mmolC(mgChldW/m2)-1 Maximum quantun yield of Flagellates Soetaert et al., 2001
   real(wp) :: QuantumYieldEmiliana                 ! mmolC(mgChldW/m2)-1 Maximum quantun yield of Emiliana Soetaert et al., 2001

   real(wp) :: alphaPIFlagellates                   !  molC/gchla (W/m2)-1/day   instead of 0.045
   real(wp) :: alphaPIEmiliana                      !  molC/gchla  (W/m2)-1/day    instead of 0.05
   real(wp) :: alphaPIDiatoms                       !   molC/gchla (W/m2)-1/day instead of 0.09
  
   real(wp) :: MinNCrFlagellates                    !  molN/molC  Soetaert et al., 2001
   real(wp) :: MinNCrEmiliana                       ! molN/molC   Soetaert et al., 2001
   real(wp) :: MinNCrDiatoms                        ! molN/molC   Soetaert et al., 2001
 
   real(wp) :: MaxNCrFlagellates                    !  molN/molC   Soetaert et al., 2001
   real(wp) :: MaxNCrEmiliana                       ! molN/molC   Soetaert et al., 2001
   real(wp) :: MaxNCrDiatoms                        ! molN/molC   Soetaert et al., 2001
 
   real(wp) :: MuMaxFlagellates !  instead of 1.50   /day    aga
   real(wp) :: MuMaxEmiliana    !/day  insted of 3 at 20 Egge and Heimdal, 1994,Sarsia, against 3 at 20 for Asknes et al 1994, 0.8 -1.9 /day Tyreell and Taylor, 1996, =mudia/1.5, Brand and Guillard, 1981
   real(wp) :: MuMaxDiatoms     !  /day  4.5 instead of 3.5 mean values computed from Furnas, 1990 JPR, against 4.6 at 20 for Asknes et al 1994, 

   real(wp) :: RespirationFlagellates               ! /day  Lancelot et al 2002, coefficient of basal respiration
   real(wp) :: RespirationEmiliana                  ! /day  Lancelot et al 2002, coefficient of basal respiration
   real(wp) :: RespirationDiatoms                   ! /day  Lancelot et al 2002, coefficient of basal respiration

   real(wp) :: MortalityFlagellates                 ! /day  0.0115 for Asknes et al. 1994
   real(wp) :: MortalityEmiliana                    ! /day   0.0115 for Asknes et al. 1994
   real(wp) :: MortalityDiatoms                     !  /day  0.0115 for Asknes et al. 1994

   real(wp) :: MinGrowthRespFlagellates             ! -  respirated fraction (linked to activity) Soetaert et al., 2001
   real(wp) :: MaxGrowthRespFlagellates             ! - max repisrated fraction
   real(wp) :: GrowthRespEmiliana                   ! -             respirated fraction (linked to activity)  Soetaert et al., 2001
   real(wp) :: GrowthRespDiatoms                    ! -             respirated fraction (linked to activity)  Soetaert et al., 2001
   real(wp) :: GrowthRespFlagellates     
   real(wp) :: Q10Phy                               ! - temperature factor  Soetaert et al., 2001
   real(wp) :: Q10PhyDiatoms                        ! - temperature function for diatoms instead of 1.5
   real(wp) :: Q10PhyFlagellates                    ! - temperature function for diatoms instead of 1.5        
   real(wp) :: Q10PhyEmilianna                      ! - temperature function for diatoms instead of 1.5
   real(wp) :: MinChlNrFlagellates                  ! mgChla/mmolN   Soetaert et al., 2001
   real(wp) :: MinChlNrEmiliana                     ! mgChla/mmolN   Soetaert et al., 2001
   real(wp) :: MinChlNrDiatoms                      ! mgChla/mmolN   Soetaert et al., 2001
   real(wp) :: MaxChlNrFlagellates                  ! mgChla/mmolN   Soetaert et al., 2001
   real(wp) :: MaxChlNrEmiliana                     ! mgChla/mmolN   Soetaert et al., 2001
   real(wp) :: MaxChlNrDiatoms                      ! mgChla/mmolN   Soetaert et al., 2001
   real(wp) :: MaxSiCrDiatoms,MinSiCrDiatoms
#ifdef chlorophyll_geider
   real(wp) :: MinChlCrPHY, MaxChlCrPHY
   real(wp) :: MinChlNrPHY, MaxChlNrPHY
   real(wp) :: RangeChlNrPHY
#endif
   
   real(wp) :: NosMaxUptakeFlagellates              ! molN/molC/d   1  maximal nitrate uptake rate 
   real(wp) :: NosMaxUptakeEmiliana                 ! molN/molC/d     maximal nitrate uptake rate, 
   real(wp) :: NosMaxUptakeDiatoms                  ! molN/molC/d     maximal nitrate uptake rate  
   real(wp) :: NHsMaxUptakeFlagellates              !  molN/molC/d   1  maximal ammonium uptake rate, 
   real(wp) :: NHsMaxUptakeEmiliana                 ! molN/molC/d    maximal ammonium uptake rate, 
   real(wp) :: NHsMaxUptakeDiatoms                  ! molN/molC/d     maximal ammonium uptake rate
#ifdef chlorophyll_geider
   real(wp) :: NHSNoUptakeFlagellates
   real(wp) :: NHSNoUptakeEmiliana
   real(wp) :: NHSNoUptakeDiatoms
   real(wp) :: PO4NoUptakeFlagellates
   real(wp) :: PO4NoUptakeEmiliana
   real(wp) :: PO4NoUptakeDiatoms
#endif
   real(wp) :: ksNOsFlagellates                     ! mmolN/m3     3    half saturation constant for nitrate uptake data base
   real(wp) :: ksNOsEmiliana                        ! mmolN/m3        half saturation constant for nitrate uptake data base
   real(wp) :: ksNOsDiatoms                         ! mmolN/m3        half saturation constant for nitrate uptake data base 1.4 (instead of 1)
   real(wp) :: ksNHS                                ! common ksNHS for all 3 phyto groups, used in case of stochastic perturbation
   real(wp) :: ksNHsFlagellates                     ! mmolN/m3   3     half saturation constant data base
   real(wp) :: ksNHsEmiliana                        ! mmolN/m3        half saturation constant data base
   real(wp) :: ksNHsDiatoms                         ! mmolN/m3        half saturation constant data base 2.4 (instead of 1)
   real(wp) :: kinNHsPhy                            ! mmolNH3-N/m3   Half-satur.ct of NH3 inhibition NO3uptake phytop Soetaert et al., 2001
   real(wp) :: leakagephy                           ! -    Phytoplankton leakage parameter  VDM et al, 2004 L&O instaed of 0.05 as in Anderson and Pondhaven, 2003
   real(wp) :: extradocphyexcr                      ! - Extra photosynthetic carbon excretion VDM et al, 2004 L&O instaed of 0.2v6 as in Anderson and Pondhaven, 2003 instead of 0.26
   real(wp) :: mortphydom                           ! - DOM fraction of phytoplankton mortality  instead of 0.34 Anderson and Pondhaven, 2003

   real(wp) :: SinkingRateDiatomsmax                !  m/sec    Maximum Sedimentation rate of diatoms  Tyrell and Taylor, 1996, JMS against 0.3 m/day for Asknes et al 1994
   real(wp) :: SinkingRateDiatomsmin                ! 
        
!===============!
! SILICATE !
!===============!
   real(wp) :: SiMaxUptakeDiatoms                   ! molSi/molC/d    
   real(wp) :: ksSiDiatoms                          ! mmolN/m3       0.5 half saturation constant for silicate uptake, database, between 0.1 -1 Paasche, 1980, 0.73 -1.15 data base
   real(wp) :: SiNrDiatoms                          ! molN/molSi     Silicate to Nitrogen ratio, database, 0.875 for Aksnes et al. 1994, data base :0.94 -1.48
   real(wp) :: kdis_Silicious_Detritus              ! /day rate of dissolution of silicious  detritus Tusseau, 1996
   real(wp) :: vsinkingrate_Silicious_Detritus      !  sinking rate of Silicious_Detritus
   real(wp) :: Q10SilicateDiss                      ! - Q10 factor for chemical processes

!===============!
! ZOOPLANKTON   !
!===============!
   real(wp) :: MaxgrazingrateMicroZoo         ! day-1 maximum grazing rate, Strom and Morello, 1998, JPR 
   real(wp) :: MaxgrazingrateMesoZoo          ! day-1 maximum grazing rate max grazing rate of microzoo about 3 times higher than mesozoo especially, mesozoo n the BS if Calanus which is a large group

   real(wp) :: Half_Saturation_MicroZoo       ! mmolC/m3   half saturation constant for the grazing  Soetart et al., 2001
   real(wp) :: Half_Saturation_MesoZoo        !mmolC/m3   half saturation constant for the grazing    Soetart et al., 2001

   real(wp) :: Ass_Eff_OnNitrogen             !  -   assimilation efficiency of nitrogen Anderson and Pondhaven, 2003
   real(wp) :: Ass_Eff_OnCarbon               !   - assimilation efficiency of carbon  Anderson and Pondhaven, 2003

   real(wp) :: efficiency_growth_MicroZoo     ! - Zooplankton net growth efficiency on carbon Anderson and Pondhaven, 2003
   real(wp) :: efficiency_growth_MesoZoo      ! - MesoZooplankton net growth efficiency on carbon

   real(wp) :: Messy_feeding_MicroZoo         !   - messy feeding fraction to DOM Anderson and Pondhaven, 2003
   real(wp) :: Messy_feeding_MesoZoo          !  - messy feeding fraction to DOM Ander

   real(wp) :: Capt_eff_MicroZoo_Flagellates  !   -    capture efficiency
   real(wp) :: Capt_eff_MicroZoo_Emiliana     !  -    capture efficiency
   real(wp) :: Capt_eff_MicroZoo_Diatoms      ! -    capture efficiency
   real(wp) :: Capt_eff_MicroZoo_MicroZoo     !   -    capture efficiency
   real(wp) :: Capt_eff_MicroZoo_MesoZoo      !   -    capture efficiency
   real(wp) :: Capt_eff_MicroZoo_pom          !  -    capture efficiency
   real(wp) :: Capt_eff_MicroZoo_bac          !  -  capture efficiency

   real(wp) :: Capt_eff_MesoZoo_Flagellates   !  -    capture efficiency
   real(wp) :: Capt_eff_MesoZoo_Emiliana      !  -    capture efficiency
   real(wp) :: Capt_eff_MesoZoo_Diatoms       !  -    capture efficiency
   real(wp) :: Capt_eff_MesoZoo_MicroZoo      !  -    capture efficiency
   real(wp) :: Capt_eff_MesoZoo_MesoZoo       !  -    capture efficiency
   real(wp) :: Capt_eff_MesoZoo_pom           !  -    capture efficiency
   real(wp) :: Capt_eff_MesoZoo_bac           !  -  capture efficiency

   real(wp) :: HalfSatMort_MicroZoo           !  mmolC/m3   mortality half stauration rate
   real(wp) :: expmortMicroZoo                !  -       higher exponent of the mortality term
   real(wp) :: NLin_Mort_MicroZoo             ! day-1/mmolC/m3   mortality term in case of quadratic term (betazoo1=2) Anderson and William 
   real(wp) :: HalfSatMort_MesoZoo            ! mmolC/m3   mortality half stauration rate
   real(wp) :: expmortMesoZoo                 !   -       higher exponent of the mortality term
   real(wp) :: NLin_Mort_MesoZoo              ! day-1/mmolC/m3   mortality term in case of quadratic term (betazoo1=2)  Anderson and William instaed of 0.3 
   real(wp) :: Mortanoxic                     !  day-1    term of mortality due to the lack of DOX
   real(wp) :: DOXsatmort                     ! mmolO/m3    percentage of saturation where metabolic respiration is half the one under oxygen satyrated conditions

   real(wp) :: Q10Zoo                         !   -       temperature factor  Soetart et al., 2001
   real(wp) :: NCrMicroZoo                    !  mmolN/mmolC   0.18 N:C molar ratio  Anderson and Pondhaven, 2003
   real(wp) :: NCrMesoZoo                     !  mmolN/mmolC   0.21 N:C molar ratio

!=========!
!  LIGHT  !
!=========!
   real(wp)  ::  kBIOABSCHL
   real(wp)  ::  kBIOABSPOC

#ifdef fulloptics
   real(wp)  ::  a_w_short                           ! m-1, absorption by pure sea water Smith and baker 1981
   real(wp)  ::  bb_w_short                          ! m-1, backscatering by pure sea water Smith and baker 1981
   real(wp)  ::  a_chl_A_short                       ! A*CHL^B [m-1], Bricaud 95 DMITRIEV 2007
   real(wp)  ::  a_chl_B_short                      ! A*CHL^B [m-1], Bricaud 95 DMITRIEV 2007
   real(wp)  ::  bb_dia_short                           ! m2/mgPOC_DIA, backscatering by Diatoms, Vaillancourt 2004
   real(wp)  ::  bb_fla_short                           ! m2/mgPOC_FLA, backscatering by Diatoms, Vaillancourt 2004
   real(wp)  ::  bb_emi_short                          ! m2/mgPOC_EMI, backscatering by Diatoms, Vaillancourt 2004
   real(wp)  ::  a_poc_short                         ! m2/g , absorption by organic matter NEUCKERMANS 2012
   real(wp)  ::  bb_poc_short                        ! m-1, backscatering by organic matter NEUCKERMANS 2012
   real(wp)  ::  a_cdom_intercept_short          ! 0.13@10 0.02@19 
   real(wp)  ::  a_cdom_slope_short           

   real(wp)  ::  a_w_long                         ! m-1, absorption by pure sea water Smith and baker 1981
   real(wp)  ::  bb_w_long                          ! m-1, backscatering by pure sea water Smith and baker 1981
   real(wp)  ::  a_chl_A_long                        ! A*CHL^B [m-1], DMITRIEV 2007
   real(wp)  ::  a_chl_B_long                     ! A*CHL^B [m-1], Bricaud 95, DMITRIEV 2007 
   real(wp)  ::  bb_dia_long                            ! m2/mgPOC_DIA, backscatering by Diatoms, Vaillancourt 2004
   real(wp)  ::  bb_fla_long                           ! m2/mgPOC_FLA, backscatering by Diatoms, Vaillancourt 2004
   real(wp)  ::  bb_emi_long                          ! m2/mgPOC_EMI, backscatering by Diatoms, Vaillancourt 2004
   real(wp)  ::  a_poc_long                           ! m2/g , absorption by organic matter NEUCKERMANS 2012
   real(wp)  ::  bb_poc_long                      ! m-1, backscatering by organic matter NEUCKERMANS 2012
   real(wp)  ::  a_cdom_intercept_long         
   real(wp)  ::  a_cdom_slope_long          

   ! from a, bb, to Kd !! see LEE 2005b
   real(wp)  ::  mu_d                            ! average downward cosine .. should be computed considering senith angle, a/b ratio, depth 
#endif

   !  Parameters for water classification - default Jerlov type I
   !  ARTCHAnge : distinction supplémentaire ente
   !  ondes visible longue (LightAbsB), LightAbsVisL,
   !  ondes visible court  (1-LightAbsB),  LightAbsVisS
   !  0.003*0.05 (abs par chl,concentration moyenne de 0.05)
   !  +0.003*0.01 (abs par det,concentration moyenne de 0.01)
   !  unit is m**-1
   real(wp) :: LightAbsA
   real(wp) :: LightAbsB
   real(wp) :: LightAbsIR
   real(wp) :: LightAbsVisL
   real(wp) :: LightAbsVisS

#ifdef gelatinous
!============================
! GELATINOUS ZOOPLANKTON !
!=============================
    real(wp) :: MaxgrazingrateNoctiluca                            ! (day mmolC/m3)-1     ingestion coefficient Lancelot et al., 2002 ESCS
    real(wp)  :: MaxgrazingrateGelatinous                          ! (day mmolC/m3)-1     ingestion coefficient Lancelot et al., 2002 ESCS

    real(wp)  :: Ass_Eff_Noctiluca                                 ! -   assimilation efficiency  Lancelot et al., 2002 ESCS
    real(wp)  :: Ass_Eff_Gelatinous                                ! -   assimilation efficiency  Lancelot et al., 2002 ESCS

    real(wp)  :: Capt_eff_Noctiluca_Flagellates                    ! -    capture efficiency
    real(wp)  :: Capt_eff_Noctiluca_Emiliana                       ! -    capture efficiency
    real(wp)  :: Capt_eff_Noctiluca_Diatoms                        ! -    capture efficiency
    real(wp)  :: Capt_eff_Noctiluca_microzoo                       ! -    capture efficiency
    real(wp)  :: Capt_eff_Noctiluca_mesozoo                        ! -    capture efficiency
    real(wp)  :: Capt_eff_Noctiluca_pom                            ! -    capture efficiency
    real(wp)  :: Capt_eff_Gelatinous_Flagellates                   ! -    capture efficiency
    real(wp)  :: Capt_eff_Gelatinous_Emiliana                      ! -    capture efficiency
    real(wp)  :: Capt_eff_Gelatinous_Diatoms                       ! -    capture efficiency
    real(wp)  :: Capt_eff_Gelatinous_microzoo                      ! -    capture efficiency
    real(wp)  :: Capt_eff_Gelatinous_mesozoo                       ! -    capture efficiency
    real(wp)  :: Capt_eff_Gelatinous_pom                           ! -    capture efficiency

    real(wp)  :: threshold_feeding_Noctiluca                       ! mmolC/m3  feeding threshold Nakamura, 1998, JPR
    real(wp)  :: threshold_feeding_Gelatinous                      ! mmolC/m3  feeding threshold Lancelot et al., 2002 ESCS

    real(wp)  :: HalfSatMort_Noctiluca                             !  mmolC/m3   mortality half stauration rate
    real(wp)  :: expmortNoctiluca                                  !  -       higher exponent of the mortality term
    real(wp)  :: NLin_Mort_Noctiluca                               !  day-1/mmolC/m3   mortality term in case of quadratic term (betazoo1=2)  0.04 instead of 0.17 (Lancelot et al., 2002)
    real(wp)  :: HalfSatMort_Gelatinous                            !  mmolC/m3   mortality half stauration rate
    real(wp)  :: expmortGelatinous                                 !     -       higher exponent of the mortality term
    real(wp)  :: NLin_Mort_Gelatinous                              ! day-1/mmolC/m3   mortality term in case of quadratic term (betazoo1=2)  0.003 instead of 0.012 (Lancelot et al., 2002)

    real(wp)  :: efficiency_growth_Noctiluca                       !   -    Part of the Assimilated food of zooplankton used for growth  Lancelot et al., 2002 ESCS
    real(wp)  :: efficiency_growth_Gelatinous                      !   -    Part of the Assimilated food of zooplankton used for growth  Lancelot et al., 2002 ESCS

    real(wp)  :: basal_Resp_Noctiluca                              !  day-1  basal respiration rate
    real(wp)  :: basal_Resp_Gelatinous                             !    day-1  basal respiration rate

    real(wp)  :: NCrNoctiluca                                      !  mmolN/mmolC   N:C molar ratio Nakamura, 1998, JPR
    real(wp)  :: NCrGelatinous                                     !  mmolN/mmolC  N:C molar ratio

    real(wp)  :: SinkingRateNoctiluca                              ! m/sec Sedimentation rate of zooplankton
    real(wp)  :: SinkingRateGelatinous                             ! m/sec Sedimentation rate of zooplankton

    real(wp)  :: Q10Gelatinous                                     !  - Q10 fqctor for temperature dependency between 3.4-3.7 Kremer 1977   
#endif

    real(wp)  :: ksPO4Flagellates                    ! mmolP/m3   half saturation constant for phosphate uptake by phytoplankton
    real(wp)  :: ksPO4Diatoms                        ! mmolP/m3   half saturation constant for phosphate uptake by phytoplankton 0.4 for green ocean code
    real(wp)  :: ksPO4Emiliana                       ! mmolP/m3   half saturation constant for phosphate uptake by phytoplankton 0.004 for green ocean model 0.005 for Soetaert code
    real(wp)  :: PNRedfield                          !molP/molN   Redfield ratio
    real(wp)  :: csatpo4                             !mmolP/m3   half saturation conatsant for ammonium uptake by bacteria computed from AW values*PNratio
    real(wp)  :: PO4MaxuptakeEmiliana                ! molP/molC/d    maximal PO4 uptake rate
    real(wp)  :: PO4MaxuptakeDiatoms
    real(wp)  :: PO4MaxuptakeFlagellates

!============================
! SEDIMENTS                 !
!============================
#ifdef benthic
    real(wp)  ::    pfCSED                           !- Fraction of carbon flux that is fast decaying
    real(wp)  ::    pfSSed                           !- Fraction of Silice flux that is fast decaying
    real(wp)  ::    fCdegrate                        !- /s Degradation rate of the fast degrated carbon
    real(wp)  ::    sCdegrate                        !- /s Degradation rate of the fast degrated carbon
    real(wp)  ::    fSdisrate                        !- /s Dissolution rate of the fast degrated silice
    real(wp)  ::    sSdisrate                        !- /s Dissolution rate of the fast degrated silice
    real(wp)  ::    psoliddepo                       !- Fraction of precipiting ODU
    real(wp)  ::    OCrdegrad                        !- molO/molC Oxygen consumption for POM degradation 
    real(wp)  ::    ONrnitrif                        !- molO/molN Oxygen consumption for nitrification
    real(wp)  ::    NCrsedinit                       !- molO/molN Oxygen consumption for nitrification
    real(wp)  ::    Q10CDEG                          !- Q10 factor for temperature influence on C degradation 
!   real(wp)  ::    pdenitMult                       !- facteur multiplicatif pour pdenit 
    real(wp)  ::    sCburialrate                     ! /s , burial rate for sC stock
    real(wp)  ::    sSburialrate                     ! /s , burial rate for sS stock
    
!=========RESUPENSION==========!
    real(wp)  ::    criticalstress_DEP               ! N/m2 thresold on bottom stress for deposition
    real(wp)  ::    criticalstress_ERO_S             ! N/m2 thresold on bottom stress for erosion of slow stock
    real(wp)  ::    criticalstress_ERO_F             ! N/m2 thresold on bottom stress for erosion of fast stock
    real(wp)  ::    Me_sS                            ! mmol/m2s Erosion constant for slow silicious sediment
    real(wp)  ::    Me_fS                            ! mmol/m2s Erosion constant for fast silicious sediment
    real(wp)  ::    Me_sC                            ! mmol/m2s Erosion constant for slow carbonate sediment
    real(wp)  ::    Me_fC                            ! mmol/m2s Erosion constant for fast carbonate sediment
    real(wp)  ::    alphaRESUSP
#endif

#ifdef alkalinity_system
!============================
! CARBONATE SYSTEM          !
!============================
    logical  :: ln_reinitialize_pH
    real(wp) :: kbulk
    real(wp) :: MeanpC02air
#endif
    
#ifdef redistributeSinking
!----------------------------------
! redistribution of sunken material
!----------------------------------
   integer  :: k_redistribute_bottom
   real(wp) :: redistribute_top_dz
#endif


  NAMELIST/namtrc_bamhbi/ &
       & daytosecond, pi, WattToPhotons, &
       & Ocr,NCr,ksremindox,ksdeninos,kindenidox,kinanoxremdox,kinanoxremnos,ODUCr,ODU_solid,Roxnhs,ksoxnhsdox,kinoxnhsdox,kinoxnhsodu,ksoxnhsnos, &
       & ONoxnhsr,NOsNHsr, Roxnhsnos,Roxodu,ksoxodudox,ksoxodunos,kinoxodudox,OODUr,NODUr,Roxodunos,Q10chem,Fe3Mn3_density,Pho_precip_fac, &
       & NCrBac,maxhydrDOCSL,csatdocsl,maxgrowthbac,csatdocl,csatamm,mortbac,bactgrowtheff,Q10bac,Halfsaturation_Iron,IronCsurf,Param1IronCurve,Param2IronCurve, &
       & hydPOCmax,hydPONmax,SinkingRatePOM_Constant,ksatOxygenHydrolysis,labilefraction,labileextradocphyexcr, &
       & QuantumYieldDiatoms, QuantumYieldFlagellates, QuantumYieldEmiliana, &
       & alphaPIFlagellates,alphaPIEmiliana,alphaPIDiatoms,MinNCrFlagellates,MinNCrEmiliana,MinNCrDiatoms,MaxNCrFlagellates,MaxNCrEmiliana,MaxNCrDiatoms, &
       & MuMaxFlagellates,MuMaxEmiliana,MuMaxDiatoms,RespirationFlagellates,RespirationEmiliana,RespirationDiatoms,MortalityFlagellates,MortalityEmiliana,MortalityDiatoms, &
       & MinGrowthRespFlagellates,MaxGrowthRespFlagellates,GrowthRespEmiliana,GrowthRespDiatoms,GrowthRespFlagellates,Q10Phy,Q10PhyDiatoms, &
       & MinChlNrFlagellates,MinChlNrEmiliana,MinChlNrDiatoms,MaxChlNrFlagellates,MaxChlNrEmiliana,MaxChlNrDiatoms, &
       & NosMaxUptakeFlagellates,NosMaxUptakeEmiliana,NosMaxUptakeDiatoms,NHsMaxUptakeFlagellates,NHsMaxUptakeEmiliana,NHsMaxUptakeDiatoms, &
       & ksNOsFlagellates,ksNOsEmiliana,ksNOsDiatoms, ksNHs,ksNHsFlagellates,ksNHsEmiliana,ksNHsDiatoms,kinNHsPhy,leakagephy, extradocphyexcr,mortphydom, &
       & SinkingRateDiatomsmin,SinkingRateDiatomsmax, &
       & SiMaxUptakeDiatoms,ksSiDiatoms,SiNrDiatoms,kdis_Silicious_Detritus,vsinkingrate_Silicious_Detritus,Q10SilicateDiss, &
       & MaxgrazingrateMicroZoo,MaxgrazingrateMesoZoo, Half_Saturation_MicroZoo,Half_Saturation_MesoZoo,Ass_Eff_OnNitrogen,Ass_Eff_OnCarbon, &
       & efficiency_growth_MicroZoo,efficiency_growth_MesoZoo,Messy_feeding_MicroZoo,Messy_feeding_MesoZoo, &
       & Capt_eff_MicroZoo_Flagellates,Capt_eff_MicroZoo_Emiliana,Capt_eff_MicroZoo_Diatoms,Capt_eff_MicroZoo_MicroZoo, &
       & Capt_eff_MicroZoo_MesoZoo,Capt_eff_MicroZoo_pom,Capt_eff_MicroZoo_bac, &
       & Capt_eff_MesoZoo_Flagellates,Capt_eff_MesoZoo_Emiliana,Capt_eff_MesoZoo_Diatoms,Capt_eff_MesoZoo_MicroZoo,Capt_eff_MesoZoo_MesoZoo,Capt_eff_MesoZoo_pom,Capt_eff_MesoZoo_bac, &
       & HalfSatMort_MicroZoo,expmortMicroZoo,NLin_Mort_MicroZoo,HalfSatMort_MesoZoo,expmortMesoZoo,nlin_mort_MESozoo,Mortanoxic,DOXsatmort, &
       & Q10Zoo,NCrMicroZoo,NCrMesoZoo, &
       & ksPO4Flagellates,ksPO4Diatoms,ksPO4Emiliana,PNRedfield,csatpo4,PO4MaxuptakeEmiliana,PO4MaxuptakeDiatoms,PO4MaxuptakeFlagellates
#ifdef chlorophyll_geider
  NAMELIST/namtrc_bamhbi_geider/ &
       & MinChlCrPHY,MaxChlCrPHY, MinChlNrPHY,MaxChlNrPHY, &
       & NHSNoUptakeFlagellates, NHSNoUptakeEmiliana, NHSNoUptakeDiatoms, PO4NoUptakeFlagellates, PO4NoUptakeEmiliana, PO4NoUptakeDiatoms
#endif       
#ifdef aggregation
  NAMELIST/namtrc_bamhbi_aggregation/ &
       & shear,etabio,B,stick,m,dzetabio,C,Maxsize,epsini,dagg_limit
#endif

#ifdef gelatinous
  NAMELIST/namtrc_bamhbi_gelatinous/ &
       & MaxgrazingrateNoctiluca,MaxgrazingrateGelatinous,Ass_Eff_Noctiluca,Ass_Eff_Gelatinous, &
       & Capt_eff_Noctiluca_Flagellates,Capt_eff_Noctiluca_Emiliana,Capt_eff_Noctiluca_Diatoms,Capt_eff_Noctiluca_microzoo,Capt_eff_Noctiluca_mesozoo,Capt_eff_Noctiluca_pom, &
       & Capt_eff_Gelatinous_Flagellates,Capt_eff_Gelatinous_Emiliana,Capt_eff_Gelatinous_Diatoms,Capt_eff_Gelatinous_microzoo,Capt_eff_Gelatinous_mesozoo,Capt_eff_Gelatinous_pom, &
       & threshold_feeding_Noctiluca,threshold_feeding_Gelatinous, HalfSatMort_Noctiluca,expmortNoctiluca,NLin_Mort_Noctiluca,HalfSatMort_Gelatinous,expmortGelatinous, &
       & NLin_Mort_Gelatinous, efficiency_growth_Noctiluca,efficiency_growth_Gelatinous,basal_Resp_Noctiluca,basal_Resp_Gelatinous,NCrNoctiluca,NCrGelatinous, &
       & SinkingRateNoctiluca,SinkingRateGelatinous,Q10Gelatinous
#endif

#if defined fulloptics || defined simpleoptics
  NAMELIST/namtrc_bamhbi_optics/ &
       & kBIOABSCHL,kBIOABSPOC, & ! simpleoptics
       & a_w_short,bb_w_short,a_chl_A_short,a_chl_B_short,bb_dia_short,bb_fla_short,bb_emi_short, & ! fulloptics
       & a_poc_short,bb_poc_short,a_cdom_intercept_short,a_cdom_slope_short, &
       & a_w_long,bb_w_long,a_chl_A_long,a_chl_B_long,bb_dia_long,bb_fla_long,bb_emi_long,a_poc_long,bb_poc_long,a_cdom_intercept_long,a_cdom_slope_long, mu_d, &
       & LightAbsA,LightAbsB,LightAbsIR,LightAbsVisL,LightAbsVisS
#endif

#ifdef benthic
  NAMELIST/namtrc_bamhbi_benthic/ &
       & pfCSED,pfSSed,fCdegrate,sCdegrate,fSdisrate,sSdisrate,psoliddepo,OCrdegrad,ONrnitrif,NCrsedinit,Q10CDEG,sCburialrate,sSburialrate, &
       & criticalstress_DEP,criticalstress_ERO_S,criticalstress_ERO_F,Me_sS,Me_fS,Me_sC,Me_fC,alphaRESUSP
#endif

#ifdef alkalinity_system
  NAMELIST/namtrc_bamhbi_alka/ &
       & ln_reinitialize_pH, kbulk, MeanpC02air
#endif
  
#if defined redistributeSinking || defined redistributeLoss
  NAMELIST/namtrc_bamhbi_redist/ &
       & k_redistribute_bottom, dz_redistribute_top
#endif

end module bamhbi_params
