! This module creates NEMO variables needed in BAMHBI.F90 module
#include "bamhbi.h90"

module bamhbi_driver_nemo
#ifdef forcingmodel_nemo
#include "domzgr_substitute.h90"
#include "do_loop_substitute.h90"

  ! 1. NEMO modules providing the grid and the physics to BAMHBI
  use par_kind, only : wp
  use par_trc
  use oce_trc
  use trc
  use zdfdrg, only: rCdu_bot !M.C. use the same bottom drag as Nemo model
!#ifdef online
!  use traqsr, only  : ln_qsr_bio   !!! useless ???
!#endif
  use par_ben
  use in_out_manager, only : numout
  use lib_fortran
  use trcwbstress, only : wavestress, wave_direction, waves_botstr, cur_botstr
#ifdef airpco2
  use fldread
#endif
  
  ! 2. Bamhbi parameters that have different units when using different physical models
  REAL(wp), parameter, dimension(3) :: CfluxUnitConv = (/ 3600.0, 1.0, 1.0 /)
  REAL(wp), parameter :: PWUnitConv = 1.0
  
  ! 3. Supplimentary physical variables missing in the physical model
#if defined fulloptics
  REAL(wp), PUBLIC, allocatable, save :: zendeg(:,:)
#endif
  
  ! 4. Other bamhbi forcing variables that are defined here rather than in respective routines, because they
  !    are specify for Bamhbi coupled to NEMO
#ifdef airpco2
  TYPE(FLD), PUBLIC, ALLOCATABLE, DIMENSION(:)      :: sf_pco2  ! for bamhbi_alkalinity
#endif

contains
  
  ! 5. Supplimentary routines missing in the physical model
#if defined fulloptics
  SUBROUTINE zenith()
      ! compute solar zenital angle needed for bamhbi
      ! based on sbcblk_algo_mfs.F90
      ! and using various Nemo variables

      implicit none
      !REAL(wp), DIMENSION(:,:), INTENT(out) :: angzen
      REAL(wp) :: alat, days, hour, th0,th02,th03, sundec, thsun, coszen
      INTEGER :: jj, ji

      if (.not.allocated(zendeg)) allocate( zendeg(jpi,jpj) );
      
      !!   days is the number of days elapsed until the day=nday_year
      days = nday_year -1.

      th0  = 2.*rpi*days/DBLE(nyear_len(1))
      th02 = 2.*th0
      th03 = 3.*th0

      !! --- sun declination :
      sundec = 0.006918 - 0.399912*COS(th0) + 0.070257*SIN(th0) -   &
              0.006758*COS(th02) + 0.000907*SIN(th02) -   &
              0.002697*COS(th03) + 0.001480*SIN(th03)

      !! --- hour
      hour = (( nsec_year / rday ) - INT (nsec_year / rday)) * rjjhh

      DO_2D(0,0,0,0)
             !! --- sun hour angle :
             thsun = ( (hour -12.)*15. + glamt(ji,jj) )*rad

             !! --- cosine of the solar zenith angle :
             alat=rad*gphit(ji,jj)
             coszen =SIN(alat)*SIN(sundec)+COS(alat)*COS(sundec)*COS(thsun)

             IF(coszen .LE. 5.035D-04) coszen = 0.0
             IF (coszen.GE.1.0_wp) THEN ! the necessity of this, depends on wp
                zendeg(ji,jj) = 0.0_wp
             ELSE
                zendeg(ji,jj)=ACOS(coszen)/rad  ! rad=3.14.../180, defined in phycst
             END IF
      END_2D
  END SUBROUTINE zenith
#endif

  ! 6. Other bamhbi subroutines that are defined here rather than in respective modules, because they
  !    are specify for Bamhbi coupled to NEMO
#ifdef alkalinity_system
  subroutine prelim_init_alka()   ! nothing to be done when Bamhni is forced by NEMO
  end subroutine prelim_init_alka

#ifdef airpco2
  subroutine init_air_pco2
    integer                                 :: ierr1, ierr2, ierr3
    TYPE(FLD_N), ALLOCATABLE, DIMENSION(:)  :: sn_pCO2  ! namelist structure of input (file informations, fields read)
    CHARACTER(len=100)                      :: cn_dir
    NAMELIST/nam_pCO2/ sn_pCO2, cn_dir

    ierr1=0; ierr2=0; ierr3=0
    allocate(sn_pCO2(1),stat=ierr1)
    IF( ierr1 > 0 ) THEN
       CALL ctl_stop( 'bamhbi init_air_pco2: unable to allocate namelist arrays' )   ;   RETURN
    ENDIF
    cn_dir  = './'
    !              ! filename ! freq !  title   ! interp !  clim  ! 1m/1y ! wgt ! rot ! SoL !
    sn_pCO2= FLD_N( 'NONAME' ,  0   , 'NOTITLE', .false., .false.,  ''   ,  '' ,  '' , ''  )
    !REWIND( numnat_cfg )
    READ  ( numnat_cfg, nam_pCO2)

    ALLOCATE( sf_pCO2(1), STAT=ierr1 )
    ALLOCATE( sf_pCO2(1)%fnow(jpi,jpj,1)   , STAT=ierr2 )              ! L.V. 2023-6-10 replaced 1,1,1
    IF( sn_pCO2(1)%ln_tint )  ALLOCATE( sf_pCO2(1)%fdta(jpi,jpj,1,2) , STAT=ierr3 ) ! idem
    IF( ierr1 + ierr2 + ierr3 > 0 ) THEN
      CALL ctl_stop( 'init_air_pCO2 : unable to allocate {sf,sn}_pCO2 structure' )   ;   RETURN
    ENDIF

    CALL fld_fill( sf_pCO2, sn_pCO2, cn_dir, 'init_forcing_pCO2', 'atmosph. pCO2', 'nam_pCO2' )
  end subroutine init_air_pco2
#endif
#endif

#endif  
end module bamhbi_driver_nemo
