! This module creates grid and physical variables needed by Bamhbi
! It also declares Bamhbi parameters and stores them in a Fortran /common/
! Finally, it describes the glob_sum function needed by Bamhbi

#include "bamhbi.h90"

module bamhbi_driver_R
#ifdef forcingmodel_deSolve

  ! technical stuff
  integer, parameter :: wp=8
  logical, parameter :: lwp=.true.
  integer, parameter :: proc=1
  integer, parameter :: numout=6
#ifdef online
  logical, parameter :: l_offline=.false.
#else
  logical, parameter :: l_offline=.true.  ! this should always be true in R/deSolve
#endif
  
  ! grid and environment
  !!! NCell should match with bamhbi.R declaration !!! 
  INTEGER, PARAMETER            :: jpi=1,jpj=1, ntsj=1, ntej=1, ntsi=1, ntei=1, NCell=56
  integer                       :: jpk,jpkm1
  real(wp), allocatable, target :: e1t(:,:),e2t(:,:),e3t(:,:,:,:), cvol(:,:,:)
  real(wp), allocatable, target :: e1v(:,:),e2u(:,:),e3u(:,:,:,:),e3v(:,:,:,:),e3w(:,:,:,:)
  real(wp), allocatable, target :: gdept_1d(:), gdept(:,:,:,:)
  integer,  allocatable         :: tmask(:,:,:),umask(:,:,:),vmask(:,:,:)
  integer,  allocatable, target :: mbkt(:,:)
  integer,  pointer             :: mbku(:,:),mbkv(:,:)

  ! physics variables
  integer, parameter            :: jp_tem=1
  integer, parameter            :: jp_sal=2
 ! real(wp), allocatable         :: rhop(:,:,:)
  real(wp), parameter           :: rpi=3.141593
  
  ! pelagic variables
  integer                       :: jp_my_trc, jp_myt0,jp_myt1
  real(wp), allocatable, target :: tr(:,:,:,:,:)  ! replaces trb and tra
#ifdef aggregation
   character(11), parameter     :: SinkingVelocityType= 'aggregation'
#else
   character(11), parameter     :: SinkingVelocityType= 'constant'
#endif
  logical                       :: IncludeSilicate

  ! benthic variables
  integer  :: jp_ben
  integer, parameter            :: jp_benlvl=1
  real(wp), allocatable, target :: bt(:,:,:,:,:)

  ! hard-coded parameters
  integer, parameter            :: waves_botstr=1 , cur_botstr=0
  real(wp), parameter           :: dagg_limit=1.e9/86400
  real(wp), parameter           :: fe3mn3_density=16.1
  real(wp), parameter           :: PHO_precip_fac=0.001/86400
  real(wp)                      :: MaxSiCrDiatoms,MinSiCrDiatoms ! will be computed once and for in bamhbi at startup
  real(wp), parameter           :: rho0=1020
  real(wp), parameter, dimension(3) :: CfluxUnitConv = (/ 0.04166666666666666 , 0.0004166666666666666, 0.8333333333333334 /)
  real(wp), parameter :: PWUnitConv = 86400.0
  
  ! BAMHBI parameters
  real(wp) :: daytosecond,shear,etabio,B,stick,m,dzetabio,C,Maxsize,epsini,OCr,NCr,ksremindox,ksdeninos,kindenidox,kinanoxremdox,kinanoxremnos,ODUCr,ODU_solid,Roxnhs,ksoxnhsdox, &
       kinoxnhsdox,kinoxnhsodu,ONoxnhsr,NOsNHsr,Roxnhsnos,Roxodu,ksoxodudox,ksoxodunos,kinoxodudox,OODUr,NODUr,Roxodunos,Q10chem,NCrBac,maxhydrDOCSL,csatdocsl,maxgrowthbac,csatdocl, &
       csatamm,mortbac,bactgrowtheff,Q10bac,Halfsaturation_Iron,IronCsurf,Param1IronCurve,Param2IronCurve,hydPOCmax,hydPONmax,SinkingRatePOM_Constant,BurialOfCarbon,BurialOfNitrogen,&
       ksatOxygenHydrolysis,labilefraction,labileextradocphyexcr,IncludeSilicate_real,QuantumYieldDiatoms,QuantumYieldFlagellates,QuantumYieldEmiliana,alphaPIFlagellates,&
       alphaPIEmiliana,alphaPIDiatoms,MinNCrFlagellates,MinNCrEmiliana,MinNCrDiatoms,MaxNCrFlagellates,MaxNCrEmiliana,MaxNCrDiatoms,MuMaxFlagellates,MuMaxEmiliana,MuMaxDiatoms,&
       RespirationFlagellates,RespirationEmiliana,RespirationDiatoms,MortalityFlagellates,MortalityEmiliana,MortalityDiatoms,MinGrowthRespFlagellates,MaxGrowthRespFlagellates,&
       GrowthRespEmiliana,GrowthRespDiatoms,GrowthRespFlagellates,Q10Phy,Q10PhyDiatoms,Q10PhyFlagellates,Q10PhyEmilianna,MinChlNrFlagellates,MinChlNrEmiliana,MinChlNrDiatoms,&
       MaxChlNrFlagellates,MaxChlNrEmiliana,MaxChlNrDiatoms,NosMaxUptakeFlagellates,NosMaxUptakeEmiliana,NosMaxUptakeDiatoms,NHsMaxUptakeFlagellates,NHsMaxUptakeEmiliana,&
       NHsMaxUptakeDiatoms,ksNOsFlagellates,ksNOsEmiliana,ksNOsDiatoms,ksNHsFlagellates,ksNHsEmiliana,ksNHsDiatoms,kinNHsPhy,leakagephy,extradocphyexcr,mortphydom,SiMaxUptakeDiatoms,&
       ksSiDiatoms,SiNrDiatoms,kdis_Silicious_Detritus,vsinkingrate_Silicious_Detritus,Q10SilicateDiss,MaxgrazingrateMicroZoo,MaxgrazingrateMesoZoo,Half_Saturation_MicroZoo,&
       Half_Saturation_MesoZoo,Ass_Eff_OnNitrogen,Ass_Eff_OnCarbon,efficiency_growth_MicroZoo,efficiency_growth_MesoZoo,Messy_feeding_MicroZoo,Messy_feeding_MesoZoo,&
       Capt_eff_MicroZoo_Flagellates,Capt_eff_MicroZoo_Emiliana,Capt_eff_MicroZoo_Diatoms,Capt_eff_MicroZoo_MicroZoo,Capt_eff_MicroZoo_MesoZoo,Capt_eff_MicroZoo_pom,&
       Capt_eff_MicroZoo_bac,Capt_eff_MesoZoo_Flagellates,Capt_eff_MesoZoo_Emiliana,Capt_eff_MesoZoo_Diatoms,Capt_eff_MesoZoo_MicroZoo,Capt_eff_MesoZoo_MesoZoo,Capt_eff_MesoZoo_pom,&
       Capt_eff_MesoZoo_bac,HalfSatMort_MicroZoo,expmortMicroZoo,NLin_Mort_MicroZoo,HalfSatMort_MesoZoo,expmortMesoZoo,NLin_Mort_MesoZoo,Mortanoxic,DOXsatmort,Q10Zoo,NCrMicroZoo,&
       NCrMesoZoo,kBIOABSCHL,kBIOABSPOC,a_w_short,bb_w_short,a_chl_A_short,a_chl_B_short,bb_dia_short,bb_fla_short,bb_emi_short,a_smi_short,bb_smi_short,a_poc_short,bb_poc_short,&
       a_cdom_intercept_short,a_cdom_slope_short,a_w_long,bb_w_long,a_chl_A_long,a_chl_B_long,bb_dia_long,bb_fla_long,bb_emi_long,a_smi_long,bb_smi_long,a_poc_long,bb_poc_long,&
       a_cdom_intercept_long,a_cdom_slope_long,mu_d,LightAbsA,LightAbsB,LightAbsIR,LightAbsVisL,LightAbsVisS,Ass_Eff_Noctiluca,Ass_Eff_Gelatinous,Capt_eff_Noctiluca_Flagellates,&
       Capt_eff_Noctiluca_Emiliana,Capt_eff_Noctiluca_Diatoms,Capt_eff_Noctiluca_microzoo,Capt_eff_Noctiluca_mesozoo,Capt_eff_Noctiluca_pom,Capt_eff_Gelatinous_Flagellates,&
       Capt_eff_Gelatinous_Emiliana,Capt_eff_Gelatinous_Diatoms,Capt_eff_Gelatinous_microzoo,Capt_eff_Gelatinous_mesozoo,Capt_eff_Gelatinous_pom,threshold_feeding_Gelatinous,&
       HalfSatMort_Noctiluca,expmortNoctiluca,NLin_Mort_Noctiluca,HalfSatMort_Gelatinous,expmortGelatinous,NLin_Mort_Gelatinous,efficiency_growth_Gelatinous,basal_Resp_Noctiluca,&
       basal_Resp_Gelatinous,NCrNoctiluca,NCrGelatinous,SinkingRateNoctiluca,SinkingRateGelatinous,Q10Gelatinous,ksPO4Flagellates,ksPO4Diatoms,ksPO4Emiliana,PNRedfield,csatpo4,&
       PO4MaxuptakeEmiliana,PO4MaxuptakeDiatoms,PO4MaxuptakeFlagellates,pfCSED,pfSSed,fCdegrate,sCdegrate,fSdisrate,sSdisrate,psoliddepo,OCrdegrad,ONrnitrif,NCrsedinit,Q10CDEG,&
       vsinkingSMI,criticalstress_DEP_SMI,criticalstress_ERO_SMI,Me_smi,smiburialrate,Me_sS,Me_fS,Me_sC,Me_fC,alphaRESUSP,criticalstress_DEP,criticalstress_ERO_S,criticalstress_ERO_F,&
       sCburialrate,sSburialrate,MaxgrazingrateNoctiluca,MaxgrazingrateGelatinous,threshold_feeding_Noctiluca,efficiency_growth_Noctiluca,SinkingRateDiatomsmin,SinkingRateDiatomsmax,&
       redistribute_bottom_flux_top, k_redistribute, &
#ifdef alkalinity_system
       kbulk,MeanPC02Air,&
#endif
      dtmax
        
#ifdef alkalinity_system
  real(wp) :: pH_init(NCell)
#endif
  real(wp) :: dz(NCell), depth(1,1,NCell),dz_center(NCell+1)

  common /myparms/daytosecond,shear,etabio,B,stick,m,dzetabio,C,Maxsize,epsini,OCr,NCr,ksremindox,ksdeninos,kindenidox,kinanoxremdox,kinanoxremnos,ODUCr,ODU_solid,Roxnhs,ksoxnhsdox, &
       kinoxnhsdox,kinoxnhsodu,ONoxnhsr,NOsNHsr,Roxnhsnos,Roxodu,ksoxodudox,ksoxodunos,kinoxodudox,OODUr,NODUr,Roxodunos,Q10chem,NCrBac,maxhydrDOCSL,csatdocsl,maxgrowthbac,csatdocl, &
       csatamm,mortbac,bactgrowtheff,Q10bac,Halfsaturation_Iron,IronCsurf,Param1IronCurve,Param2IronCurve,hydPOCmax,hydPONmax,SinkingRatePOM_Constant,BurialOfCarbon,BurialOfNitrogen,&
       ksatOxygenHydrolysis,labilefraction,labileextradocphyexcr,IncludeSilicate_real,QuantumYieldDiatoms,QuantumYieldFlagellates,QuantumYieldEmiliana,alphaPIFlagellates,&
       alphaPIEmiliana,alphaPIDiatoms,MinNCrFlagellates,MinNCrEmiliana,MinNCrDiatoms,MaxNCrFlagellates,MaxNCrEmiliana,MaxNCrDiatoms,MuMaxFlagellates,MuMaxEmiliana,MuMaxDiatoms,&
       RespirationFlagellates,RespirationEmiliana,RespirationDiatoms,MortalityFlagellates,MortalityEmiliana,MortalityDiatoms,MinGrowthRespFlagellates,MaxGrowthRespFlagellates,&
       GrowthRespEmiliana,GrowthRespDiatoms,GrowthRespFlagellates,Q10Phy,Q10PhyDiatoms,Q10PhyFlagellates,Q10PhyEmilianna,MinChlNrFlagellates,MinChlNrEmiliana,MinChlNrDiatoms,&
       MaxChlNrFlagellates,MaxChlNrEmiliana,MaxChlNrDiatoms,NosMaxUptakeFlagellates,NosMaxUptakeEmiliana,NosMaxUptakeDiatoms,NHsMaxUptakeFlagellates,NHsMaxUptakeEmiliana,&
       NHsMaxUptakeDiatoms,ksNOsFlagellates,ksNOsEmiliana,ksNOsDiatoms,ksNHsFlagellates,ksNHsEmiliana,ksNHsDiatoms,kinNHsPhy,leakagephy,extradocphyexcr,mortphydom,SiMaxUptakeDiatoms,&
       ksSiDiatoms,SiNrDiatoms,kdis_Silicious_Detritus,vsinkingrate_Silicious_Detritus,Q10SilicateDiss,MaxgrazingrateMicroZoo,MaxgrazingrateMesoZoo,Half_Saturation_MicroZoo,&
       Half_Saturation_MesoZoo,Ass_Eff_OnNitrogen,Ass_Eff_OnCarbon,efficiency_growth_MicroZoo,efficiency_growth_MesoZoo,Messy_feeding_MicroZoo,Messy_feeding_MesoZoo,&
       Capt_eff_MicroZoo_Flagellates,Capt_eff_MicroZoo_Emiliana,Capt_eff_MicroZoo_Diatoms,Capt_eff_MicroZoo_MicroZoo,Capt_eff_MicroZoo_MesoZoo,Capt_eff_MicroZoo_pom,&
       Capt_eff_MicroZoo_bac,Capt_eff_MesoZoo_Flagellates,Capt_eff_MesoZoo_Emiliana,Capt_eff_MesoZoo_Diatoms,Capt_eff_MesoZoo_MicroZoo,Capt_eff_MesoZoo_MesoZoo,Capt_eff_MesoZoo_pom,&
       Capt_eff_MesoZoo_bac,HalfSatMort_MicroZoo,expmortMicroZoo,NLin_Mort_MicroZoo,HalfSatMort_MesoZoo,expmortMesoZoo,NLin_Mort_MesoZoo,Mortanoxic,DOXsatmort,Q10Zoo,NCrMicroZoo,&
       NCrMesoZoo,kBIOABSCHL,kBIOABSPOC,a_w_short,bb_w_short,a_chl_A_short,a_chl_B_short,bb_dia_short,bb_fla_short,bb_emi_short,a_smi_short,bb_smi_short,a_poc_short,bb_poc_short,&
       a_cdom_intercept_short,a_cdom_slope_short,a_w_long,bb_w_long,a_chl_A_long,a_chl_B_long,bb_dia_long,bb_fla_long,bb_emi_long,a_smi_long,bb_smi_long,a_poc_long,bb_poc_long,&
       a_cdom_intercept_long,a_cdom_slope_long,mu_d,LightAbsA,LightAbsB,LightAbsIR,LightAbsVisL,LightAbsVisS,Ass_Eff_Noctiluca,Ass_Eff_Gelatinous,Capt_eff_Noctiluca_Flagellates,&
       Capt_eff_Noctiluca_Emiliana,Capt_eff_Noctiluca_Diatoms,Capt_eff_Noctiluca_microzoo,Capt_eff_Noctiluca_mesozoo,Capt_eff_Noctiluca_pom,Capt_eff_Gelatinous_Flagellates,&
       Capt_eff_Gelatinous_Emiliana,Capt_eff_Gelatinous_Diatoms,Capt_eff_Gelatinous_microzoo,Capt_eff_Gelatinous_mesozoo,Capt_eff_Gelatinous_pom,threshold_feeding_Gelatinous,&
       HalfSatMort_Noctiluca,expmortNoctiluca,NLin_Mort_Noctiluca,HalfSatMort_Gelatinous,expmortGelatinous,NLin_Mort_Gelatinous,efficiency_growth_Gelatinous,basal_Resp_Noctiluca,&
       basal_Resp_Gelatinous,NCrNoctiluca,NCrGelatinous,SinkingRateNoctiluca,SinkingRateGelatinous,Q10Gelatinous,ksPO4Flagellates,ksPO4Diatoms,ksPO4Emiliana,PNRedfield,csatpo4,&
       PO4MaxuptakeEmiliana,PO4MaxuptakeDiatoms,PO4MaxuptakeFlagellates,pfCSED,pfSSed,fCdegrate,sCdegrate,fSdisrate,sSdisrate,psoliddepo,OCrdegrad,ONrnitrif,NCrsedinit,Q10CDEG,&
       vsinkingSMI,criticalstress_DEP_SMI,criticalstress_ERO_SMI,Me_smi,smiburialrate,Me_sS,Me_fS,Me_sC,Me_fC,alphaRESUSP,criticalstress_DEP,criticalstress_ERO_S,criticalstress_ERO_F,&
       sCburialrate,sSburialrate,MaxgrazingrateNoctiluca,MaxgrazingrateGelatinous,threshold_feeding_Noctiluca,efficiency_growth_Noctiluca,SinkingRateDiatomsmin,SinkingRateDiatomsmax,&
       redistribute_bottom_flux_top, k_redistribute,&
#ifdef alkalinity_system
       kbulk,MeanPC02Air,pH_init,&
#endif
       dz,depth,dz_center, dtmax
       
  real(wp) :: rdt_trc
       
  real(wp) :: ts(1,1,NCell,jp_sal,1),uu(0:1,1,NCell,1),vv(1,0:1,NCell,1),rhop(1,1,Ncell)  ! use uu(2,1,NCell,1) and vv(1,2,NCell,1) if required by bottom stress computation
  real(wp) :: uu_temp(1,1,NCell), vv_temp(1,1,NCell)
  real(wp) :: wndm(1,1), zendeg(1,1), qsr(1,1)
  real(wp) :: cdiff(NCell+1)
  real(wp) :: Tpeak(1,1), SWH(1,1), wavestress(1,1)
  common /myforcs/ ts,uu_temp,vv_temp,rhop,wndm,zendeg,qsr,cdiff,wavestress

  real(wp) :: rCdu_bot(jpi,jpj), wave_direction(jpi,jpj)
  
  interface glob_sum
     module procedure &
          glob_sum_2D, &
          glob_sum_3D
  end interface
    
  
contains

  subroutine bamhbi_R_init
    jpk=NCell ; jpkm1=NCell-1
    jp_my_trc = 0
#ifdef alkalinity_system    
    OPEN (55, file = 'variables_pH.txt')
#else
    OPEN (55, file = 'variables.txt')
#endif    
    do
       READ (55,*, END=10) ;   jp_my_trc = jp_my_trc + 1
    END DO
10  CLOSE (55)
    jp_my_trc=jp_my_trc-1 ! remove one due to headerline
    jp_myt0=1; jp_myt1=jp_my_trc
    jp_ben = 0
#ifdef benthic_system
    OPEN (55, file = 'variables_benthic.txt')
    do
       READ (55,*, END=11) ;   jp_ben = jp_ben + 1
    END DO
11  CLOSE (55)
    jp_ben=jp_ben-1       ! remove one due to headerline
#endif
    
    !allocate variables
    if (.not.allocated(e1t))   allocate(e1t(jpi,jpj),e2t(jpi,jpj),e3t(jpi,jpj,jpk,1))
    if (.not.allocated(e2u))   allocate(e2u(jpi,jpj),e1v(jpi,jpj),e3u(jpi,jpj,jpk,1),e3v(jpi,jpj,jpk,1),e3w(jpi,jpj,jpk,1),gdept_1d(jpk),gdept(jpi,jpj,jpk,1))
    if (.not.allocated(mbkt))  allocate(mbkt(jpi,jpj))      ; mbkt=jpk ! index of the lowest sea-cell in the column
    if (.not.allocated(tmask)) allocate(tmask(jpi,jpj,jpk)) ; tmask=1
    if (.not.allocated(umask)) allocate(umask(jpi+1,0:jpj,jpk),vmask(jpi,jpj+1,jpk))
    if (.not.allocated(cvol))  allocate(cvol(jpi,jpj,jpk))
    if (.not.allocated(tr))    allocate(tr(jpi,jpj,jpk,jp_my_trc,2))
#ifdef benthic_system
    if (.not.allocated(bt))    allocate(bt(jpi,jpj,jp_benlvl,jp_ben,2))
#endif
    
    !initialize variables
    e1t=1.0;e2t=1.0;e1v=1.0;e2u=1.0;
    e3t(1,1,:,1)=dz ; e3u(1,1,:,1)=dz; e3v(1,1,:,1)=dz; e3w(1,1,:,1)=dz; ! e3w is probably shifted 1/2 cell to the surface compared to e3t
    do k=1,jpk
       cvol(:,:,k)=tmask(:,:,k)*e1t*e2t*e3t(:,:,k,1)
    end do
    gdept_1d=depth(1,1,:); gdept(:,:,:,1)=depth;
    umask(1,1,:)=1;umask(2,1,:)=0
    vmask(1,1,:)=1;vmask(1,2,:)=0
    uu(1,1,:,1)=uu_temp(1,1,:); uu(0,1,:,1)=uu_temp(1,1,:)
    vv(1,1,:,1)=vv_temp(1,1,:); vv(1,0,:,1)=vv_temp(1,1,:)
    mbku=>mbkt  
    mbkv=>mbkt
    
    ! dt is only used in the benthic model, to avoid overconsumption of bottom water tracers,
    !             and in the aggregate module, to avoid excessive creation or destruction of AGG
    ! Here we use the maximal timestep, instead of the effective time step, since the actual timestep is only decided later on by the solver lsoda
    ! pre_bio will copy rdt_trc into dt
    rdt_trc=dtmax
    
  end subroutine bamhbi_R_init  

  !--------------------------------------

  real(wp) function glob_sum_3D(routine,field)
    character(len=*) :: routine
    real(wp) :: field(:,:,:)
    glob_sum_3D=sum(field)
  end function glob_sum_3D

  real(wp) function glob_sum_2D(routine,field)
    character(len=*) :: routine
    real(wp) :: field(:,:)
    glob_sum_2D=sum(field)
  end function glob_sum_2D

  subroutine ctl_stop( s )
    character(len=*) :: s
    write(*,*) s
  end subroutine ctl_stop


  !----------------------------------------

  subroutine prelim_init_alka()
    ! Initialize pH and airpCO2 when using R-deSolve
    ! deSolve cannot initialize pH in CalculateDIC as it is not aware if kt==it000
    do k=1,jpk
      do j=1,jpj
        do i=1,jpi
           pH(i,j,k)=pH_init(k)     ! values read by R and sent to Fortran; we could also use ph_init_equation(density_anomaly) here
#ifdef csystemcheck
           pHiniout(i,j,k)=pH_init(k)
#endif
#ifdef airpco2
           if (k.eq.1) call compute_air_pco2(1990,220,pCO2air(i,j))
#endif
        end do
      end do
    end do
#ifndef airpco2
    pCO2air=MeanPC02Air
#endif
  end subroutine prelim_init_pH
  
 
  
#endif  
end module bamhbi_driver_R

