  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  !                BAMHBI biogeochemical model                           !
  !                     alkalinity module                                
  ! v0. original routines                            (M. Gregoire, 200X) !
  ! v1. adapted and included in 1D and 3D frameworks  (J. Rassman, 2019) !
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
module bamhbi_alkalinity_vars
#include "bamhbi.h90"

#ifdef alkalinity_system
  
#ifdef forcingmodel_nemo
  use bamhbi_driver_nemo
#include "domzgr_substitute.h90"
#endif
#ifdef forcingmodel_deSolve
  use bamhbi_driver_R
#endif
#include "do_loop_substitute.h90"
  
  integer :: CHA
  real(wp), allocatable ::    dPCHA(:,:,:),dDCHA(:,:,:)
  real(wp), allocatable ::    AirseaDICFlux(:,:)


  ! Alka is an ordinary variable, PCO2air can be constant spatially as a first approxiamtion , this is a forcing function
  real(wp),allocatable ::  pH(:,:,:),pHB(:,:,:),pCO2(:,:,:),pCO2Air(:,:)
#ifdef co2syscheck
  real(wp),allocatable ::  TA_co2sys(:,:,:),DIC_co2sys(:,:,:),CO3_co2sys(:,:,:),CO2_co2sys(:,:,:),HCO3_co2sys(:,:,:),pH_co2sys(:,:,:)
  real(wp),allocatable ::  TA_NATO(:,:,:),TA_Goyet(:,:,:)
#endif
  real(wp) ::  SumCO2, SumP, SumSi,SumNHx, SumNit,SumBorate, SumHS    ! µmol/l
  real(wp) ::  K_H2O                         ! Dissociation cst of water in mol/l
  real(wp) ::  K1_CO2,K2_CO2                 ! Dissociation cst of carbonic acid in mol/l
  real(wp) ::  K_BOH3                        ! Dissociation cst of boric acid Dissociation ct of water
  real(wp) ::  K1_H3PO4,K2_H3PO4,K3_H3PO4    ! Dissociation cst of phosphorus
  real(wp) ::  K_HNO3,K_NH4,K_HNO2           ! Dissociation cst of nitrate and ammonium
  real(wp) ::  K_H2S,K_Si, K1_Si, K2_Si      ! Dissociation cst of H2S and silicic acid in mol/l 
  real(wp) ::  K_SO4_SWS,K_F_SWS,K_HSO4,K_HF ! dissociation ct
  real(wp) ::  K_Aragonite, K_Calcite        ! in mol/l
  real(wp) ::  IonicStrength                 ! mol/kgLiq       
  real(wp) ::  TotalCharge,Hplus 
  real(wp) ::  refdensity


#ifdef csystemcheck
  real(wp),allocatable:: SumCO2_out(:,:,:), SumPout(:,:,:), SumSiout(:,:,:),SumNHxout(:,:,:)
  real(wp),allocatable:: SumNitout(:,:,:),SumBorateout(:,:,:), SumHSout(:,:,:)
  real(wp),allocatable:: Hplusout(:,:,:)
  real(wp),allocatable:: SiChargeout(:,:,:), PChargeout(:,:,:), BorateChargeout(:,:,:),WaterChargeout(:,:,:)
  real(wp),allocatable:: NitrateChargeout(:,:,:), AmmoniumChargeout(:,:,:), HSChargeout(:,:,:)
  real(wp),allocatable:: COchargeout(:,:,:), NonCOchargeout(:,:,:)
  real(wp),allocatable:: salinityout(:,:,:), temperatureout(:,:,:), refdensityout(:,:,:)
  real(wp),allocatable:: K_H2Oout(:,:,:),K1CO2out(:,:,:), K2CO2out(:,:,:)
  real(wp),allocatable:: KBOH3out(:,:,:)
  real(wp),allocatable:: K1H3PO4out(:,:,:),K2H3PO4out(:,:,:),K3H3PO4out(:,:,:)
  real(wp),allocatable:: KHNO3out(:,:,:),KNH4out(:,:,:),KHNO2out(:,:,:)
  real(wp),allocatable:: KH2Sout(:,:,:),KSiout(:,:,:)
  real(wp),allocatable:: KSO4SWSout(:,:,:),KFSWSout(:,:,:)
  real(wp),allocatable:: pHiniout(:,:,:),O2satout(:,:)
#endif

  contains
  
  subroutine alka_init(alloc_ok)
    integer, intent(out) :: alloc_ok    
    integer :: istat

    alloc_ok=0
    allocate(dPCHA(jpi,jpj,jpk), dDCHA(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat
    dPCHA=0. ; dDCHA=0.
    allocate( AirseaDICFlux(jpi,jpj), stat=istat); alloc_ok=alloc_ok + istat
    airseaDICflux=0.
    
    allocate( pH(jpi,jpj,jpk), pHB(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat   ; pH=0.0_wp ; pHB=0.0_wp
#ifdef co2syscheck
    allocate( TA_co2sys(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat   ; ta_co2sys=0.0_wp
    allocate( DIC_co2sys(jpi,jpj,jpk),CO3_co2sys(jpi,jpj,jpk),CO2_co2sys(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat ; DIC_co2sys=0.0_wp
    allocate( HCO3_co2sys(jpi,jpj,jpk),pH_co2sys(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat ; HCO3_co2sys=0.0_wp
    allocate( TA_NATO(jpi,jpj,jpk),TA_Goyet(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat ; TA_NATO=0.0_wp
#endif
    allocate( pCO2(jpi,jpj,jpk),pCO2Air(jpi,jpj), stat=istat) ; alloc_ok=alloc_ok + istat ; pCO2=0.0_wp

#ifdef csystemcheck 
    !Sum of alkalinity species
    allocate( SumCO2_out(jpi,jpj,jpk),SumPout(jpi,jpj,jpk),SumSiout(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat  
    allocate( SumNHxout(jpi,jpj,jpk),SumNitout(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat  
    allocate( SumBorateout(jpi,jpj,jpk),SumHSout(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat  
    !Hplus
    allocate( Hplusout(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat  
    !Charges contributing to alkalinity
    allocate( SiChargeout(jpi,jpj,jpk),PChargeout(jpi,jpj,jpk),BorateChargeout(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat 
    allocate( NitrateChargeout(jpi,jpj,jpk),AmmoniumChargeout(jpi,jpj,jpk),HSChargeout(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat 
    allocate( COChargeout(jpi,jpj,jpk),NonCOChargeout(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat 
    ! Temperature, Density & Salinity
    allocate( salinityout(jpi,jpj,jpk),temperatureout(jpi,jpj,jpk), refdensityout(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat 
    ! Dissociation constants
    allocate(  K_H2Oout(jpi,jpj,jpk),K1CO2out(jpi,jpj,jpk), K2CO2out(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat 
    allocate(  KBOH3out(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat 
    allocate(  K1H3PO4out(jpi,jpj,jpk),K2H3PO4out(jpi,jpj,jpk), K3H3PO4out(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat 
    allocate(  KHNO3out(jpi,jpj,jpk),KNH4out(jpi,jpj,jpk), KHNO2out(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat 
    allocate(  KH2Sout(jpi,jpj,jpk),KSiout(jpi,jpj,jpk), stat=istat) ; alloc_ok=alloc_ok + istat 
    allocate(  KSO4SWSout(jpi,jpj,jpk),KFSWSout(jpi,jpj,jpk),  stat=istat) ; alloc_ok=alloc_ok + istat 
    !others
    allocate(  pHiniout(jpi,jpj,jpk), O2satout(jpi,jpj),  stat=istat) ; alloc_ok=alloc_ok + istat 
#endif  

    call prelim_init_alka()  ! this routine does something only when BAMHBI is forced by R
  end subroutine alka_init
  
#endif
end module bamhbi_alkalinity_vars
