  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  !                BAMHBI biogeochemical model                           !
  !                     alkalinity module                                
  ! v0. original routines                            (M. Gregoire, 200X) !
  ! v1. adapted and included in 1D and 3D frameworks  (J. Rassman, 2019) !
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

module bamhbi_alkalinity
#include "bamhbi.h90"
#ifdef alkalinity_system
  
#ifdef forcingmodel_nemo
  use bamhbi_driver_nemo
#include "domzgr_substitute.h90"
#endif
#include "do_loop_substitute.h90"

  use bamhbi
  use bamhbi_alkalinity_vars

  contains

  SUBROUTINE DynamicsDIC ( kt, kbb, kmm )
  IMPLICIT NONE
  integer, intent(in) :: kt, kbb, kmm
  real(wp) :: K0,Resolution,&
      HCO3,CO3,CO2, & ! Variables used for solving the pH and carbonate system 
      windspeed, &
      !refdensity,&   ! is now declared for the whole module
      salinity,temperature,SWdepth ! Variables used for computing the CO2 airsea flux and dis cts	
   				   ! temperature is in °C, SWdepth in m, salinity in psu
  INTEGER  :: ji,jj,jk,NumIteration
  real(wp) :: gardefou

#ifdef forcingmodel_nemo
#ifdef airpco2
  call fld_read(kt=kt, kn_fsbc=1, sd=sf_pCO2)
  if (lwp) write(numout,*) 'pCO2=',sf_pCO2(1)%fnow(1,1,1)
#endif
  
  if (kt == nit000) then
    if ((ln_reinitialize_pH.or.(.not.ln_rstart)) .and. lwp) write(numout,*) 'INITIALIZING pH FROM DENSITY'
    DO_3D(0,0,0,0,1,jpk)
          if (tmask(ji,jj,jk).eq.1) then
            if (ln_reinitialize_pH.or.(.not.ln_rstart)) pHB(ji,jj,jk)=pH_init_equation(rhop(ji,jj,jk)-1000.0)
            ph(ji,jj,jk)= pHB(ji,jj,jk)
#ifdef csystemcheck
            pHiniout(ji,jj,jk)=pH(ji,jj,jk)
#endif
#ifdef airpco2
            pCO2air(ji,jj)=sf_pCO2(1)%fnow(1,1,1)
#else
            pCO2air(ji,jj)=MeanPC02Air
#endif
          end if
    END_3D
  end if
#endif
  
  DO_3D(0,0,0,0,1,jpk)
        if (tmask(ji,jj,jk).eq.1) then

          refdensity=rhop(ji,jj,jk)/1000   ! Density needs to be expressed in kg/l and not in kg/m3 for the computation of the airseaDIC flux and dissociation constants
          salinity=ts(ji,jj,jk,jp_sal,Kmm)
          temperature=ts(ji,jj,jk,jp_tem,Kmm)
          SWdepth=gdept(ji,jj,jk,Kmm)
          
#ifdef csystemcheck
          refdensityout(ji,jj,jk)=refdensity
          salinityout(ji,jj,jk)=salinity
          !temperatureout(ji,jj,jk)=temperature
#endif
     
          ! Estimate the the dissociation constants K_BOH3, ...
	  CALL Thermo_2(temperature,salinity,SWdepth,refdensity,ji,jj,jk)
   
	  ! Jens : to be added later 	(this routine is not yet there but I have it ready)	 
          ! CALL DISS_Minor(temperature,salinity,refdensity) !Computae the dissociation of Fluorid,..
        
	  ! CALL  Thermo_2_Calcite(temperature,salinity,SWdepth)

          ! Compute the Total concentration of species contributing to alkalinity 
          CALL CalculateTotalConcentration(ji,jj,jk,kbb,kmm)
        
          ! Estimating pH using Newton-Raphson method, Hplus is known from previous pH estimate, in mol/l 
          ! other species are in µmol/l
          gardefou = EstimatepH(NumIteration,Resolution,ji,jj,jk,refdensity,kt)  ! in pH definition, Hplus is in mol/kg
          if (abs(gardefou-pH(ji,jj,jk))<0.7_wp.and.gardefou>5.0_wp) pH(ji,jj,jk) = gardefou

          ! Calculate Carbonate speciation
	  CALL CalculateCO2Species(HCO3,CO3,CO2)
		
	  !So far we consider that the charge is conservative (no calcification) -> to be updated when everything goes well (ce sera qchose comme cela)
	  !dPCHA(ji,jj,jk)=2*dissolution_calcite(ji,jj,jk) ! à confirmer le facteur 2
	  !dDCHA(ji,jj,jk)=2*calcification(ji,jj,jk)
		
          !KO, the Henry's constant in mol/kg/atm ; pCO2 in µatm
          K0   = CalculateHenrysCt(temperature,salinity)  
          pCO2(ji,jj,jk)=CalculatepCO2(CO2,K0,temperature,SWdepth)     
           
          !===================!            
          ! AIR-SEA EXCHANGE  !
          !===================!            
          ! if we are at the surface (k=1) -> compute the air-sea flux
          if (jk.eq.1) then
            windspeed   = wndm(ji,jj)
            AirseaDICFlux(ji,jj) = CO2_AirSeaExchange(pCO2Air(ji,jj),pCO2(ji,jj,jk),temperature,salinity,windspeed,refdensity)
          endif
        
#ifdef co2syscheck
          !Outputs variables for validation
          !Compute the alkalinity, DIC for CO2sys and convert micromol/l to µmolkgSW attention in co2sys we do not have HS, NH3 and HF comapred to Dickson
          TA_co2sys(ji,jj,jk)  = (tr(ji,jj,jk,CHA,Kbb) - tr(ji,jj,jk,NOS,Kbb) + tr(ji,jj,jk,NHS,Kbb)-tr(ji,jj,jk,PHO,Kbb))/refdensity !-2*CalculateSulphate(refdensity,salinity)/refdensity
	  DIC_CO2sys(ji,jj,jk) = tr(ji,jj,jk,DIC,Kbb)/refdensity
	  CO2_co2sys(ji,jj,jk) = CO2/refdensity
	  CO3_co2sys(ji,jj,jk) = CO3/refdensity
	  HCO3_co2sys(ji,jj,jk)= HCO3/refdensity
		
          ! in Co2sys pH has to be computed from H+ in mol/kg-SW 
          pH_CO2sys(ji,jj,jk)=-LOG10(Hplus/refdensity)

          ! In the NATO database alkalinity seems to have been computed in µmol/l
          TA_NATO(ji,jj,jk) = tr(ji,jj,jk,CHA,Kbb) - tr(ji,jj,jk,NOS,Kbb) + tr(ji,jj,jk,NHS,Kbb)-tr(ji,jj,jk,ODU,Kbb)/2-tr(ji,jj,jk,PHO,Kbb)    !1/2 ODU stands for HS, a remplacer par un profil de HS
          ! Goyet type data is given in µmol/kg	   
	  TA_Goyet(ji,jj,jk)= (tr(ji,jj,jk,CHA,Kbb)-tr(ji,jj,jk,PHO,Kbb)- tr(ji,jj,jk,NOS,Kbb)+ tr(ji,jj,jk,NHS,Kbb)) / refdensity !-2*CalculateSulphate(refdensity,salinity)/refdensity
          ! To compare with Alberto's data :
!         TA_borges(ji,jj,jk)=TA_Goyet(ji,jj,jk) - (2*tr(ji,jj,jk,NHS,Kbb) + tr(ji,jj,jk,ODU,Kbb)) / refdensity   ! 2*1/2 ODU BECAUSE : ODU ~ HS , AND 1 ODU --> 2
#endif

        endif
  END_3D

  ! swap
  pHB=pH
  
  END SUBROUTINE DynamicsDIC



!==========================================================!
!        AIR-SEA EXCHANGE OF CO2                           !
!==========================================================!
real(wp) FUNCTION CO2_AirSeaExchange(pCO2Air, pCO2wat, Temp, Sal, wind, rHO0)
  !----------------------------------------------------------------!
  ! Calculates the exchange of CO2 across the air-sea interface    !
  ! assuming a certain piston velocity (m/d), the partial pressure !
  ! of CO2 in the air and surface water, and the solubility of     !
  ! CO2 in seawater                                                !
  !----------------------------------------------------------------!

  ! est >0 lorsque pCO2Air > pCO2water -> flux entrant
  ! est <0 lorsque         <           -> flux sortant
  ! attention formulation piston Wanninkhof (1992)

  IMPLICIT NONE

  real(wp) :: Rho0,     &  ! density of water, kg/l Attention pour l'echange de DIC la densite doit etre en kg/l tandis que pour l'echange d'oxygene, elle doit etre en kg/m3-
              pCO2Air,  &  ! partial pressure of CO2 in air (µatm)
              pCO2Wat,  &  ! partial pressure of CO2 in water (µatm)
              Temp,     &  ! the surface temperature in dg C
              Sal,      &  ! the surface salinity
              Wind,     &  ! the wind speed in m/s
			  piston       ! piston velocity (m/d)
  real(wp) :: TransferRate, HenrysCt,Schmidt      ! The Schmidt number
  real(wp)  :: TT, TTT

  ! The piston velocity !
  TT  = Temp*Temp
  TTT = TT*Temp

  ! QUESTION: USE THE SAME PISTON VELOCITY AS FOR O2 DYNAMICS ?
  ! Piston = Piston_Wanninkhof(SurfaceTemp,Windspeed)

  ! OR USE STEPS 1-3 BELOW HERE ???

  ! 1. The Schmidt number
  Schmidt = 2073.1-125.62*Temp+3.6276*TT -0.043219*TTT
  
  !Orr et al. 2017
  !Schmidt = 21116.8 - 136.25*Temp + 4.7353*TT - 0.092307*TTT +&
			!0.0007555*TT*TT

  ! 2. The piston velocty, in cm/hour according to Wanninkhof (1992)
  ! Journ. Geophys. Res. 97: 7327-7382.
  Piston = 2.5*(0.5246+0.016256*temp+0.00049946*TT) +kbulk*0.3*wind*wind &
            *1/SQRT(Schmidt/660)
  
  ! 3. convert from cm/hour to m/sec
  Piston = Piston *0.01/3600.
  
#ifdef forcingmodel_deSolve
  !Vonvert to m/day
  Piston = Piston * 86400
#endif


  ! Transfer in mol/kg/sec !

  ! K0 is in mol/kg/atm, or µmol/kg/µatm
  ! pCO2 is in µatm, rho is in kg/dm3
  HenrysCt     = CalculateHenrysCt(Temp, Sal)
  TransferRate = Piston * HenrysCt * (pCO2Air - pCO2Wat) !!!a positive flux means air to sea, a negative value sea to air!!

  ! Convert to mmol/m2/sec 
  CO2_AirSeaExchange = TransferRate*Rho0
END FUNCTION CO2_AirSeaExchange


!*************************************************************!
! ITERATIVELY SOLVING PH
!*************************************************************!
  real(wp) FUNCTION EstimatepH(Iterations,Resolution,ji,jj,jk,refdensity,kt)
  !-------------------------------------------------------------------------
  ! Before calling, the following conditions at the temperature, salinity 
  ! and depth must have been set
  ! The dissociation constants                       (moduleDissociation)
  ! The total conc of species contributing to Charge (moduleEquilibrium)
  !-------------------------------------------------------------------------

  IMPLICIT NONE
  real(wp), INTENT(OUT) :: Resolution

  INTEGER, PARAMETER    :: MaxIterations = 100
  real(wp), PARAMETER   :: Tolerance = 1.e-10
  real(wp)              :: Residual, dResidual, dx, pHnew
  real(wp)		:: refdensity
  integer               :: ji,jj,jk
  integer               :: ii
  integer, intent(out)  :: iterations
  integer, intent(in)   :: kt
   
  Resolution = 1.D0
  Iterations = MaxIterations

  !Newton-Raphson method
  DO II =1,MaxIterations
    CALL PHfunction(Residual,dResidual,ji,jj,jk)

    IF (dResidual /= 0.D0) THEN
      dx = Residual/dResidual
    ELSE
      Write(numout,*) "error ! Model cannot calculate ph! - "
      Exit
    ENDIF
         
    HPlus = HPlus - dx
    IF (ABS(dX) < Tolerance) THEN  
      Iterations  = II
      Resolution  = ABS(Residual)
      EXIT
    ENDIF

  ENDDO

  ! In case the model did not converge: use old values 
  IF (II >= MaxIterations) THEN
    write(numout,*) "error ! pH too many iterations!", kt,ji,jj,jk
  ENDIF 
      
  ! HPlus is in mol/kg 
  IF (Hplus > 0.d0) THEN
    EstimatepH   = -LOG10(Hplus)
  ELSE
    WRITE(numout,*) "error ! pH calculation did not converge", kt,ji,jj,jk
    EstimatepH = -99.
  ENDIF  

END FUNCTION EstimatepH



!*************************************************************!
! RESIDUAL BETWEEN NEW AND OLD VALUE OF HPLUS
!*************************************************************!
SUBROUTINE PHfunction(Residual,dResidual,ji,jj,jk)
   
  IMPLICIT NONE
  real(wp), INTENT(OUT) :: Residual, dResidual
  real(wp)              :: HOld, HNew
  real(wp), PARAMETER   :: dHplus = 1e-12
  Integer		:: ji,jj,jk

  HOld      = Hplus
  HNew      = SolvePH(ji,jj,jk)
  Residual  = HPlus - HNew

  HPlus     = HPlus+dHPlus
  HNew      = SolvePH(ji,jj,jk)
  dResidual = (HPlus - HNew -Residual) / dHPlus
  HPlus     = HOld

END SUBROUTINE PHfunction
   

!*************************************************************!
! CALCULCATE THE PH BY SOLVING A QUADRATIC EQUATION
!*************************************************************!
real(wp) FUNCTION SolvePH(ji,jj,jk)
  !-----------------------------------------------------------------------
  ! Uses the fact that the main contributor to Charge are carbonates
  !-----------------------------------------------------------------------
   
  IMPLICIT NONE
  real(wp)  :: CoCharge, NonCOCharge, aa, bb, cc,Hpl
  Integer   :: ji,jj,jk 
       
  ! 1. Estimate the contribution of the less important species directly
  NonCOCharge = CalculateNonCOCharge(ji,jj,jk)

  ! 2. Estimate H+ by solving the equation for the DIC species

  ! 3. carbonate Charge
  COCharge = TotalCharge - NonCOCharge   
  !COCharge equals HCO3-  +2* CO3--
  ! HCO3- = K1_CO2H  /(H2+K1_CO2H+K2_CO2K1_CO2) *SumCO2
  ! CO3-- = K2_CO2K1_CO2/(H2+K1_CO2H+K2_CO2K1_CO2) *SumCO2
  ! This gives rise to a quadratic equation in H
       
  aa = COCharge
  bb = (COCharge - 1.d0*SumCO2)*K1_CO2
  cc = (COCharge - 2.d0*SumCO2)*K1_CO2*K2_CO2

  ! new guess of H+
  SolvePH = (-bb + SQRT(BB*BB-4.D0*aa*cc) )/(2.D0*aa)

  ! ps: SolvePH and HPlus should converge
  ! pH scale = scale used for the dissociation constants
#ifdef csystemcheck  
  NonCOchargeout(ji,jj,jk)	=NonCOCharge
  COchargeout(ji,jj,jk)	=COCharge
#endif  
  
END FUNCTION SOlvePH


!************************************************************!
! THE CONTRIBUTION OF LESSER SPECIES TO CHARGE               !
!************************************************************!
real(wp) FUNCTION CalculateNonCOCharge(ji,jj,jk)
  !-------------------------------------------------------------------------
  ! Before calling, the dissociation constants must have been set for the
  ! prevailing temperature, salinity and depth
  !-------------------------------------------------------------------------  
  IMPLICIT NONE

  real(wp)  :: Denominator,WaterCharge,NitrateCharge,BorateCharge
  real(wp)  :: PCharge,SiCharge,HSCharge,AmmoniumCharge
  real(wp)  :: SO4Charge,FCharge,SO4,HSO4
  !real(wp) :: refdensity is now declared in the module
  !real(wp)  :: K1_Si, K2_Si  ! already declared in alklinity_vars
  
  Integer	:: ji,jj,jk

  ! Water charge: OH- -H+; convert OH- to µmol * 1e6
  !(Hplus is mol/kg, others µmol/l -> Converted in main routine Dynamics DIC)
  WaterCharge    = K_H2O/HPlus * 1.e6               &
                       - HPlus *1.0D6  ! *refdensity
  !  WaterCharge    = 0.D0 toggles off the buffer of water

  ! Nitrate 
  NitrateCharge  = K_HNO3/(K_HNO3+HPlus)         * SumNit 
      
  ! Borate
  BorateCharge   = K_BOH3 / (K_BOH3+Hplus)       * SumBorate

  ! Phosphate
  Denominator  = (Hplus**3)+(HPlus*HPlus*K1_H3PO4)+(HPlus*K1_H3PO4*K2_H3PO4)+(K1_H3PO4*K2_H3PO4*K3_H3PO4)
  !                H2PO4-               + 2*HPO4--                  + 3*PO4---
  PCharge      = (Hplus*HPlus*K1_H3PO4 +2.*K1_H3PO4*K2_H3PO4*HPlus + 3.*K1_H3PO4*K2_H3PO4*K3_H3PO4)  &
                      /Denominator                     * SumP  

  ! Silicate
  Denominator  = Hplus*(K1_Si+Hplus) + K1_Si*K2_Si
  !                H3SiO4-       + 2*H2SiO4--
  SiCharge     = (Hplus *K1_Si + 2.D0*K2_Si *K1_Si)                   &
                      /denominator                     * SumSi

  ! HS species
  HSCharge     = K_H2S/(K_H2S+HPlus)             * SumHS
        
  ! POSITIVE CHARGES (Ammonium, Hplus) are substracted
  ! Ammonium: NH4+
  AmmoniumCharge = - Hplus  /(K_NH4+Hplus)       * SumNHx
      
  ! to be added later if necessary 
  ! Sulphate : 2SO4-- + HSO4-
  !       SO4            = K_SO4_SWS/(K_SO4_SWS+HPlus) 
  !      HSO4           = 1.D0 - SO4
  !     SO4Charge      = -(2.D0*SO4 +HSO4  )

  ! Fluoride : F- 
  !    FCharge        = -K_F_SWS/(K_F_SWS+HPlus)   
        
  ! Negative Charge component (µmol/kg) not due to CO species 
  CalculateNonCOCharge   = BorateCharge + WaterCharge + PCharge &
 			 + NitrateCharge + AmmoniumCharge + SiCharge + HSCharge
                       ! + FCharge + SO4Charge    

#ifdef csystemcheck
  SiChargeout(ji,jj,jk)=SiCharge
  PChargeout(ji,jj,jk)=PCharge
  BorateChargeout(ji,jj,jk)=BorateCharge
  NitrateChargeout(ji,jj,jk)=NitrateCharge
  AmmoniumChargeout(ji,jj,jk)=AmmoniumCharge
  HSChargeout(ji,jj,jk)=HSCharge
#endif							 
   
 END FUNCTION CalculateNonCOCharge





 
!<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>!
!<<<                                            >>>!
!<<<                ION SPECIATION              >>>!
!<<<                                            >>>!
!<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>!

!************************************************************!
! Concentration of dissolved inorganic carbon species        !
!************************************************************!
SUBROUTINE CalculateCO2Species(HCO3,CO3,CO2)
! Before calling, the dissociation constants must have been calculated
  IMPLICIT NONE
  real(wp), INTENT(OUT) :: HCO3, CO3,CO2
  real(wp)  :: Denominator

  Denominator  = Hplus*(K1_CO2+Hplus) + K1_CO2*K2_CO2
  HCO3         = Hplus *K1_CO2/denominator * SumCO2
  CO3          = K2_CO2*K1_CO2/denominator * SumCO2
  CO2          = Hplus *HPlus /denominator * SumCO2

END SUBROUTINE CalculateCO2Species


!************************************************************!
! Concentration of dissolved inorganic carbon species        !
!************************************************************!
real(wp) FUNCTION CalculatepCO2(CO2,HenrysCt,temp,depth)
! Before calling, the solubility (Henrys constant must have been calculated)
  IMPLICIT NONE
  !real(wp) 			 :: refdensity
  real(wp), INTENT(IN)  :: CO2, HenrysCt, temp, depth
  real(wp):: 	fCO2,     &	!fugacity
				fugcoeff, &	!coefficient to transform fCO2 into pCO2
				R,        &	! (cm3 * atm) / (mol * K)  CODATA (2006)
				Ptot,	  &	! total pressure
				TK,		  &	! temperature in K
				A,B,C	 	! coefficients used to compute fugcoeff

  ! partial CO2 pressure is calculated based on the solubility equation
  ! CO2 in mmol/m3 or 10-6 mol/l
  !Denisty has to be given in kg/l-> so convert the model density in kg/m3 in kg/l by dividing by 1000
  ! K0, moles/kg/atm or µmoles/kg/µatm
  ! fCO2 and pCO2 (Calculate pCO2) in µatm
  
  !Old BAMHBI:
  ! CalculatepCO2= CO2/refdensity/HenrysCt 
  
  
  !Transform into partial pressure
  !Dickson (2007) Guide to best practices, using formulars from Weiss (1974):
  fCO2 = CO2/refdensity/HenrysCt !This is fugacity
  Ptot = (depth*refdensity/10)/ 1.01325 !Conversion of hydrostatic pressure from bar to atm; 
  Ptot = Ptot + 1.01325		! total pressure is hydrostatic pressure plus atmospheric pressure
  R = 82.05736              
  TK = temp + 273.15

  A  = -1636.75 + 12.0408*TK - 0.0327957*TK*TK + 0.0000316528*TK*TK*TK
  B  = 57.7-0.118*TK
  C  = (1 - fCO2*10**(-6))**2

  fugcoeff = EXP( Ptot*(A + 2*B*C)/(82.057*TK) )

  CalculatepCO2 = fCO2/fugcoeff

END FUNCTION CalculatepCO2


!************************************************************!
! Total concentration of species contributing to alkalinity  !
!************************************************************!
SUBROUTINE CalculateTotalConcentration(ji,jj,jk,kbb,kmm)
  IMPLICIT NONE
  INTEGER, INTENT (IN) :: ji,jj,jk, kbb, kmm
   
  !====================!
  ! alkalinity SPECIES !
  !====================!
  ! The concentrations of the actors, µmol/l

  ! 1. BORATE - estimated based on salinity - Archer (!)
  ! (mol/kg) - convert to µmol/l
  !      SumBorate = 4.106e-4 * Salinity(i) / 35.  !Archer formula
      
  SumBorate       = 4.106e2 * ts(ji,jj,jk,jp_sal,kmm) / 35 *refdensity  ! µmol/kg
  !CDIAC: SumBorate = 0.00001188*tsb(ji,jj,jk,jp_sal) 
  SumNHx          = tr(ji,jj,jk,NHS,Kbb)!/refdensity    		  ! µmol/kg
  SumNit          = tr(ji,jj,jk,NOS,Kbb)!/refdensity    		  ! µmol/kg
  SumCO2          = tr(ji,jj,jk,DIC,Kbb)!/refdensity                      ! µmol/kg
  SumP            = tr(ji,jj,jk,PHO,Kbb)!/refdensity   		          ! µmol/kg
  SumSi           = tr(ji,jj,jk,SIO,Kbb)!/refdensity    		  ! µmol/kg
  SumHS           = tr(ji,jj,jk,ODU,Kbb)/2!/refdensity    	          ! µmol/kg

  TotalCharge     = tr(ji,jj,jk,CHA,Kbb)!/refdensity		 	  ! µmol/kg
  Hplus           = 10**(-pHB(ji,jj,jk))                             ! Hplus is in mol/kg

#ifdef csystemcheck
  SumCO2_out(ji,jj,jk)=SumCO2  
  SumPout(ji,jj,jk)   =SumP 
  SumSiout(ji,jj,jk)=SumSi
  SumNHxout(ji,jj,jk)=SumNHx
  SumNitout(ji,jj,jk)=SumNit
  SumBorateout(ji,jj,jk)= SumBorate 
  SumHSout(ji,jj,jk)=SumHS
  Hplusout(ji,jj,jk)=Hplus
#endif  
  
	  
END SUBROUTINE CalculateTotalConcentration      


!**********************************************************************
   real(wp) FUNCTION CalculateCalcite (Density,Salinity)
!-------------------------------------------------------------------------
!  The calcite concentration, µmol/l
!-------------------------------------------------------------------------

   IMPLICIT NONE
   real(wp), INTENT(IN) :: Density,Salinity
   real(wp), PARAMETER  :: calcon = 1.03D4

   !calcon=mean calcite concentration [Ca2+] in sea water [mole/kg solution] 
   !(see broecker a.peng 1982 p26)  
   !([Ca2+](mol/kg)=1.026e-2*(s/35) after Culkin 1965),cf broecker et al. 1982)


   !TOTAL CALCIUM CONCENTRATION [µmol/l]
   ! --------------------------------------
   !calcon2 = calcon*density
   !or from Millero 1995 [µmol/l]
    CalculateCalcite=0.01028D6*(salinity/35.D0)*density

   END FUNCTION CalculateCalcite

!************************************************************!

   
   real(wp) FUNCTION CalculateSulphate (Density,Salinity)
!-------------------------------------------------------------------------
! The Sulphate concentration, µmol/l 
! (Morris & Riley 1966-Deep-Sea Res. 13:699-705)
! If density = 1, then concentration in µmol/kg
!-------------------------------------------------------------------------
   IMPLICIT NONE

   real(wp), INTENT(IN) :: Density,Salinity

   real(wp), PARAMETER :: st1 = 0.14D6
   real(wp), PARAMETER :: st2 = 1.D0/96.062D0

   real(wp), PARAMETER :: salchl = 1.D0/1.80655
   real(wp)            :: Cl
!-------------------------------------------------------------------------

      !Chlorinity (WOOSTER ET AL., 1969)
      cl = salinity*salchl
    
      CalculateSulphate = st1*cl*st2*Density
   
   END FUNCTION CalculateSulphate

!************************************************************!

   real(wp) FUNCTION CalculateFluoride (Density,Salinity)
   IMPLICIT NONE
!-------------------------------------------------------------------------
! The fluoride concentration, µmol/l 
! (Riley 1965 - Deep-Sea Res. 12:219-220)
! If density = 1, then concentration in µmol/kg
!-------------------------------------------------------------------------
   real(wp), INTENT(IN) :: Density,Salinity

   real(wp), PARAMETER :: ft1=0.000067D6
   real(wp), PARAMETER :: ft2=1.D0/18.9984D0
   real(wp), PARAMETER :: salchl = 1.D0/1.80655
   real(wp)            :: Cl

      !Chlorinity (WOOSTER ET AL., 1969)
      cl = salinity*salchl
      CalculateFluoride  = ft1*cl*ft2*Density

   END FUNCTION CalculateFluoride 
   
!*******************************************************************   

!**********************************************************!
!	Solubility of CO2 in seawater
!**********************************************************!

   real(wp) FUNCTION CalculateHenrysCt(Temp, S)

!-----------------------------------------------------------------
! Henry's law constant for seawater, K0, moles/kg/atm - Millero
!-----------------------------------------------------------------

   IMPLICIT NONE

   real(wp), INTENT(IN) :: Temp,   & ! Temperature, dgC
                                   S         ! Salinity, PSU

   real(wp)  :: T,LnK

      ! Temperature in dg Kelvin
      T = Temp + 273.15
      
! According to Millero (1995), Thermodynamics of the carbon dioxide system in the oceans
! Geochem & Cosmochem Acta, Vol 59, no 4, pp 661-677 (Attention typos!; documented in Lewis and
! Wallace CO2SYS documentation (CDIAC website)

! (remark, in FORTRAN LOG is neperian logarithm !)

      lnK = -60.2409 + 9345.17/T                           &
            +23.3585* LOG(T/100) +                        &
            S*( 0.023517-2.3656e-4*T+4.7036e-7*T*T  )
            
!-----------AquaEnv
		!lnK = 0.023517*S - 167.81077 + 9345.17/T +23.3585*LOG(T) &
		!		-0.00023656*S*T+4.7036*10**(-7)*S*T*T
            
      
      CalculateHenrysCt = EXP(lnK)

   END FUNCTION CalculateHenrysCt
!**********************************************************!
!        THE DISSOCIATION ... CONSTANTS  version 2         !
!**********************************************************!
 
   SUBROUTINE Thermo_2 (temp,S,Depth,refdensity,ji,jj,jk)
!-----------------------------------------------------------------
! Calculates the thermodynamic constants, 
! (dissociation cts, solubility products) in
! seawater at temperature (T, in deg C), salinity (S, in PSU), 
! and pressure (P, in atm) conditions.  
! The  calculated constants are on the SWS pH scale.
!
! K_H2O    = dissociation constant of H2O
! K1_CO2   = 1st dissociation constant of CO2(aq)
! K2_CO2   = 2nd dissociation constant of CO2(aq)
! K_BOH3   = dissociation constant of B(OH)3
! K1_H3PO4 = 1st dissociation constant of H2PO4
! K2_H3PO4 = 2nd dissociation constant of H3PO4
! K3_H3PO4 = 3nd dissociation constant of H3PO4
! K_HNO3   = dissociation constant of HNO3
! K_NH4    = dissociation constant of NH4
! K_H2S    = 1st dissociation constant of H2S
! 
! Also calculates ionic strength, of the solution (mol/kg-solution)
!
! SLIGHTLY DIFFERENT FROM Thermo 
!-----------------------------------------------------------------
   IMPLICIT NONE
   real(wp), INTENT(IN) :: 	temp,      &   ! Temperature, dgC
                                S,         &   ! Salinity, PSU
                                Depth,     &   ! metres
                                refdensity     !kg/L

   real(wp)  :: T,P,R,lnK,lnKp,IM,DeltaV,DeltaK,g,lat
   real(wp)  :: pK0, pK, A, B, C, Io, Ki0, total2SWS, total2free, free2SWS  
   !	working variables for constants before pressure correction and
   !	conversions between scales
   real(wp)     :: Cl, ST, FT !Chlorinity, total Sulfates, total Fluoride
   Integer	:: ji,jj,jk

   ! Temperature in Kelvin
   T = temp + 273.15

   ! P is applied pressure (in Bars) = (Total Pressure-1)
   P = depth*refdensity/10
   !AquaEnv approx
   !lat=43
   !g = 9.780318*(1+(0.0052788+2.36*10**(-5)*SIN(lat*3.141592/180))*SIN(lat*3.141592/180))
   !P = 1000*refdensity*depth*g*10**(-5)

   R = 83.144598		!bar-cm3/mol-K
   !AquaEnv uses R = 83.14472
      		
#ifdef csystemcheck
   temperatureout(ji,jj,jk)=temp
#endif



   !==============================================!
   ! apparent thermodynamic EQUILIBRIUM CONSTANTS !
   !==============================================!
   !  Ionic strength (Lyman and Fleming, 1940)
   !  (in units of mol kg-water).
   IM            = 0.00147 + 0.019885*S + 0.000038*S*S
   IonicStrength = IM*(1.0-S/1000.0)
   !---- Dickson (2007) Guide to best practices:
   Io  = 19.924*S/(1000-1.005*S)
	  
   !==========! The dissociation constants are on the Seawater Scale=====!	
   !					(if nothing else is specified)

   !Be aware of differences in the formulations of Millero 1995: (lnK -> K=EXp(lnk)) 
   !vs later formulations (e.g. Millero 2006 or 2010): (pk -> K= 10**(-pK))

   !Be aware of 'per kgH2O' vs 'per kg solution'

   ! The pressure corrections proposed by Millero (1995) are valid on the SWS scale
   ! if the constants are computed on another scale, they must be converted to SWS
   ! scale before the pressure correction can be applied

   !======================================================================!
   !------------------------------------------------
   !Calculate of conversion factors between scales     
   !------------------------------------------------
   ! Dissociation of hydrogen sulfate  
   ! KHSO4 
   ! Dickson (1990 and 2007)
   ! the term log(1-0.001005*S) converts from  mol/kg H2O to mol/kg soln
   ! free scale
   ! needed to calculate scale conversion factor at zero pressure
      
   lnK = -4276.1/T + 141.328 - 23.093*LOG(T)             &
			+(-13856/T + 324.57 - 47.986*LOG(T))*SQRT(Io)&
			+(35474/T - 771.54 + 114.723*LOG(T))*Io      &
			-(2698/T)*SQRT(Io)*Io + (1776/T)*Io*Io       &
			+LOG(1-0.001005*S)
        
   !--------AquaEnv
   ! per mol H2O
		
   !lnk = -4276.1/T + 141.328 - 23.093*LOG(T)          &
   !		+(-13856/T + 324.57 - 47.986*LOG(T))*SQRT(Io)&
   !		+(35474/T - 771.54 + 114.723*LOG(T))*Io      &
   !		-(2698/T)*SQRT(Io)*Io + (1776/T)*Io*Io       
		
   K_HSO4 = EXP(lnK) 

   !Pressure Correction
   !		DeltaV = -18.03 + 0.0466*temp + 0.000316*temp*temp
   !		DeltaK = -4.53 + 0.0900*temp
   !		DeltaK = DeltaK/1000
      
   !       lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + lnK 

   !       K_HSO4 = EXP(lnKp)  


   !----------------
   ! Dissociation hydrogen fluoride 
   ! K_HF

   ! Perez and Fraga, 1987 in Guide to the Best Practices for Ocean CO2 Measurements
   ! Dickson, Sabine and Christian (2007) Chapter 5, p.14
   ! Total Scale; S: 10-40, T: 9-33
		
   !		lnk = 874/T - 9.68 + 0.111*SQRT(S)
		
   !		K_HF  = EXP(lnk)

   ! Dickson and Riley, (1979) in Dickson and Goyet (1994), Chapter 5, p. 14
   ! pH-scale: 'free'  S: 0-45, T: 0-45
   ! needed to calculate scale conversion factor at zero pressure

   lnK = 1590.2/T - 12.641 + 1.525*SQRT(Io) + LOG(1-0.001005*S)
   !--------AquaEnv
   ! per mol H2O
   !lnk = 1590.2/T - 12.641 + 1.525*SQRT(Io)
				
   K_HF  = EXP(lnK)
		
   !Pressure Correction
   !DeltaV = -9.78 + (-0.0090*temp) + (-0.000942*(temp**2))
   !DeltaK = -0.00391 + 0.0000540*temp 

   !lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + LOG(Ki0)
   !lnkp=lnk
   !K_HF = EXP(lnKp) 
      
   !-------------------------------------
   !Calculation of the conversion factors
   !-------------------------------------
      
   Cl = S / 1.80655              	! Cl = chlorinity; S = salinity (per mille)
   ST = 0.14 * Cl/96.062        		! (mol/kg) total sulfate  (Dickson et al., 2007, Table 2)
   FT = 6.7e-5 * Cl/18.9984      	! (mol/kg) total fluoride (Dickson et al., 2007, Table 2)
   total2free  = 1/(1+ST/K_HSO4)     ! Kfree = Ktotal*total2free, converts from total scale to free  
   free2SWS  = 1+ST/K_HSO4+FT/K_HF   ! converts from Free scale to Seawater scale (SWS)      
   total2SWS = total2free * free2SWS ! converts from Total scale to SWS


   !------------------------------------------
   ! Dissociation of carbonic acid constants -
   !------------------------------------------
   ! K1_CO2  (CO3-- -> HCO3-)
   !-----Millero (1995) GCA
   !lnK = 2.83655 - 2307.1266/T -1.5529413 * LOG(T)  &
   !     + (-0.20760841 - 4.0484/T) * SQRT(S)        &
   !     + 0.08468345 * S - 0.00654208 * (S**1.5)
      
   !-----Millero (2006) Marine Chemistry; AquaEnv
   !pK0 = -126.34048 + 6320.813/T + 19.568224*LOG(T)
   !A = 13.4191*SQRT(S) + 0.0331*S - (5.33e-5)*S*S
   !B = -530.123*SQRT(S)-6.103*S
   !C = -2.06950*SQRT(S)
        
   !-----Millero (2010) Marine Freshwater Research
   !pKi-pKi0 = Ai + Bi/T +CilnT
   pK0 = -126.34048 + 6320.813/T +19.568224*LOG(T)
   A = 13.4038*SQRT(S) + 0.03206*S - (5.242e-5)*S*S
   B = -530.659*SQRT(S)-5.8210*S
   C = -2.0664*SQRT(S)
     
   pK = A + B/T + C*LOG(T) + pK0
     
   Ki0 =  10**(-pK)
     
   !Pressure Correction from Morse and Mackenzie 1990
   !DeltaV = 21.07 + (0.1850*temp-(0.002248*(temp**2)))
   !DeltaK = -0.00530 + (0.1310*temp- 1.160e-06*(temp**2))
      
   ! Pressure Correction from Millero 1995  
   ! Incl.typo corrections from Lewis & Wallace (CO2SYS)   
      
   DeltaV = -25.5 + (0.1271*temp)
   !DeltaK = -3.08 + (0.877*temp) !Millero: b1 = 0.0877
   DeltaK = -0.00308 + 0.0000877*temp
   !DeltaK = DeltaK/1000
   !ln(KP/K0)=-(DeltaV/RT)P+(0.5DeltaK/RT)P**2  
     
   lnKp = (-(DeltaV/(R*T))*P + (0.5*(DeltaK/(R*T)))*(P**2)) + LOG(Ki0)
   K1_CO2 = EXP(lnKp)
   !lnkp=lnk
   !AquaEnv formulation:
   !K1_CO2 = Ki0*(-(DeltaV/(R*T)*P) + (DeltaK/(R*T))*0.5*P**2)
      
      
   !-------------------------     
   ! K2_CO2   (HCO3- -> CO2)
   !-----Millero (1995),GCA
   !lnK = -9.226508 - 3351.6106/T - 0.2005743* LOG(T)  &
   !      + (-0.106901773 - 23.9722/T) * SQRT(S)       &
   !      + 0.1130822 * S - 0.00846934 * (S**1.5)
		
   !------Luecker (2000), Marine Chemistry (only valid for salinity  [19;45])
   !pK = 471.78/T + 25.9290 - 3.1696*LOG(T) - 0.01781*S + 0.0001122*S*S
   !Ki0 =  10**(-pK)
		      
   !----- Millero 2006, Marine Chemistry; AquaEnv
   !pK = 90.18333 - 0.1248*S + 0.0003687*S*S - 21.0894*SQRT(S) &
   !	+(-5143.692 + 20.051*S + 772.483 * SQRT(S))/T           &
   !	+(-14.613358 + 3.3336*SQRT(S))*LOG(T)
   !Ki0 =  10**(pK)
		
   !------Millero (2010) Marine Freshwater Research
   !pKi-pKi0 = Ai + Bi/T +CilnT
   pK0 = -90.1833 + 5143.692/T + 14.613358*LOG(T)
   A = 21.3728*SQRT(S) + 0.1218*S - 0.0003688*S*S
   B = -788.289*SQRT(S)-19.189*S
   C = -3.374*SQRT(S)
   pK = A + B/T + C*LOG(T) + pK0
   Ki0 =  10**(-pK)
      
   !Pressure Correction from Morse and Mackenzie 1990
   !DeltaV = -8.74 + 0.3*temp-0.004064*(temp**2)
   !DeltaK = -0.01104 +0.224*temp-3.056e-6*(temp**2) 
      
   ! Pressure Correction from Millero 1995 
   ! Incl.typo corrections from Lewis & Wallace (CO2SYS)     
   
   DeltaV = -15.82 - (0.0219*temp)
   !DeltaK = 1.13 - (0.1475*temp)	    
   !was DeltaK = 1.13 - (0.1475e-3*temp); different from Millero 95 
   !DeltaK = DeltaK/1000
   DeltaK = 0.00113 -0.0001475*temp 
      
   lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + LOG(Ki0) 
   !lnkp=lnk
   K2_CO2 = ExP(lnKp) 
   !alternative formulation
   !K2_CO2 = Ki0*(-(DeltaV/(R*T)*P) + (DeltaK/(R*T))*0.5*P**2)

   !----------------
   ! Dissociation of water in seawater
   ! KH2O

   lnK = 148.9802 - 13847.26/T - 23.6521*LOG(T)       &
            +(-5.977+118.67/T+1.0495 * LOG(T)) * SQRT(S) &
            - 0.01615*S
   !---------AuquaEnv
   !(approx) Total scale
   ! /kg soln
   !A = 148.9652-5.977*SQRT(S)-0.01615*S
   !B = -13847.26+118.67*SQRT(S)
   !C = -23.6521+1.0495*SQRT(S)
   !lnk = A + B/T + C*LOG(T)
   !Ki0 = EXP(lnk)
   !Conversion to SWS scale
   !Ki0 = Ki0*total2SWS

   !Pressure Correction from Millero 1995 (Freshwater! -> Millero 1983)
   !Millero: Influence of pressure on chemical processes in the sea.
   !Chapter 43. In J. P. Riley and R. Chester (eds.), 
   !Chemical Oceanography. Academic Press, New York (1983)
   !Typos from Lewis and Wallace (CO2SYS)
      
   DeltaV = -25.6 + (0.2324*temp) + (-0.0036246*(temp**2))
   DeltaK = -5.13 + (0.0794*temp)
   DeltaK = DeltaK/1000    
      
   ! Seacarb parametrisation; Orr et al.: Comparison of ten packages
   ! that compute ocean carbonate chemistry (2015) Biogeosciences,
   ! table 7; Values from Millero 1983 (Seawater)
   !DeltaV = -20.02 + 0.1119*temp-0.001409*temp*temp
   !DeltaK = -0.00513 + 0.0000794*temp
     
   !lnkp=lnk
   lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + lnK 
   K_H2O = EXP(lnKp) 
     
   !Aquaenv
   !K_H2O = Ki0*(-(DeltaV/(R*T)*P) + (DeltaK/(R*T))*0.5*P**2)
      

   !----------------
   ! Dissociation of ammonia in seawater
   ! K_NH4
   lnK = -6285.33/T+0.0001635*T-0.25444      &
         +(0.46532-123.7184/T)* SQRT(S)      &
         +(-0.01992+3.17556/T)*S
       
   !Ki0 = EXP(lnK)     

   !Pressure Correction from Millero 1995
   !Typos corrections from Lewis and Wallace (CO2SYS)
      
   DeltaV = -26.43 + (0.0889*temp) + (-0.000905*(temp**2))
   DeltaK = -0.00503+0.0000814*temp
   !DeltaK = -5.03 + (0.0814*temp)
   !DeltaK = DeltaK/1000    
      
   lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + lnK 
   !lnkp=lnk

   K_NH4 = EXP(lnKp) 
      
   !Aquaenv
   !K_NH4 = Ki0*(-(DeltaV/(R*T)*P) + (DeltaK/(R*T))*0.5*P**2)
   !---------------------------
   ! Dissociation of nitrate, a constant
   ! K_HNO3
   K_HNO3   = 23.44
      
          
   !----------------
   ! Dissociation of boric acid
   ! K_BOH3
   ! Dickson (1990)
   ! Typos corrected according to Dickson Best Practices (2007)
   ! Total scale

   lnK = (-8966.90 - 2890.53*SQRT(S) - 77.942*S           &
          +1.728*S**1.5 - 0.0996*S*S)/T                   &
          +(148.0248 + 137.1942*SQRT(S) + 1.62142*S)      &
          +(-24.4344 - 25.085 *SQRT(S) - 0.2474*S)*LOG(T) &
             + 0.053105*SQRT(S)*T 
             
   !need to convert to SWS scale before pressure correction       
   Ki0 = EXP(lnK)
   Ki0 = Ki0 * total2SWS
                                               
   !Pressure Correction (Millero 1995 formulation has a typo (a2 is -0.1622 instead of +))
   DeltaV = -29.48 + (0.1622*temp) + (0.002608*(temp**2))
   DeltaK = -2.84 
   DeltaK = DeltaK/1000    

   lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + LOG(Ki0)
   !lnkp=lnk
   K_BOH3 = EXP(lnKp) 
    
   !Aquaenv
   !K_BOH3 = Ki0*(-(DeltaV/(R*T)*P) + (DeltaK/(R*T))*0.5*P**2)

   !-----------------------------
   ! Dissociation of silicic acid
   !K1_Si (KSiOH4)

   !------Old BAMHBI formulation
   !K_Si = 4.E-10

   !----Yao & Millero (1995) Aquatic Geochemistry (SWS scale)
   lnK =  117.40 -8904.2 / T - 19.334 * LOG(T)    &
         + ( 3.5913 - 458.79 / T)   * SQRT(Io)    &
         + (- 1.5998 + 188.74 / T )    * Io       & 
         + ( 0.07871 - 12.1652 / T) *Io * Io      &
             + LOG(1.0 - 0.001005d0*s) 
             
   !LOG(1.0 - 0.001005d0*s) is a correction to convert from mol/(kg-H2O) to mol/kg soln
      
      
   !----AquaEnv (Total Scale)
   !lnK =  117.385 -8904.2 / T - 19.334 * LOG(T)    &
   !       + ( 3.5913 - 458.79 / T)   * SQRT(Io)    &
   !       + (- 1.5998 + 188.74 / T )    * Io       & 
   !       + ( 0.07871 - 12.1652 / T) *Io * Io    
      
   Ki0 = Exp(lnK)
   Ki0 = Ki0 * total2SWS
      
   !Pressure Correction - Assumed to be the same as Boric Acid (See Millero 1995 
   DeltaV = -29.48 + (0.1622*temp) + (-0.002608*(temp**2))
   DeltaK = -2.84 
   DeltaK = DeltaK/1000 
   !Delta V and Delta K estimated from values for boric acid   
      
   lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + LOG(Ki0) 
	  
   !lnkp=lnk
   K1_Si = EXP(lnKp) 
      
   !Aquaenv
   !K1_Si = Ki0*(-(DeltaV/(R*T)*P) + (DeltaK/(R*T))*0.5*P**2)

   ! K2_Si 
   !-----Wischmeyer 2003 formulation (pK2 is around 13.2), only for completeness
   lnK = 8.96 -4465.18/T + 0.021952*T
	  
   !Pressure correction for K2_Si (KSiOOH3) is supposed to be the same as 
   !for K1_Si 
	   
   lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + lnK
   K2_Si = EXP(lnKp)
	  
   !-----Old BAMHBI formulation
   ! a pressure corrected constant

   !DeltaV = -302.3724 - 0.050698*T + 15669.69/T + 108.18466*LOG(T) - 1119669/T/T
   !DeltaK = -294.0184 - 0.072650*T - 11204.49/T + 108.18466*LOG(T) - 1119669/T/T	  
   !K2_Si = EXP(lnk)
      
   !K2_Si = EXP(DeltaK)/EXP(DeltaV)/10**0.6073  

   !----------------------------------
   ! Dissociation of phosphoric acid
   ! K1_H3PO4 is included for completeness
       
   lnK = 115.54-4576.752/T-18.453*LOG(T)+(0.69171-106.736/T)*(S**0.5)     &
              +(-0.01844-0.65643/T)*S
       
   !----AquaEnv (Total Scale)
   !lnK =  115.525 + 0.69171*SQRT(S)-0.01844*S	&
   !	+(-456.752-106.736*SQRT(S)-0.65643*S)/T	&
   !	-18.453*LOG(T)
	   
	   
   !Pressure correction    
   DeltaV = -14.51 + (0.1211*temp) + (-0.000321*(temp**2))
   DeltaK = -2.67 + (0.0427*temp)
   DeltaK = DeltaK/1000    
      
      
   lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + lnK 
   !lnkp=lnk
   K1_H3PO4 = EXP(lnKp)  
      
   !Aquaenv
   !Ki0 = EXP(lnK)
   !Ki0 = Ki0 * total2SWS
   !K1_H3PO4 = Ki0*(-(DeltaV/(R*T)*P) + (DeltaK/(R*T))*0.5*P**2)                        

   ! K2_H3PO4
   lnK = 172.1033-8814.715/T-27.927*LOG(T)+(1.3566-160.340/T)*(S**0.5)    &
	       +(-0.05778+0.37335/T)*S

   !----AquaEnv (Total Scale)
   !lnK = 172.0883-8814.715/T-27.927*LOG(T)+(1.3566-160.340/T)*(S**0.5)    &
   !    +(-0.05778+0.37335/T)*S
   
   !Pressure Correction 
   DeltaV = -23.12 + (0.1758*temp) + (-0.002647*(temp**2))
   DeltaK = -5.15 + (0.09*temp)
   DeltaK = DeltaK/1000    
      
   lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + lnK 
   !lnkp=lnk
   K2_H3PO4 = EXP(lnKp)
      
   !Aquaenv
   !Ki0 = EXP(lnK)
   !Ki0 = Ki0 * total2SWS
   !K1_H3PO4 = Ki0*(-(DeltaV/(R*T)*P) + (DeltaK/(R*T))*0.5*P**2)    

    ! K3_H3PO4
    lnK = -18.126-3070.75/T+(2.81197+17.27039/T)*(S**0.5)     &
	        +(-0.09984-44.99486/T)*S
    !----AquaEnv (Total Scale)
    !lnK = -18.141-3070.75/T+(2.81197+17.27039/T)*(S**0.5)     &
    !    +(-0.09984-44.99486/T)*S

     !Pressure Correction
     DeltaV = -26.57 + (0.2020*temp) + (-0.003042*(temp**2))
     DeltaK = -4.08 + (0.0714*temp)
     DeltaK = DeltaK/1000    
     
     lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + lnK 
     !lnkp=lnk
     K3_H3PO4 = EXP(lnKp) 
      
     !Aquaenv
     !Ki0 = EXP(lnK)
     !Ki0 = Ki0 * total2SWS
     !K1_H3PO4 = Ki0*(-(DeltaV/(R*T)*P) + (DeltaK/(R*T))*0.5*P**2)   

     !---------------------------------------
     !Dissociation of hydrogen sulfide (H2S)
     ! Total scale

     lnK = 225.838-13275.3/T-34.6435*LOG(T)+0.3449*(S**0.5)-0.0274*S 
      
     ! Converstion to SWS scale before pressure correction
     Ki0 = EXP(lnK)
     Ki0 = Ki0 * total2SWS

     !Pressure correction

     DeltaV = -14.8 + (0.0020*temp) + (-0.0004*(temp**2))
     DeltaK = 2.89 + (0.054*temp)
     DeltaK = DeltaK/1000    
      
     lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + LOG(Ki0) 

     K_H2S = EXP(lnKp)  
      
     !Aquaenv
     !Ki0 = EXP(lnK)
     !K1_H3PO4 = Ki0*(-(DeltaV/(R*T)*P) + (DeltaK/(R*T))*0.5*P**2)
      
#ifdef csystemcheck
     K1CO2out(ji,jj,jk)	=K1_CO2  
     K2CO2out(ji,jj,jk)	=K2_CO2
     K_H2Oout(ji,jj,jk)	=K_H2O
     KBOH3out(ji,jj,jk)	=K_BOH3
     K1H3PO4out(ji,jj,jk)	=K1_H3PO4
     K2H3PO4out(ji,jj,jk)	=K2_H3PO4
     K3H3PO4out(ji,jj,jk)	=K3_H3PO4
     KHNO3out(ji,jj,jk)	=K_HNO3
     KNH4out(ji,jj,jk)	=K_NH4
     KHNO2out(ji,jj,jk)	=K_HNO2
     KH2Sout(ji,jj,jk)	=K_H2S
     KSiout(ji,jj,jk)	=K1_Si
#endif  


   END SUBROUTINE Thermo_2


   
!**********************************************************!

   SUBROUTINE Thermo_2_Calcite (Temp,S,Depth)
!-----------------------------------------------------------------
! K_Aragonite = solubility product of CaCO3 (Aragonite)
! K_Calcite   = solubility product of CaCO3 (Calcite)
! Values at 1 atm from Mucci (1983) fitted by Millero 1995
!
! SLIGHTLY DIFFERENT FROM Thermo_Calcite 
!  Given in terms of log10 !!!!!
!-----------------------------------------------------------------
                          
   IMPLICIT NONE

   real(wp), INTENT(IN) :: Temp,   & ! Temperature, dgC
                                   S,      & ! Salinity, PSU
                                   Depth     ! metres

   real(wp)  :: T,P,R,LnK,LogK,LogKp,K,A,B,DeltaV,DeltaK

      ! Temperature in dg Kelvin
      T = Temp + 273.15

      ! P is applied pressure (in Bars) = (Total Pressure-1)
      P = 0.1*depth*1.01326

      R = 83.145

      !CALCITE
      logK = -171.9065 - (0.077993*T) + (2839.319/T)                              &
            + 71.595*LOG10(T) + (-0.77712 + (0.0028426*T) + (178.34/T))*SQRT(S)   &
            - 0.07711*S + (0.0041249*(S**1.5)) 
      
      K  = 10.D0**logK
      lnk = log(K)
        
     !Pressure Correction

     ! Ingle 1975 
      
      A = (48.8-0.53*(temp))*(P*10-10)/10 
      B = ((-5.88e-3+1.845e-4*(temp))*(P*10-10)**2)/100
      
      logKp = logK + ((A+B)/(188.93*T))
      
      K_Calcite = 10**logKp
      
      !Millero 1995 with typo corrections from Lewis and Wallace (CO2SYS)
     
      !DeltaV = 48.76 + (-0.5304*temp) 
      !DeltaK = 11.76 + (- 0.3692*temp)
      !DeltaK = DeltaK/1000       
      
      
      !lnKp = (-(DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + lnK 

      !KCa = exp(lnKp) 
      !NB: KCa is the stoichiometric solubility constant for calcite  

      !ARAGONITE
      logK = -171.945 - 0.077993*T + (2903.293/T)                                  &
            + 71.595*LOG10(T) + (-0.068393 + (0.0017276*T) + (88.135/T))*SQRT(S)   &
            - (0.10018*S) + (0.0059415*S**1.5) 

      !Pressure Correction 
      !From Millero 1995 with typos from Lewis and Wallace (CO2SYS)

      DeltaV = -46 + (0.5304*temp) 
      DeltaK = -11.76 + (-0.3692*temp)
      DeltaK = DeltaK/1000    
      
      logKp = ((-DeltaV/(R*T))*P + (0.5*DeltaK/(R*T))*(P**2)) + logK 

      K_Aragonite = 10**logKp 

    END SUBROUTINE Thermo_2_Calcite
    
!   ===================================================================================================
 


!**********************************************************!
!   THE DISSOCIATION CONSTANTS OF fluoride and sulfate     !
!**********************************************************!

    SUBROUTINE Diss_Minor (Temperature, Salinity,DensitySW)

    !-----------------------------------------------------------------
    ! Calculates the thermodynamic constants of fluoride and sulphate, 
    ! in seawater at temperature (T, in deg C), salinity (S, in PSU), 
    ! and pressure (P, in atm) conditions.  
    ! The  calculated constants are on the free pH scale.
    ! Original implementation: Christoph Heinze
    !-----------------------------------------------------------------
    IMPLICIT NONE
    real(wp), INTENT(IN) :: Temperature,Salinity,DensitySW
    
    ! local declarations
    !==================
    real(wp) :: tkel,sal,zsqrt,sal15,zlogt,ztr,zis2,zisqrt,K_F_Free_ref

    ! Dissociation of sulfates
    !(Dickson 1990 change to mol/kg soln, idem OCEMIP)
    real(wp), PARAMETER :: ks0=141.328D0
    real(wp), PARAMETER :: ks1=-4276.1D0
    real(wp), PARAMETER :: ks2=-23.093D0
    real(wp), PARAMETER :: ks3=-13856D0
    real(wp), PARAMETER :: ks4=324.57D0
    real(wp), PARAMETER :: ks5=-47.986D0 !According to Lewis & Wallace 
    !CO2SYS documentation should be +114.723, here the value of ks8?
    real(wp), PARAMETER :: ks6=35474D0
    real(wp), PARAMETER :: ks7=-771.54D0
    real(wp), PARAMETER :: ks8=114.723D0
    real(wp), PARAMETER :: ks9=-2698D0
    real(wp), PARAMETER :: ks10=1776D0
    real(wp), PARAMETER :: ks11=1.D0
    real(wp), PARAMETER :: ks12=-0.001005D0

    !fluorides (Dickson & Riley 1979 change to mol/kg soln)
    real(wp), PARAMETER :: kf0=-12.641D0
    real(wp), PARAMETER :: kf1=1590.2D0
    real(wp), PARAMETER :: kf2=1.525D0
    real(wp), PARAMETER :: kf3=1.0D0
    real(wp), PARAMETER :: kf4=-0.001005D0

    ! conversion factor for salinity ---> chlorinity (Wooster et al. 1969)
    real(wp), PARAMETER :: salchl = 1.D0/1.80655

    ! Set constants to calculate concentrations for sulfate and fluoride
    !sulfates (Morris & Riley 1966)
    real(wp), PARAMETER :: st1 = 0.14D0
    real(wp), PARAMETER :: st2 = 1.D0/96.062D0
    !fluoride
    real(wp), PARAMETER :: ft1=0.000067D0
    real(wp), PARAMETER :: ft2=1.D0/18.9984

    real(wp)::FreeToSWS, freetotot, K_F_Free, K_SO4_Free, SumF, Sumfmol, SumSO4mol, swstofree, swstotot 

    !------------------------------
    ! constants on SWS 
    ! kSScale = pHscaleFree			!seems not to be used
    tkel   = Temperature+273.16D0
    sal    = salinity
    zsqrt  = sqrt(sal)
    sal15  = zsqrt*sal
    zlogt  = log(tkel)
    ztr    = 1.D0/tkel

    ! ionic strength (ORNL/CDIAC-74, DOE 94,Dickson and Goyet)
    IonicStrength    = 19.924D0*sal/(1000.D0-1.005D0*sal)
    zis2             = IonicStrength*IonicStrength
    zisqrt           = sqrt(IonicStrength)

    !DISSOCIATION CONSTANT FOR SULFATES
    !on free H scale (dickson 1990)
    K_SO4_Free=exp(ks1*ztr+ks0+ks2*zlogt+(ks3*ztr+ks4+ks5*zlogt)*zisqrt+&
               (ks6*ztr+ks7+ks8*zlogt)*IonicStrength                   +&
               ks9*ztr*IonicStrength*zisqrt+ks10*ztr*zis2              +&
               log(ks11+ks12*sal))

    !DISSOCIATION CONSTANT FOR FLUORIDES
    !on free H scale (dickson and Riley 79
    K_F_Free  =exp(kf1*ztr+kf0+kf2*zisqrt+log(kf3+kf4*sal))

    ! Conversion to the SWS scale: chlorinity, total sulfate and fluoride conc
    
    ! SumSO4 is in µmol/l; convert to mmol/kg
	!IF (SO4SalinityFun) THEN
      SumSO4mol = st1*sal*salchl*st2
    ! SumSO4    = SumSO4mol *1.D6  * DensitySW 
    !ELSE
      !SumSO4mol = SumSO4   * 1.D-6 / DensitySW
    !ENDIF
    
    !Is FSalinityFun a flag that we should introduce somewhere?
    !IF (FSalinityFun) THEN
    SumFmol   = ft1*sal*salchl*ft2   ! Mol/kg
    SumF      = SumFmol *1.D6  * DensitySW 
    !ELSE
    !  SumFmol   = SumF * 1.D-6   / DensitySW  ! SumF in µmol/l
    !ENDIF

    FreeToSWS = 1.D0 + SumSO4mol/K_SO4_Free+SumFmol/K_F_Free
    SWSToFree = 1.D0 / FreeToSWS
    FreeToTot = 1.D0 + SumSO4mol/K_SO4_Free
    SWSToTot  =  FreeToTot/ FreeToSWS

    K_SO4_SWS = K_SO4_Free/SWSToFree
    K_F_SWS   = K_F_Free  /SWSToFree

    ! Temperature and salinity correction for fluoride - used to correct nitrite !
    ! the dissociation constant of nitrite is for freshwater, temperature 25     !
    IF (Temperature == 25 .AND. Salinity == 0) THEN
      K_HNO2 = 0.450000E-005   !  MOL/KG  Dissociation ct of nitrite- freshwater, temp 25
    ELSE
      ztr    = 1.D0/(25.D0+273.16D0)
      !Dissociation ct for fluoride at salinity 0, temperature 25, on free H scale 
      K_F_Free_ref  =exp(kf1*ztr+kf0+log(kf3))
      !Scaling dissociation ct of nitrite
      K_HNO2 = 0.450000E-005  * K_F_Free/K_F_Free_ref
    ENDIF

    END SUBROUTINE Diss_Minor



!   ===================================================================================================
!   ph_init_equation ( x = sigma = density anomaly = density - 1000 )
!   At the first time step, initialize pH by an empirical fit pH(sigma)
!   ===================================================================================================    
    function ph_init_equation(x)
    real(wp), intent(in) :: x   ! density (modulo 1000)                                                                                                                                                                                                                     
    real(wp), parameter :: a0 = -1.095398284451007e+05
    real(wp), parameter :: a1 = 5.377705401898281e+04
    real(wp), parameter :: a2 = -1.125446415779943e+04
    real(wp), parameter :: a3 = 1.301544949013496e+03
    real(wp), parameter :: a4 = -8.982456217036956e+01
    real(wp), parameter :: a5 = 3.699221597901133e+00
    real(wp), parameter :: a6 = -8.417171615456528e-02
    real(wp), parameter :: a7 = 8.163002862358586e-04

    pH_init_equation = a0+a1*x+a2*x**2+a3*x**3+a4*x**4+a5*x**5+a6*x**6+a7*x**7
      if (x.lt.12) ph_init_equation=8.3
      if (x.gt.17) ph_init_equation=7.6
    end function ph_init_equation


#endif
end module bamhbi_alkalinity
