classdef CheckMaxVersionTest < matlab.unittest.TestCase
    %CheckMaxVersionTest Test checkMaxVersion
    
    properties (TestParameter)
        Test = {"R2018a",   ...
                "R2018b",   ...
                "R2020a",   ...
                "R2020b",   ...
                "R2021a",   ...
                "R2021b"}
        Expected = {"R2020a",   ...
                    "R2020b",   ...
                    "R2020a",   ...
                    "R2020b",   ...
                    "R2020a",   ...
                    "R2020a"}
        Result = {true,   ...
                  true,   ...
                  true,   ...
                  true,   ...
                  false,   ...
                  false}
    end
    
    methods (Test, ParameterCombination = 'sequential')
        
        function testCheckMaxVersion(testCase, Test, Expected, Result)
            out = checkMaxVersion(Test, Expected);
            testCase.verifyEqual(out, Result);
        end
        
    end
    
end
