---
name: Theory or implementation clarification
about: 'Ask for clarification if after reviewing WEC-Sim documentation questions remain
  on theory or implementation '
title: "[Theory or Implementation]"
labels: ''
assignees: ''

---

**The development team requests that before submitting a question on the theory and implementation behind WEC-Sim to first please:**
1. Read through our [WEC-Sim Documentation](http://wec-sim.github.io/WEC-Sim/man/theory.html) with additional description found in our [Advanced Features Section](http://wec-sim.github.io/WEC-Sim/man/advanced_features.html)
1. Review MATLAB source code ([functions](https://github.com/WEC-Sim/WEC-Sim/tree/main/source/functions), [objects](https://github.com/WEC-Sim/WEC-Sim/tree/main/source/objects)) and the Simulink blocks ([libraries](https://github.com/WEC-Sim/WEC-Sim/tree/main/source/lib))
1. Review the curated [WEC-Sim Examples](https://github.com/WEC-Sim/WEC-Sim/tree/main/examples) and the [WEC-Sim applications](https://github.com/WEC-Sim/WEC-Sim_Applications)
1. Review the [WEC-Sim issues page](https://github.com/WEC-Sim/WEC-Sim/issues) which allows you to search past resolved issues or questions that might help answer your own question.

**Note: italicized text below is include as an example and should be updated before submission. If you feel any section is not applicable to your request, please replace with 'N/A' rather than delete a section.**

**Is your question request related to a problem? Please describe.**
_A clear and concise description of what the problem is. Ex. I do not understand why I get 'X' result when running 'Y' simulation [...]_

**Describe the theory or implementation approach that you have a question**
_Please clearly describe the assumptions, equations, or code script that you would like clarification. Also, please provide references to other research papers, open-source material, or other information that may be relevant in the WEC-Sim developers understanding your question._

**Personal project context**
_If this request is related to your project, please describe what you are attempting to do in your project so the WEC-Sim development team knows your end goal._

**Describe the type of conclusion or resolution you are looking for**
_[Ex.] I am still unclear on how an irregular wave train is generated within WEC-Sim and would appreciate being pointed to where in the documentation and code where I can find additional information._

**Additional context**
_Add any other context or screenshots about the feature request here._
