% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apl.R
\name{permutation_cutoff}
\alias{permutation_cutoff}
\title{Calculates permuted association plot coordinates}
\usage{
permutation_cutoff(
  caobj,
  counts,
  group = caobj@group,
  dims = caobj@dims,
  apl_cutoff_reps = 10,
  python = TRUE,
  axis = "cols"
)
}
\arguments{
\item{caobj}{A cacomp object.}

\item{counts}{The original count matrix that was used to compute the caobj.}

\item{group}{A vector of group indices.}

\item{dims}{The number of dimensions to when performing SVD.
Usually can be kept as \code{caobj@dims}.}

\item{apl_cutoff_reps}{The number of repetitions to use.
Should be between 3-10 for permutation, and >=100 for random.}

\item{python}{If TRUE, use python for CA SVD.}

\item{axis}{The axis for which the cutoff should be calculated, either "cols" or "rows".}
}
\value{
List with permuted apl coordinates ("apl_perm") and, a list of saved ca
components ("saved_ca") that allow for quick recomputation of the CA results.
For random_direction_cutoff this saved_ca is empty.
}
\description{
Calculates matrix of apl coordinates when permuting the original data.
}
