% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_apl.R
\name{.cluster_apl_points}
\alias{.cluster_apl_points}
\title{Creates ggplot for a cluster association plot}
\usage{
.cluster_apl_points(
  ggplt,
  plot_df,
  point_size = 1.5,
  size_factor = 1,
  highlight_cluster = FALSE,
  label_genes = FALSE,
  ntop = 15
)
}
\arguments{
\item{ggplt}{A ggplot2 object. It should be the result of ggplot() with
aes() defined but without any geoms_*.}

\item{plot_df}{The plotting data frame.}

\item{point_size}{Size of the points (cells).}

\item{size_factor}{Factor by which the genes are
larger/smaller than \code{point_size}.}

\item{highlight_cluster}{If TRUE, highlights the points in belonging to
\code{cluster}, unless colour_by_group is TRUE.}

\item{label_genes}{If TRUE, adds text labels for the
\code{ntop} genes per cluster.}

\item{ntop}{Number of genes to label if \code{label_genes = TRUE}.}
}
\value{
A ggplot object. The basic cluster APL plot.
}
\description{
Creates ggplot for a cluster association plot
}
