% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitmerge.R
\name{dirclust_splitmerge}
\alias{dirclust_splitmerge}
\title{Perform Clustering by CA directions with splitting and merging.}
\usage{
dirclust_splitmerge(
  caobj,
  k,
  cutoff = NULL,
  qcutoff = 0.8,
  method = "random",
  counts = NULL,
  apl_quant = 0.99,
  min_cells = 5,
  epochs = NULL,
  reps = NULL,
  apl_cutoff_reps = 100,
  make_plots = FALSE,
  convergence_thr = 0.001,
  max_iter = 50,
  init = "kmeanspp"
)
}
\arguments{
\item{caobj}{A \code{caclust} object.}

\item{k}{Number of clusters.}

\item{cutoff}{Degrees. The cutoff angle to split and merge clusters.
If \code{NULL} the cutoff angle is calculated based on the cutoff angle based
on the quantile defined through \code{apl_quant}.}

\item{qcutoff}{The quantile cutoff for gene selection.}

\item{method}{Method to use for computing the cutoff.
Either "random" or "permutation".}

\item{counts}{The original count matrix that was used to compute the caobj.}

\item{apl_quant}{The quantile to use for the APL cutoff. Only used
if cutoff is \code{NULL}.
split and merge}

\item{min_cells}{Minimum number of cells to form a cluster.}

\item{epochs}{Number of iterations.}

\item{reps}{Number of repetitions to perform the splitting and merging.}

\item{apl_cutoff_reps}{The number of repetitions to use.
Should be between 3-10 for permutation, and >=100 for random.}

\item{make_plots}{Logical. If \code{TRUE} plots are generated for each}

\item{convergence_thr}{Angle between directions from different iterations in
degrees below or equal which convergence is reached.}

\item{max_iter}{Maximum number of iterations if no convergence.}

\item{init}{Initialization method for the lines. Options are 'rand' and
'kmeanspp'.}
}
\value{
A \code{cadir} object with cell clusters.
}
\description{
Perform Clustering by CA directions with splitting and merging.
}
\seealso{
\code{\link[=get_apl_cutoff]{get_apl_cutoff()}}
}
